package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyVnRedirection invokes the cloudcallcenter.ModifyVnRedirection API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyvnredirection.html
func (client *Client) ModifyVnRedirection(request *ModifyVnRedirectionRequest) (response *ModifyVnRedirectionResponse, err error) {
	response = CreateModifyVnRedirectionResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyVnRedirectionWithChan invokes the cloudcallcenter.ModifyVnRedirection API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyvnredirection.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyVnRedirectionWithChan(request *ModifyVnRedirectionRequest) (<-chan *ModifyVnRedirectionResponse, <-chan error) {
	responseChan := make(chan *ModifyVnRedirectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyVnRedirection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyVnRedirectionWithCallback invokes the cloudcallcenter.ModifyVnRedirection API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyvnredirection.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyVnRedirectionWithCallback(request *ModifyVnRedirectionRequest, callback func(response *ModifyVnRedirectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyVnRedirectionResponse
		var err error
		defer close(result)
		response, err = client.ModifyVnRedirection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyVnRedirectionRequest is the request struct for api ModifyVnRedirection
type ModifyVnRedirectionRequest struct {
	*requests.RpcRequest
	RedirectionType    string           `position:"Query" name:"RedirectionType"`
	UserUtterance      string           `position:"Query" name:"UserUtterance"`
	Interruptible      requests.Boolean `position:"Query" name:"Interruptible"`
	InstanceId         string           `position:"Query" name:"InstanceId"`
	NavigationScriptId string           `position:"Query" name:"NavigationScriptId"`
	SimilarUtterances  *[]string        `position:"Query" name:"SimilarUtterances"  type:"Repeated"`
	RedirectionTarget  string           `position:"Query" name:"RedirectionTarget"`
	Prompt             string           `position:"Query" name:"Prompt"`
}

// ModifyVnRedirectionResponse is the response struct for api ModifyVnRedirection
type ModifyVnRedirectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyVnRedirectionRequest creates a request to invoke ModifyVnRedirection API
func CreateModifyVnRedirectionRequest() (request *ModifyVnRedirectionRequest) {
	request = &ModifyVnRedirectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ModifyVnRedirection", "", "")
	request.Method = requests.GET
	return
}

// CreateModifyVnRedirectionResponse creates a response to parse from ModifyVnRedirection response
func CreateModifyVnRedirectionResponse() (response *ModifyVnRedirectionResponse) {
	response = &ModifyVnRedirectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
