package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMetaCategory invokes the dataworks_public.DeleteMetaCategory API synchronously
func (client *Client) DeleteMetaCategory(request *DeleteMetaCategoryRequest) (response *DeleteMetaCategoryResponse, err error) {
	response = CreateDeleteMetaCategoryResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMetaCategoryWithChan invokes the dataworks_public.DeleteMetaCategory API asynchronously
func (client *Client) DeleteMetaCategoryWithChan(request *DeleteMetaCategoryRequest) (<-chan *DeleteMetaCategoryResponse, <-chan error) {
	responseChan := make(chan *DeleteMetaCategoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMetaCategory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMetaCategoryWithCallback invokes the dataworks_public.DeleteMetaCategory API asynchronously
func (client *Client) DeleteMetaCategoryWithCallback(request *DeleteMetaCategoryRequest, callback func(response *DeleteMetaCategoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMetaCategoryResponse
		var err error
		defer close(result)
		response, err = client.DeleteMetaCategory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMetaCategoryRequest is the request struct for api DeleteMetaCategory
type DeleteMetaCategoryRequest struct {
	*requests.RpcRequest
	CategoryId requests.Integer `position:"Query" name:"CategoryId"`
}

// DeleteMetaCategoryResponse is the response struct for api DeleteMetaCategory
type DeleteMetaCategoryResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           bool   `json:"Data" xml:"Data"`
}

// CreateDeleteMetaCategoryRequest creates a request to invoke DeleteMetaCategory API
func CreateDeleteMetaCategoryRequest() (request *DeleteMetaCategoryRequest) {
	request = &DeleteMetaCategoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DeleteMetaCategory", "", "")
	request.Method = requests.GET
	return
}

// CreateDeleteMetaCategoryResponse creates a response to parse from DeleteMetaCategory response
func CreateDeleteMetaCategoryResponse() (response *DeleteMetaCategoryResponse) {
	response = &DeleteMetaCategoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
