package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListHBaseInstances invokes the hbase.ListHBaseInstances API synchronously
func (client *Client) ListHBaseInstances(request *ListHBaseInstancesRequest) (response *ListHBaseInstancesResponse, err error) {
	response = CreateListHBaseInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// ListHBaseInstancesWithChan invokes the hbase.ListHBaseInstances API asynchronously
func (client *Client) ListHBaseInstancesWithChan(request *ListHBaseInstancesRequest) (<-chan *ListHBaseInstancesResponse, <-chan error) {
	responseChan := make(chan *ListHBaseInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListHBaseInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListHBaseInstancesWithCallback invokes the hbase.ListHBaseInstances API asynchronously
func (client *Client) ListHBaseInstancesWithCallback(request *ListHBaseInstancesRequest, callback func(response *ListHBaseInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListHBaseInstancesResponse
		var err error
		defer close(result)
		response, err = client.ListHBaseInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListHBaseInstancesRequest is the request struct for api ListHBaseInstances
type ListHBaseInstancesRequest struct {
	*requests.RpcRequest
	VpcId string `position:"Query" name:"VpcId"`
}

// ListHBaseInstancesResponse is the response struct for api ListHBaseInstances
type ListHBaseInstancesResponse struct {
	*responses.BaseResponse
	RequestId string                        `json:"RequestId" xml:"RequestId"`
	Instances InstancesInListHBaseInstances `json:"Instances" xml:"Instances"`
}

// CreateListHBaseInstancesRequest creates a request to invoke ListHBaseInstances API
func CreateListHBaseInstancesRequest() (request *ListHBaseInstancesRequest) {
	request = &ListHBaseInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "ListHBaseInstances", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListHBaseInstancesResponse creates a response to parse from ListHBaseInstances response
func CreateListHBaseInstancesResponse() (response *ListHBaseInstancesResponse) {
	response = &ListHBaseInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
