package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteIpsecServer invokes the vpc.DeleteIpsecServer API synchronously
func (client *Client) DeleteIpsecServer(request *DeleteIpsecServerRequest) (response *DeleteIpsecServerResponse, err error) {
	response = CreateDeleteIpsecServerResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteIpsecServerWithChan invokes the vpc.DeleteIpsecServer API asynchronously
func (client *Client) DeleteIpsecServerWithChan(request *DeleteIpsecServerRequest) (<-chan *DeleteIpsecServerResponse, <-chan error) {
	responseChan := make(chan *DeleteIpsecServerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteIpsecServer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteIpsecServerWithCallback invokes the vpc.DeleteIpsecServer API asynchronously
func (client *Client) DeleteIpsecServerWithCallback(request *DeleteIpsecServerRequest, callback func(response *DeleteIpsecServerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteIpsecServerResponse
		var err error
		defer close(result)
		response, err = client.DeleteIpsecServer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteIpsecServerRequest is the request struct for api DeleteIpsecServer
type DeleteIpsecServerRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DryRun          string           `position:"Query" name:"DryRun"`
	ClientToken     string           `position:"Query" name:"ClientToken"`
	CallerBid       string           `position:"Query" name:"callerBid"`
	IpsecServerId   string           `position:"Query" name:"IpsecServerId"`
}

// DeleteIpsecServerResponse is the response struct for api DeleteIpsecServer
type DeleteIpsecServerResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteIpsecServerRequest creates a request to invoke DeleteIpsecServer API
func CreateDeleteIpsecServerRequest() (request *DeleteIpsecServerRequest) {
	request = &DeleteIpsecServerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteIpsecServer", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteIpsecServerResponse creates a response to parse from DeleteIpsecServer response
func CreateDeleteIpsecServerResponse() (response *DeleteIpsecServerResponse) {
	response = &DeleteIpsecServerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
