package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDeviceSnapshot invokes the vs.CreateDeviceSnapshot API synchronously
func (client *Client) CreateDeviceSnapshot(request *CreateDeviceSnapshotRequest) (response *CreateDeviceSnapshotResponse, err error) {
	response = CreateCreateDeviceSnapshotResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDeviceSnapshotWithChan invokes the vs.CreateDeviceSnapshot API asynchronously
func (client *Client) CreateDeviceSnapshotWithChan(request *CreateDeviceSnapshotRequest) (<-chan *CreateDeviceSnapshotResponse, <-chan error) {
	responseChan := make(chan *CreateDeviceSnapshotResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDeviceSnapshot(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDeviceSnapshotWithCallback invokes the vs.CreateDeviceSnapshot API asynchronously
func (client *Client) CreateDeviceSnapshotWithCallback(request *CreateDeviceSnapshotRequest, callback func(response *CreateDeviceSnapshotResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDeviceSnapshotResponse
		var err error
		defer close(result)
		response, err = client.CreateDeviceSnapshot(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDeviceSnapshotRequest is the request struct for api CreateDeviceSnapshot
type CreateDeviceSnapshotRequest struct {
	*requests.RpcRequest
	SnapshotConfig string           `position:"Query" name:"SnapshotConfig"`
	Mode           string           `position:"Query" name:"Mode"`
	ShowLog        string           `position:"Query" name:"ShowLog"`
	StreamId       string           `position:"Query" name:"StreamId"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	DeviceId       string           `position:"Query" name:"DeviceId"`
}

// CreateDeviceSnapshotResponse is the response struct for api CreateDeviceSnapshot
type CreateDeviceSnapshotResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateCreateDeviceSnapshotRequest creates a request to invoke CreateDeviceSnapshot API
func CreateCreateDeviceSnapshotRequest() (request *CreateDeviceSnapshotRequest) {
	request = &CreateDeviceSnapshotRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "CreateDeviceSnapshot", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDeviceSnapshotResponse creates a response to parse from CreateDeviceSnapshot response
func CreateCreateDeviceSnapshotResponse() (response *CreateDeviceSnapshotResponse) {
	response = &CreateDeviceSnapshotResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
