/*
 * Endpoint - Linux SBP2 Disk Target
 *
 * Copyright (C) 2003 Oracle.  All rights reserved.
 *
 * Author: Manish Singh <manish.singh@oracle.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 021110-1307, USA.
 */

#ifndef __SBP2_LOGIN_H__
#define __SBP2_LOGIN_H__


#include <glib.h>

#include <libsbp2/sbp2pointer.h>


typedef struct _SBP2LoginORB SBP2LoginORB;
typedef struct _SBP2LoginResponse SBP2LoginResponse;

struct _SBP2LoginORB
{
  SBP2Pointer password;
  SBP2Pointer login_resp;
#if G_BYTE_ORDER == G_BIG_ENDIAN
  guint       notify          : 1;
  guint       req_fmt         : 2;
  guint       exclusive       : 1;
  guint       reserved        : 4;
  guint       reconnect       : 4;
  guint       function        : 4;
  guint       lun             : 16;
  guint       password_length : 16;
  guint       resp_length     : 16;
#else
  guint       lun             : 16;
  guint       function        : 4;
  guint       reconnect       : 4;
  guint       reserved        : 4;
  guint       exclusive       : 1;
  guint       req_fmt         : 2;
  guint       notify          : 1;
  guint       resp_length     : 16;
  guint       password_length : 16;
#endif
  SBP2Pointer status_FIFO;
};

struct _SBP2LoginResponse
{
#if G_BYTE_ORDER == G_BIG_ENDIAN
  guint       length              : 16;
  guint       login_ID            : 16;
  SBP2Pointer command_block_agent;
  guint       reserved            : 16;
  guint       reconnect_hold      : 16;
#else
  guint       login_ID            : 16;
  guint       length              : 16;
  SBP2Pointer command_block_agent;
  guint       reconnect_hold      : 16;
  guint       reserved            : 16;
#endif
};


#endif /* __SBP2_LOGIN_H__ */
