/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.internal.inspector.ComponentPropertiesCollector;
import com.intellij.internal.inspector.PropertyBean;
import com.intellij.internal.inspector.UiInspectorActionUtil;
import com.intellij.internal.inspector.UiInspectorContextProvider;
import com.intellij.internal.inspector.UiInspectorListRendererContextProvider;
import com.intellij.internal.inspector.UiInspectorPreciseContextProvider;
import com.intellij.internal.inspector.UiInspectorTableRendererContextProvider;
import com.intellij.internal.inspector.UiInspectorTreeRendererContextProvider;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.internal.inspector.UiMouseAction;
import com.intellij.internal.inspector.components.HierarchyTree;
import com.intellij.internal.inspector.components.InspectorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionPromoter;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ExpandedItemListCellRendererWrapper;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class UiInspectorAction
extends UiMouseAction
implements LightEditCompatible,
ActionPromoter {
    private static final String ACTION_ID = "UiInspector";
    public static final String RENDERER_BOUNDS = "clicked renderer";
    public static final Key<DefaultMutableTreeNode> CLICK_INFO = Key.create((String)"CLICK_INFO");
    public static final Key<Point> CLICK_INFO_POINT = Key.create((String)"CLICK_INFO_POINT");

    public UiInspectorAction() {
        super(ACTION_ID);
    }

    @Override
    protected void handleClick(@NotNull Component component, @Nullable MouseEvent event) {
        if (component == null) {
            UiInspectorAction.$$$reportNull$$$0(0);
        }
        Project project2 = ProjectUtil.getProjectForComponent((Component)component);
        UiInspectorAction.closeAllInspectorWindows();
        if (event != null) {
            new UiInspector(project2).processMouseEvent(project2, event);
        } else {
            new UiInspector(project2).showInspector(project2, component);
        }
    }

    @NotNull
    public List<AnAction> promote(@NotNull List<? extends AnAction> actions, @NotNull DataContext context) {
        if (actions == null) {
            UiInspectorAction.$$$reportNull$$$0(1);
        }
        if (context == null) {
            UiInspectorAction.$$$reportNull$$$0(2);
        }
        List list2 = ContainerUtil.findAll(actions, o -> o != this);
        if (list2 == null) {
            UiInspectorAction.$$$reportNull$$$0(3);
        }
        return list2;
    }

    private static void closeAllInspectorWindows() {
        for (Window w : Window.getWindows()) {
            if (!(w instanceof InspectorWindow)) continue;
            Disposer.dispose((Disposable)((InspectorWindow)w).getInspector());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/inspector/UiInspectorAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/inspector/UiInspectorAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "promote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleClick";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "promote";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static final class UiInspector
    implements Disposable {
        UiInspector(@Nullable Project project2) {
            if (project2 != null) {
                Disposer.register((Disposable)project2, (Disposable)this);
            }
        }

        public void dispose() {
            for (Window window : Window.getWindows()) {
                if (!(window instanceof InspectorWindow)) continue;
                ((InspectorWindow)window).close();
            }
        }

        public void showInspector(@Nullable Project project2, @NotNull Component c) {
            if (c == null) {
                UiInspector.$$$reportNull$$$0(0);
            }
            InspectorWindow window = new InspectorWindow(project2, c, this);
            Disposer.register((Disposable)this, (Disposable)window);
            if (DimensionService.getInstance().getSize(InspectorWindow.getDimensionServiceKey(), null) == null) {
                window.pack();
            }
            window.setVisible(true);
            window.toFront();
        }

        private void processMouseEvent(Project project2, MouseEvent me) {
            me.consume();
            Component component = me.getComponent();
            if (component instanceof Container) {
                component = UIUtil.getDeepestComponentAt((Component)component, (int)me.getX(), (int)me.getY());
            } else if (component == null) {
                component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            }
            if (component != null) {
                if (component instanceof JComponent) {
                    JComponent jComp = (JComponent)component;
                    jComp.putClientProperty(CLICK_INFO, UiInspector.getClickInfoNode(me, jComp));
                    jComp.putClientProperty(CLICK_INFO_POINT, me.getPoint());
                }
                this.showInspector(project2, component);
            }
        }

        private static DefaultMutableTreeNode getClickInfoNode(MouseEvent me, JComponent component) {
            MouseEvent componentEvent;
            UiInspectorPreciseContextProvider contextProvider;
            UiInspectorPreciseContextProvider.UiInspectorInfo inspectorInfo;
            if (component instanceof UiInspectorPreciseContextProvider && (inspectorInfo = (contextProvider = (UiInspectorPreciseContextProvider)component).getUiInspectorContext(componentEvent = MouseEventAdapter.convert((MouseEvent)me, (Component)component))) != null) {
                String name = (String)ObjectUtils.chooseNotNull((Object)inspectorInfo.name(), (Object)"Click Info");
                HierarchyTree.ComponentNode node = HierarchyTree.ComponentNode.createNamedNode(name, inspectorInfo.component());
                if (inspectorInfo.component() != null) {
                    inspectorInfo.component().doLayout();
                }
                node.setUserObject(inspectorInfo.values());
                return node;
            }
            Pair<List<PropertyBean>, @NotNull Component> clickInfo = UiInspector.getClickInfo(me, component);
            if (clickInfo != null) {
                HierarchyTree.ComponentNode node = HierarchyTree.ComponentNode.createComponentNode((Component)clickInfo.second);
                ((Component)clickInfo.second).doLayout();
                node.setUserObject(clickInfo.first);
                return node;
            }
            return null;
        }

        private static Pair<List<PropertyBean>, @NotNull Component> getClickInfo(MouseEvent me, Component component) {
            JTree tree;
            TreePath path;
            JList list2;
            int row;
            if (me.getComponent() == null) {
                return null;
            }
            me = SwingUtilities.convertMouseEvent(me.getComponent(), me, component);
            ArrayList<PropertyBean> clickInfo = new ArrayList<PropertyBean>();
            if (component instanceof JList && (row = (list2 = (JList)component).getUI().locationToIndex(list2, me.getPoint())) != -1) {
                UiInspectorListRendererContextProvider contextProvider;
                Object value = list2.getModel().getElementAt(row);
                ListCellRenderer renderer = ExpandedItemListCellRendererWrapper.unwrap(list2.getCellRenderer());
                if (renderer instanceof UiInspectorListRendererContextProvider) {
                    contextProvider = (UiInspectorListRendererContextProvider)renderer;
                    clickInfo.addAll(contextProvider.getUiInspectorContext(list2, value, row));
                }
                if (value instanceof UiInspectorContextProvider) {
                    contextProvider = (UiInspectorContextProvider)value;
                    clickInfo.addAll(contextProvider.getUiInspectorContext());
                }
                clickInfo.addAll(UiInspector.findActionsFor(value));
                clickInfo.add(new PropertyBean("List Value", value));
                clickInfo.add(new PropertyBean("List Value Class", (Object)UiInspectorUtil.getClassPresentation(value)));
                Component rendererComponent = renderer.getListCellRendererComponent(list2, value, row, list2.getSelectionModel().isSelectedIndex(row), list2.hasFocus());
                rendererComponent.setBounds(list2.getCellBounds(row, row));
                clickInfo.add(new PropertyBean(UiInspectorAction.RENDERER_BOUNDS, (Object)list2.getUI().getCellBounds(list2, row, row)));
                clickInfo.addAll(ComponentPropertiesCollector.collect(rendererComponent));
                return Pair.create(clickInfo, (Object)rendererComponent);
            }
            if (component instanceof JTable) {
                JTable table = (JTable)component;
                row = table.rowAtPoint(me.getPoint());
                int column = table.columnAtPoint(me.getPoint());
                if (row != -1 && column != -1) {
                    UiInspectorTableRendererContextProvider contextProvider;
                    Object value = table.getValueAt(row, column);
                    TableCellRenderer renderer = table.getCellRenderer(row, column);
                    if (renderer instanceof UiInspectorTableRendererContextProvider) {
                        contextProvider = (UiInspectorTableRendererContextProvider)renderer;
                        clickInfo.addAll(contextProvider.getUiInspectorContext(table, value, row, column));
                    }
                    if (value instanceof UiInspectorContextProvider) {
                        contextProvider = (UiInspectorContextProvider)value;
                        clickInfo.addAll(contextProvider.getUiInspectorContext());
                    }
                    if (component instanceof TreeTable) {
                        DefaultMutableTreeNode mutableTreeNode;
                        Object object;
                        UiInspectorTreeRendererContextProvider contextProvider2;
                        TreeTable treeTable = (TreeTable)component;
                        TreeTableTree tree2 = treeTable.getTree();
                        TreeCellRenderer treeRenderer = tree2.getOriginalCellRenderer();
                        int treeRow = treeTable.convertRowIndexToModel(row);
                        Object treeValue = tree2.getPathForRow(treeRow).getLastPathComponent();
                        if (treeRenderer instanceof UiInspectorTreeRendererContextProvider) {
                            contextProvider2 = (UiInspectorTreeRendererContextProvider)treeRenderer;
                            clickInfo.addAll(contextProvider2.getUiInspectorContext((JTree)tree2, treeValue, treeRow));
                        }
                        if (treeValue instanceof UiInspectorContextProvider) {
                            contextProvider2 = (UiInspectorContextProvider)treeValue;
                            clickInfo.addAll(contextProvider2.getUiInspectorContext());
                        }
                        if (treeValue instanceof DefaultMutableTreeNode && (object = (mutableTreeNode = (DefaultMutableTreeNode)treeValue).getUserObject()) instanceof UiInspectorContextProvider) {
                            UiInspectorContextProvider contextProvider3 = (UiInspectorContextProvider)object;
                            clickInfo.addAll(contextProvider3.getUiInspectorContext());
                        }
                    }
                    clickInfo.add(new PropertyBean("Cell Value", value));
                    clickInfo.add(new PropertyBean("Cell Value Class", (Object)UiInspectorUtil.getClassPresentation((Object)value)));
                    Component rendererComponent = renderer.getTableCellRendererComponent(table, value, table.getSelectionModel().isSelectedIndex(row), table.hasFocus(), row, column);
                    rendererComponent.setBounds(table.getCellRect(row, column, false));
                    clickInfo.add(new PropertyBean(UiInspectorAction.RENDERER_BOUNDS, (Object)table.getCellRect(row, column, true)));
                    clickInfo.addAll(ComponentPropertiesCollector.collect(rendererComponent));
                    return Pair.create(clickInfo, (Object)rendererComponent);
                }
            }
            if (component instanceof JTree && (path = (tree = (JTree)component).getClosestPathForLocation(me.getX(), me.getY())) != null) {
                DefaultMutableTreeNode mutableTreeNode;
                Object object;
                UiInspectorTreeRendererContextProvider contextProvider;
                int row2 = tree.getRowForPath(path);
                Object value = path.getLastPathComponent();
                TreeCellRenderer renderer = tree.getCellRenderer();
                if (renderer instanceof UiInspectorTreeRendererContextProvider) {
                    contextProvider = (UiInspectorTreeRendererContextProvider)renderer;
                    clickInfo.addAll(contextProvider.getUiInspectorContext(tree, value, row2));
                }
                if (value instanceof UiInspectorContextProvider) {
                    contextProvider = (UiInspectorContextProvider)value;
                    clickInfo.addAll(contextProvider.getUiInspectorContext());
                }
                if (value instanceof DefaultMutableTreeNode && (object = (mutableTreeNode = (DefaultMutableTreeNode)value).getUserObject()) instanceof UiInspectorContextProvider) {
                    UiInspectorContextProvider contextProvider4 = (UiInspectorContextProvider)object;
                    clickInfo.addAll(contextProvider4.getUiInspectorContext());
                }
                clickInfo.add(new PropertyBean("Tree Node", value));
                clickInfo.add(new PropertyBean("Tree Node Class", (Object)UiInspectorUtil.getClassPresentation((Object)value)));
                Component rendererComponent = renderer.getTreeCellRendererComponent(tree, value, tree.getSelectionModel().isPathSelected(path), tree.isExpanded(path), tree.getModel().isLeaf(value), row2, tree.hasFocus());
                rendererComponent.setBounds(tree.getPathBounds(path));
                clickInfo.add(new PropertyBean(UiInspectorAction.RENDERER_BOUNDS, (Object)tree.getPathBounds(path)));
                clickInfo.addAll(ComponentPropertiesCollector.collect(rendererComponent));
                return Pair.create(clickInfo, (Object)rendererComponent);
            }
            return null;
        }

        private static List<PropertyBean> findActionsFor(Object object) {
            if (object instanceof PopupFactoryImpl.ActionItem) {
                PopupFactoryImpl.ActionItem item = (PopupFactoryImpl.ActionItem)object;
                AnAction action = item.getAction();
                return UiInspectorActionUtil.INSTANCE.collectAnActionInfo(action);
            }
            if (object instanceof IntentionActionDelegate) {
                IntentionActionDelegate actionDelegate = (IntentionActionDelegate)object;
                IntentionAction delegate = IntentionActionDelegate.unwrap((IntentionAction)actionDelegate.getDelegate());
                if (delegate != object) {
                    return UiInspector.findActionsFor(delegate);
                }
            } else {
                if (object instanceof IntentionAction) {
                    IntentionAction action = (IntentionAction)object;
                    LocalQuickFix quickFix = QuickFixWrapper.unwrap((CommonIntentionAction)action);
                    if (quickFix != null) {
                        return UiInspector.findActionsFor(quickFix);
                    }
                    return Collections.singletonList(new PropertyBean("intention action", (Object)UiInspectorUtil.getClassPresentation((Object)object), true));
                }
                if (object instanceof QuickFix) {
                    return Collections.singletonList(new PropertyBean("quick fix", (Object)UiInspectorUtil.getClassPresentation((Object)object), true));
                }
            }
            return Collections.emptyList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/internal/inspector/UiInspectorAction$UiInspector", "showInspector"));
        }
    }
}

