/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.stubs;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.StringRef;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.impl.PyFileImpl;
import com.jetbrains.python.psi.stubs.PyFileStub;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyFileStubImpl
extends PsiFileStubImpl<PyFile>
implements PyFileStub {
    private final List<String> myDunderAll;
    private final BitSet myFutureFeatures;
    private final StringRef myDeprecationMessage;
    private static final int FUTURE_FEATURE_SET_SIZE = 32;

    public PyFileStubImpl(PyFile file) {
        super((PsiFile)file);
        PyFileImpl fileImpl = (PyFileImpl)file;
        this.myFutureFeatures = new BitSet(32);
        this.myDunderAll = fileImpl.calculateDunderAll();
        for (FutureFeature fuf : FutureFeature.values()) {
            this.myFutureFeatures.set(fuf.ordinal(), fileImpl.calculateImportFromFuture(fuf));
        }
        String message = fileImpl.extractDeprecationMessage();
        this.myDeprecationMessage = message == null ? null : StringRef.fromString((String)message);
    }

    public PyFileStubImpl(List<String> dunderAll, BitSet future_features, StringRef deprecationMessage) {
        super(null);
        this.myDunderAll = dunderAll;
        this.myFutureFeatures = future_features;
        this.myDeprecationMessage = deprecationMessage;
    }

    @Override
    public List<String> getDunderAll() {
        return this.myDunderAll;
    }

    @Override
    public BitSet getFutureFeatures() {
        return this.myFutureFeatures;
    }

    @Override
    public String getDeprecationMessage() {
        return this.myDeprecationMessage == null ? null : this.myDeprecationMessage.getString();
    }

    @NotNull
    public IStubFileElementType<?> getType() {
        IStubFileElementType iStubFileElementType = (IStubFileElementType)((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)PythonLanguage.getInstance())).getFileNodeType();
        if (iStubFileElementType == null) {
            PyFileStubImpl.$$$reportNull$$$0(0);
        }
        return iStubFileElementType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/stubs/PyFileStubImpl", "getType"));
    }
}

