/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.conda;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.Product;
import com.jetbrains.python.sdk.Release;
import com.jetbrains.python.sdk.Resource;
import com.jetbrains.python.sdk.ResourceType;
import com.jetbrains.python.sdk.SdksKeeper;
import com.jetbrains.python.sdk.conda.CondaInstallManager;
import com.jetbrains.python.sdk.installer.BinaryInstallation;
import com.jetbrains.python.sdk.installer.BinaryInstallerKt;
import com.jetbrains.python.sdk.installer.MakeShellScriptExecutableException;
import com.jetbrains.python.sdk.installer.ResourceTypeBinaryInstaller;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0002\u0005\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0013\u001a\u00020\fH\u0007R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/sdk/conda/CondaInstallManager;", "", "<init>", "()V", "shellScriptInstaller", "com/jetbrains/python/sdk/conda/CondaInstallManager$shellScriptInstaller$1", "Lcom/jetbrains/python/sdk/conda/CondaInstallManager$shellScriptInstaller$1;", "applePkgInstaller", "com/jetbrains/python/sdk/conda/CondaInstallManager$applePkgInstaller$1", "Lcom/jetbrains/python/sdk/conda/CondaInstallManager$applePkgInstaller$1;", "productInstallers", "", "Lcom/jetbrains/python/sdk/Product;", "", "Lcom/jetbrains/python/sdk/installer/ResourceTypeBinaryInstaller;", "installLatest", "", "project", "Lcom/intellij/openapi/project/Project;", "product", "WindowsInstaller", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nCondaInstallManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CondaInstallManager.kt\ncom/jetbrains/python/sdk/conda/CondaInstallManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1#2:100\n1971#3,5:101\n543#3,6:106\n1977#3,2:112\n543#3,6:114\n1979#3,6:120\n*S KotlinDebug\n*F\n+ 1 CondaInstallManager.kt\ncom/jetbrains/python/sdk/conda/CondaInstallManager\n*L\n86#1:101,5\n87#1:106,6\n86#1:112,2\n87#1:114,6\n86#1:120,6\n*E\n"})
public final class CondaInstallManager {
    @NotNull
    public static final CondaInstallManager INSTANCE = new CondaInstallManager();
    @NotNull
    private static final shellScriptInstaller.1 shellScriptInstaller;
    @NotNull
    private static final applePkgInstaller.1 applePkgInstaller;
    @NotNull
    private static final Map<Product, List<ResourceTypeBinaryInstaller>> productInstallers;

    private CondaInstallManager() {
    }

    @RequiresEdt
    public final void installLatest(@Nullable Project project, @NotNull Product product) {
        Object v3;
        Intrinsics.checkNotNullParameter((Object)((Object)product), (String)"product");
        Object object = new Product[]{product};
        Release release = (Release)CollectionsKt.firstOrNull(SdksKeeper.INSTANCE.condaReleases((Product[])object));
        if (release == null) {
            throw new IllegalStateException(("There is no available conda releases of the product " + product).toString());
        }
        object = productInstallers;
        Release latestRelease = release;
        Object object2 = object.get((Object)latestRelease.getProduct());
        if (object2 == null) {
            boolean bl = false;
            object2 = CollectionsKt.emptyList();
        }
        List installers = (List)object2;
        List<BinaryInstallation> installations = BinaryInstallerKt.selectInstallations(latestRelease, installers);
        List list = LanguageLevel.SUPPORTED_LEVELS;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"SUPPORTED_LEVELS");
        LanguageLevel unknownLevel = (LanguageLevel)CollectionsKt.first((List)list);
        Iterable $this$maxByOrNull$iv = installations;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v3 = maxElem$iv;
            } else {
                LanguageLevel languageLevel;
                Object v6;
                block16: {
                    BinaryInstallation bi = (BinaryInstallation)maxElem$iv;
                    boolean bl = false;
                    List list2 = LanguageLevel.SUPPORTED_LEVELS;
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"SUPPORTED_LEVELS");
                    List $this$lastOrNull$iv = list2;
                    boolean $i$f$lastOrNull = false;
                    ListIterator iterator$iv2 = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv2.hasPrevious()) {
                        boolean bl2;
                        Object element$iv = iterator$iv2.previous();
                        LanguageLevel level = (LanguageLevel)element$iv;
                        boolean bl3 = false;
                        if (bi.getBinary().getTags() != null) {
                            List<String> tags;
                            boolean bl4 = false;
                            bl2 = tags.contains(level.name());
                        } else {
                            bl2 = false;
                        }
                        if (!bl2) continue;
                        v6 = element$iv;
                        break block16;
                    }
                    v6 = null;
                }
                if ((languageLevel = (LanguageLevel)v6) == null) {
                    languageLevel = unknownLevel;
                }
                Comparable maxValue$iv = (Comparable)languageLevel;
                do {
                    Comparable v$iv;
                    LanguageLevel languageLevel2;
                    Object v9;
                    Object e$iv;
                    block17: {
                        List $this$lastOrNull$iv;
                        e$iv = iterator$iv.next();
                        BinaryInstallation bi = (BinaryInstallation)e$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)LanguageLevel.SUPPORTED_LEVELS, (String)"SUPPORTED_LEVELS");
                        boolean $i$f$lastOrNull = false;
                        ListIterator iterator$iv3 = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                        while (iterator$iv3.hasPrevious()) {
                            boolean bl5;
                            Object element$iv = iterator$iv3.previous();
                            LanguageLevel level = (LanguageLevel)element$iv;
                            boolean bl6 = false;
                            if (bi.getBinary().getTags() != null) {
                                List<String> tags;
                                boolean bl7 = false;
                                bl5 = tags.contains(level.name());
                            } else {
                                bl5 = false;
                            }
                            if (!bl5) continue;
                            v9 = element$iv;
                            break block17;
                        }
                        v9 = null;
                    }
                    if ((languageLevel2 = (LanguageLevel)v9) == null) {
                        languageLevel2 = unknownLevel;
                    }
                    if (maxValue$iv.compareTo(v$iv = (Comparable)languageLevel2) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v3 = maxElem$iv;
            }
        }
        BinaryInstallation installationWithHighestPython = v3;
        if (installationWithHighestPython == null) {
            throw new IllegalStateException(("There is no supported conda installation for the release " + latestRelease).toString());
        }
        BinaryInstallerKt.installBinary$default(installationWithHighestPython, project, null, 4, null);
    }

    public static /* synthetic */ void installLatest$default(CondaInstallManager condaInstallManager, Project project, Product product, int n, Object object) {
        if ((n & 2) != 0) {
            product = Product.Miniconda;
        }
        condaInstallManager.installLatest(project, product);
    }

    static {
        Pair[] pairArray = ResourceType.SHELL_SCRIPT;
        shellScriptInstaller = new ResourceTypeBinaryInstaller((ResourceType)pairArray){

            public GeneralCommandLine buildCommandLine(Resource resource, Path path2) {
                Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                if (!path2.toFile().setExecutable(true, true)) {
                    throw new MakeShellScriptExecutableException(path2);
                }
                String[] stringArray = new String[]{((Object)path2.toAbsolutePath()).toString(), "-b", "-u"};
                return new GeneralCommandLine(stringArray);
            }
        };
        pairArray = ResourceType.APPLE_SOFTWARE_PACKAGE;
        applePkgInstaller = new ResourceTypeBinaryInstaller((ResourceType)pairArray){

            public GeneralCommandLine buildCommandLine(Resource resource, Path path2) {
                Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                String[] stringArray = new String[]{"installer", "-pkg", ((Object)path2.toAbsolutePath()).toString(), "-target", "CurrentUserHomeDirectory"};
                return new GeneralCommandLine(stringArray);
            }
        };
        pairArray = new Pair[2];
        Object[] objectArray = new ResourceTypeBinaryInstaller[]{new WindowsInstaller("%UserProfile%\\miniconda3"), shellScriptInstaller, applePkgInstaller};
        pairArray[0] = TuplesKt.to((Object)((Object)Product.Miniconda), (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new ResourceTypeBinaryInstaller[]{new WindowsInstaller("%UserProfile%\\anaconda3"), shellScriptInstaller, applePkgInstaller};
        pairArray[1] = TuplesKt.to((Object)((Object)Product.Anaconda), (Object)CollectionsKt.listOf((Object[])objectArray));
        productInstallers = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/sdk/conda/CondaInstallManager$WindowsInstaller;", "Lcom/jetbrains/python/sdk/installer/ResourceTypeBinaryInstaller;", "installPath", "", "<init>", "(Ljava/lang/String;)V", "buildCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "resource", "Lcom/jetbrains/python/sdk/Resource;", "path", "Ljava/nio/file/Path;", "intellij.python.community.impl"})
    public static final class WindowsInstaller
    extends ResourceTypeBinaryInstaller {
        @NotNull
        private final String installPath;

        public WindowsInstaller(@NotNull String installPath) {
            Intrinsics.checkNotNullParameter((Object)installPath, (String)"installPath");
            super(ResourceType.MICROSOFT_WINDOWS_EXECUTABLE);
            this.installPath = installPath;
        }

        @Override
        @NotNull
        public GeneralCommandLine buildCommandLine(@NotNull Resource resource, @NotNull Path path2) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            String[] stringArray = new String[]{((Object)path2.toAbsolutePath()).toString(), "/InstallationType=JustMe", "/AddToPath=0", "/RegisterPython=0", "/S", "/D=" + this.installPath};
            return new GeneralCommandLine(stringArray);
        }
    }
}

