// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/featurestore_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_FEATURESTORE_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_FEATURESTORE_CONNECTION_IMPL_H

#include "google/cloud/aiplatform/v1/featurestore_connection.h"
#include "google/cloud/aiplatform/v1/featurestore_connection_idempotency_policy.h"
#include "google/cloud/aiplatform/v1/featurestore_options.h"
#include "google/cloud/aiplatform/v1/internal/featurestore_retry_traits.h"
#include "google/cloud/aiplatform/v1/internal/featurestore_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class FeaturestoreServiceConnectionImpl
    : public aiplatform_v1::FeaturestoreServiceConnection {
 public:
  ~FeaturestoreServiceConnectionImpl() override = default;

  FeaturestoreServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<aiplatform_v1_internal::FeaturestoreServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  future<StatusOr<google::cloud::aiplatform::v1::Featurestore>>
  CreateFeaturestore(
      google::cloud::aiplatform::v1::CreateFeaturestoreRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateFeaturestore(
      NoAwaitTag,
      google::cloud::aiplatform::v1::CreateFeaturestoreRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::Featurestore>>
  CreateFeaturestore(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::Featurestore> GetFeaturestore(
      google::cloud::aiplatform::v1::GetFeaturestoreRequest const& request)
      override;

  StreamRange<google::cloud::aiplatform::v1::Featurestore> ListFeaturestores(
      google::cloud::aiplatform::v1::ListFeaturestoresRequest request) override;

  future<StatusOr<google::cloud::aiplatform::v1::Featurestore>>
  UpdateFeaturestore(
      google::cloud::aiplatform::v1::UpdateFeaturestoreRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateFeaturestore(
      NoAwaitTag,
      google::cloud::aiplatform::v1::UpdateFeaturestoreRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::Featurestore>>
  UpdateFeaturestore(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteFeaturestore(
      google::cloud::aiplatform::v1::DeleteFeaturestoreRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteFeaturestore(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteFeaturestoreRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteFeaturestore(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::EntityType>> CreateEntityType(
      google::cloud::aiplatform::v1::CreateEntityTypeRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateEntityType(
      NoAwaitTag,
      google::cloud::aiplatform::v1::CreateEntityTypeRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::EntityType>> CreateEntityType(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::EntityType> GetEntityType(
      google::cloud::aiplatform::v1::GetEntityTypeRequest const& request)
      override;

  StreamRange<google::cloud::aiplatform::v1::EntityType> ListEntityTypes(
      google::cloud::aiplatform::v1::ListEntityTypesRequest request) override;

  StatusOr<google::cloud::aiplatform::v1::EntityType> UpdateEntityType(
      google::cloud::aiplatform::v1::UpdateEntityTypeRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteEntityType(google::cloud::aiplatform::v1::DeleteEntityTypeRequest const&
                       request) override;

  StatusOr<google::longrunning::Operation> DeleteEntityType(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteEntityTypeRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteEntityType(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::Feature>> CreateFeature(
      google::cloud::aiplatform::v1::CreateFeatureRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateFeature(
      NoAwaitTag,
      google::cloud::aiplatform::v1::CreateFeatureRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::Feature>> CreateFeature(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::BatchCreateFeaturesResponse>>
  BatchCreateFeatures(
      google::cloud::aiplatform::v1::BatchCreateFeaturesRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> BatchCreateFeatures(
      NoAwaitTag,
      google::cloud::aiplatform::v1::BatchCreateFeaturesRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::BatchCreateFeaturesResponse>>
  BatchCreateFeatures(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::Feature> GetFeature(
      google::cloud::aiplatform::v1::GetFeatureRequest const& request) override;

  StreamRange<google::cloud::aiplatform::v1::Feature> ListFeatures(
      google::cloud::aiplatform::v1::ListFeaturesRequest request) override;

  StatusOr<google::cloud::aiplatform::v1::Feature> UpdateFeature(
      google::cloud::aiplatform::v1::UpdateFeatureRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteFeature(google::cloud::aiplatform::v1::DeleteFeatureRequest const&
                    request) override;

  StatusOr<google::longrunning::Operation> DeleteFeature(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteFeatureRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteFeature(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::ImportFeatureValuesResponse>>
  ImportFeatureValues(
      google::cloud::aiplatform::v1::ImportFeatureValuesRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> ImportFeatureValues(
      NoAwaitTag,
      google::cloud::aiplatform::v1::ImportFeatureValuesRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::ImportFeatureValuesResponse>>
  ImportFeatureValues(google::longrunning::Operation const& operation) override;

  future<
      StatusOr<google::cloud::aiplatform::v1::BatchReadFeatureValuesResponse>>
  BatchReadFeatureValues(
      google::cloud::aiplatform::v1::BatchReadFeatureValuesRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> BatchReadFeatureValues(
      NoAwaitTag,
      google::cloud::aiplatform::v1::BatchReadFeatureValuesRequest const&
          request) override;

  future<
      StatusOr<google::cloud::aiplatform::v1::BatchReadFeatureValuesResponse>>
  BatchReadFeatureValues(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::ExportFeatureValuesResponse>>
  ExportFeatureValues(
      google::cloud::aiplatform::v1::ExportFeatureValuesRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> ExportFeatureValues(
      NoAwaitTag,
      google::cloud::aiplatform::v1::ExportFeatureValuesRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::ExportFeatureValuesResponse>>
  ExportFeatureValues(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteFeatureValuesResponse>>
  DeleteFeatureValues(
      google::cloud::aiplatform::v1::DeleteFeatureValuesRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteFeatureValues(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteFeatureValuesRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteFeatureValuesResponse>>
  DeleteFeatureValues(google::longrunning::Operation const& operation) override;

  StreamRange<google::cloud::aiplatform::v1::Feature> SearchFeatures(
      google::cloud::aiplatform::v1::SearchFeaturesRequest request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<aiplatform_v1_internal::FeaturestoreServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_FEATURESTORE_CONNECTION_IMPL_H
