// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto

#include "google/cloud/beyondcorp/appgateways/v1/app_gateways_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace beyondcorp_appgateways_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AppGatewaysServiceClient::AppGatewaysServiceClient(
    std::shared_ptr<AppGatewaysServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
AppGatewaysServiceClient::~AppGatewaysServiceClient() = default;

StreamRange<google::cloud::beyondcorp::appgateways::v1::AppGateway>
AppGatewaysServiceClient::ListAppGateways(std::string const& parent,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::beyondcorp::appgateways::v1::ListAppGatewaysRequest request;
  request.set_parent(parent);
  return connection_->ListAppGateways(request);
}

StreamRange<google::cloud::beyondcorp::appgateways::v1::AppGateway>
AppGatewaysServiceClient::ListAppGateways(
    google::cloud::beyondcorp::appgateways::v1::ListAppGatewaysRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListAppGateways(std::move(request));
}

StatusOr<google::cloud::beyondcorp::appgateways::v1::AppGateway>
AppGatewaysServiceClient::GetAppGateway(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::beyondcorp::appgateways::v1::GetAppGatewayRequest request;
  request.set_name(name);
  return connection_->GetAppGateway(request);
}

StatusOr<google::cloud::beyondcorp::appgateways::v1::AppGateway>
AppGatewaysServiceClient::GetAppGateway(
    google::cloud::beyondcorp::appgateways::v1::GetAppGatewayRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetAppGateway(request);
}

future<StatusOr<google::cloud::beyondcorp::appgateways::v1::AppGateway>>
AppGatewaysServiceClient::CreateAppGateway(
    std::string const& parent,
    google::cloud::beyondcorp::appgateways::v1::AppGateway const& app_gateway,
    std::string const& app_gateway_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::beyondcorp::appgateways::v1::CreateAppGatewayRequest request;
  request.set_parent(parent);
  *request.mutable_app_gateway() = app_gateway;
  request.set_app_gateway_id(app_gateway_id);
  return connection_->CreateAppGateway(request);
}

StatusOr<google::longrunning::Operation>
AppGatewaysServiceClient::CreateAppGateway(
    NoAwaitTag, std::string const& parent,
    google::cloud::beyondcorp::appgateways::v1::AppGateway const& app_gateway,
    std::string const& app_gateway_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::beyondcorp::appgateways::v1::CreateAppGatewayRequest request;
  request.set_parent(parent);
  *request.mutable_app_gateway() = app_gateway;
  request.set_app_gateway_id(app_gateway_id);
  return connection_->CreateAppGateway(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::beyondcorp::appgateways::v1::AppGateway>>
AppGatewaysServiceClient::CreateAppGateway(
    google::cloud::beyondcorp::appgateways::v1::CreateAppGatewayRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAppGateway(request);
}

StatusOr<google::longrunning::Operation>
AppGatewaysServiceClient::CreateAppGateway(
    NoAwaitTag,
    google::cloud::beyondcorp::appgateways::v1::CreateAppGatewayRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAppGateway(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::beyondcorp::appgateways::v1::AppGateway>>
AppGatewaysServiceClient::CreateAppGateway(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateAppGateway(operation);
}

future<StatusOr<
    google::cloud::beyondcorp::appgateways::v1::AppGatewayOperationMetadata>>
AppGatewaysServiceClient::DeleteAppGateway(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::beyondcorp::appgateways::v1::DeleteAppGatewayRequest request;
  request.set_name(name);
  return connection_->DeleteAppGateway(request);
}

StatusOr<google::longrunning::Operation>
AppGatewaysServiceClient::DeleteAppGateway(NoAwaitTag, std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::beyondcorp::appgateways::v1::DeleteAppGatewayRequest request;
  request.set_name(name);
  return connection_->DeleteAppGateway(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::beyondcorp::appgateways::v1::AppGatewayOperationMetadata>>
AppGatewaysServiceClient::DeleteAppGateway(
    google::cloud::beyondcorp::appgateways::v1::DeleteAppGatewayRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAppGateway(request);
}

StatusOr<google::longrunning::Operation>
AppGatewaysServiceClient::DeleteAppGateway(
    NoAwaitTag,
    google::cloud::beyondcorp::appgateways::v1::DeleteAppGatewayRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAppGateway(NoAwaitTag{}, request);
}

future<StatusOr<
    google::cloud::beyondcorp::appgateways::v1::AppGatewayOperationMetadata>>
AppGatewaysServiceClient::DeleteAppGateway(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAppGateway(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace beyondcorp_appgateways_v1
}  // namespace cloud
}  // namespace google
