// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/future_reservations/v1/future_reservations.proto

#include "google/cloud/compute/future_reservations/v1/internal/future_reservations_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_future_reservations_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

FutureReservationsTracingConnection::FutureReservationsTracingConnection(
    std::shared_ptr<
        compute_future_reservations_v1::FutureReservationsConnection>
        child)
    : child_(std::move(child)) {}

StreamRange<std::pair<
    std::string, google::cloud::cpp::compute::v1::FutureReservationsScopedList>>
FutureReservationsTracingConnection::AggregatedListFutureReservations(
    google::cloud::cpp::compute::future_reservations::v1::
        AggregatedListFutureReservationsRequest request) {
  auto span = internal::MakeSpan(
      "compute_future_reservations_v1::FutureReservationsConnection::"
      "AggregatedListFutureReservations");
  internal::OTelScope scope(span);
  auto sr = child_->AggregatedListFutureReservations(std::move(request));
  return internal::MakeTracedStreamRange<
      std::pair<std::string,
                google::cloud::cpp::compute::v1::FutureReservationsScopedList>>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsTracingConnection::Cancel(
    google::cloud::cpp::compute::future_reservations::v1::CancelRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_future_reservations_v1::FutureReservationsConnection::Cancel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->Cancel(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsTracingConnection::Cancel(
    NoAwaitTag,
    google::cloud::cpp::compute::future_reservations::v1::CancelRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_future_reservations_v1::FutureReservationsConnection::Cancel");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->Cancel(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsTracingConnection::Cancel(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_future_reservations_v1::FutureReservationsConnection::Cancel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->Cancel(operation));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsTracingConnection::DeleteFutureReservation(
    google::cloud::cpp::compute::future_reservations::v1::
        DeleteFutureReservationRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_future_reservations_v1::FutureReservationsConnection::"
      "DeleteFutureReservation");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteFutureReservation(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsTracingConnection::DeleteFutureReservation(
    NoAwaitTag, google::cloud::cpp::compute::future_reservations::v1::
                    DeleteFutureReservationRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_future_reservations_v1::FutureReservationsConnection::"
      "DeleteFutureReservation");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeleteFutureReservation(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsTracingConnection::DeleteFutureReservation(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_future_reservations_v1::FutureReservationsConnection::"
      "DeleteFutureReservation");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteFutureReservation(operation));
}

StatusOr<google::cloud::cpp::compute::v1::FutureReservation>
FutureReservationsTracingConnection::GetFutureReservation(
    google::cloud::cpp::compute::future_reservations::v1::
        GetFutureReservationRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_future_reservations_v1::FutureReservationsConnection::"
      "GetFutureReservation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetFutureReservation(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsTracingConnection::InsertFutureReservation(
    google::cloud::cpp::compute::future_reservations::v1::
        InsertFutureReservationRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_future_reservations_v1::FutureReservationsConnection::"
      "InsertFutureReservation");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->InsertFutureReservation(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsTracingConnection::InsertFutureReservation(
    NoAwaitTag, google::cloud::cpp::compute::future_reservations::v1::
                    InsertFutureReservationRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_future_reservations_v1::FutureReservationsConnection::"
      "InsertFutureReservation");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->InsertFutureReservation(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsTracingConnection::InsertFutureReservation(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_future_reservations_v1::FutureReservationsConnection::"
      "InsertFutureReservation");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->InsertFutureReservation(operation));
}

StreamRange<google::cloud::cpp::compute::v1::FutureReservation>
FutureReservationsTracingConnection::ListFutureReservations(
    google::cloud::cpp::compute::future_reservations::v1::
        ListFutureReservationsRequest request) {
  auto span = internal::MakeSpan(
      "compute_future_reservations_v1::FutureReservationsConnection::"
      "ListFutureReservations");
  internal::OTelScope scope(span);
  auto sr = child_->ListFutureReservations(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::FutureReservation>(std::move(span),
                                                          std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsTracingConnection::UpdateFutureReservation(
    google::cloud::cpp::compute::future_reservations::v1::
        UpdateFutureReservationRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_future_reservations_v1::FutureReservationsConnection::"
      "UpdateFutureReservation");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateFutureReservation(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsTracingConnection::UpdateFutureReservation(
    NoAwaitTag, google::cloud::cpp::compute::future_reservations::v1::
                    UpdateFutureReservationRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_future_reservations_v1::FutureReservationsConnection::"
      "UpdateFutureReservation");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->UpdateFutureReservation(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsTracingConnection::UpdateFutureReservation(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_future_reservations_v1::FutureReservationsConnection::"
      "UpdateFutureReservation");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateFutureReservation(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_future_reservations_v1::FutureReservationsConnection>
MakeFutureReservationsTracingConnection(
    std::shared_ptr<
        compute_future_reservations_v1::FutureReservationsConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<FutureReservationsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_future_reservations_v1_internal
}  // namespace cloud
}  // namespace google
