// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/interconnects/v1/interconnects.proto

#include "google/cloud/compute/interconnects/v1/internal/interconnects_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_interconnects_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

InterconnectsTracingConnection::InterconnectsTracingConnection(
    std::shared_ptr<compute_interconnects_v1::InterconnectsConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InterconnectsTracingConnection::DeleteInterconnect(
    google::cloud::cpp::compute::interconnects::v1::
        DeleteInterconnectRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_interconnects_v1::InterconnectsConnection::DeleteInterconnect");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteInterconnect(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InterconnectsTracingConnection::DeleteInterconnect(
    NoAwaitTag, google::cloud::cpp::compute::interconnects::v1::
                    DeleteInterconnectRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_interconnects_v1::InterconnectsConnection::DeleteInterconnect");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteInterconnect(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InterconnectsTracingConnection::DeleteInterconnect(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_interconnects_v1::InterconnectsConnection::DeleteInterconnect");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteInterconnect(operation));
}

StatusOr<google::cloud::cpp::compute::v1::Interconnect>
InterconnectsTracingConnection::GetInterconnect(
    google::cloud::cpp::compute::interconnects::v1::
        GetInterconnectRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_interconnects_v1::InterconnectsConnection::GetInterconnect");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetInterconnect(request));
}

StatusOr<google::cloud::cpp::compute::v1::InterconnectsGetDiagnosticsResponse>
InterconnectsTracingConnection::GetDiagnostics(
    google::cloud::cpp::compute::interconnects::v1::GetDiagnosticsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_interconnects_v1::InterconnectsConnection::GetDiagnostics");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDiagnostics(request));
}

StatusOr<google::cloud::cpp::compute::v1::InterconnectsGetMacsecConfigResponse>
InterconnectsTracingConnection::GetMacsecConfig(
    google::cloud::cpp::compute::interconnects::v1::
        GetMacsecConfigRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_interconnects_v1::InterconnectsConnection::GetMacsecConfig");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetMacsecConfig(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InterconnectsTracingConnection::InsertInterconnect(
    google::cloud::cpp::compute::interconnects::v1::
        InsertInterconnectRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_interconnects_v1::InterconnectsConnection::InsertInterconnect");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->InsertInterconnect(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InterconnectsTracingConnection::InsertInterconnect(
    NoAwaitTag, google::cloud::cpp::compute::interconnects::v1::
                    InsertInterconnectRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_interconnects_v1::InterconnectsConnection::InsertInterconnect");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->InsertInterconnect(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InterconnectsTracingConnection::InsertInterconnect(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_interconnects_v1::InterconnectsConnection::InsertInterconnect");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->InsertInterconnect(operation));
}

StreamRange<google::cloud::cpp::compute::v1::Interconnect>
InterconnectsTracingConnection::ListInterconnects(
    google::cloud::cpp::compute::interconnects::v1::ListInterconnectsRequest
        request) {
  auto span = internal::MakeSpan(
      "compute_interconnects_v1::InterconnectsConnection::ListInterconnects");
  internal::OTelScope scope(span);
  auto sr = child_->ListInterconnects(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::Interconnect>(std::move(span),
                                                     std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InterconnectsTracingConnection::PatchInterconnect(
    google::cloud::cpp::compute::interconnects::v1::
        PatchInterconnectRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_interconnects_v1::InterconnectsConnection::PatchInterconnect");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PatchInterconnect(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InterconnectsTracingConnection::PatchInterconnect(
    NoAwaitTag, google::cloud::cpp::compute::interconnects::v1::
                    PatchInterconnectRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_interconnects_v1::InterconnectsConnection::PatchInterconnect");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->PatchInterconnect(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InterconnectsTracingConnection::PatchInterconnect(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_interconnects_v1::InterconnectsConnection::PatchInterconnect");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->PatchInterconnect(operation));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InterconnectsTracingConnection::SetLabels(
    google::cloud::cpp::compute::interconnects::v1::SetLabelsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_interconnects_v1::InterconnectsConnection::SetLabels");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetLabels(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InterconnectsTracingConnection::SetLabels(
    NoAwaitTag,
    google::cloud::cpp::compute::interconnects::v1::SetLabelsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_interconnects_v1::InterconnectsConnection::SetLabels");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->SetLabels(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InterconnectsTracingConnection::SetLabels(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_interconnects_v1::InterconnectsConnection::SetLabels");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetLabels(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_interconnects_v1::InterconnectsConnection>
MakeInterconnectsTracingConnection(
    std::shared_ptr<compute_interconnects_v1::InterconnectsConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<InterconnectsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_interconnects_v1_internal
}  // namespace cloud
}  // namespace google
