// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/service_attachments/v1/service_attachments.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_SERVICE_ATTACHMENTS_V1_INTERNAL_SERVICE_ATTACHMENTS_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_SERVICE_ATTACHMENTS_V1_INTERNAL_SERVICE_ATTACHMENTS_TRACING_CONNECTION_H

#include "google/cloud/compute/service_attachments/v1/service_attachments_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_service_attachments_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class ServiceAttachmentsTracingConnection
    : public compute_service_attachments_v1::ServiceAttachmentsConnection {
 public:
  ~ServiceAttachmentsTracingConnection() override = default;

  explicit ServiceAttachmentsTracingConnection(
      std::shared_ptr<
          compute_service_attachments_v1::ServiceAttachmentsConnection>
          child);

  Options options() override { return child_->options(); }

  StreamRange<
      std::pair<std::string,
                google::cloud::cpp::compute::v1::ServiceAttachmentsScopedList>>
  AggregatedListServiceAttachments(
      google::cloud::cpp::compute::service_attachments::v1::
          AggregatedListServiceAttachmentsRequest request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteServiceAttachment(
      google::cloud::cpp::compute::service_attachments::v1::
          DeleteServiceAttachmentRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> DeleteServiceAttachment(
      NoAwaitTag, google::cloud::cpp::compute::service_attachments::v1::
                      DeleteServiceAttachmentRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteServiceAttachment(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  StatusOr<google::cloud::cpp::compute::v1::ServiceAttachment>
  GetServiceAttachment(google::cloud::cpp::compute::service_attachments::v1::
                           GetServiceAttachmentRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Policy> GetIamPolicy(
      google::cloud::cpp::compute::service_attachments::v1::
          GetIamPolicyRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertServiceAttachment(
      google::cloud::cpp::compute::service_attachments::v1::
          InsertServiceAttachmentRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> InsertServiceAttachment(
      NoAwaitTag, google::cloud::cpp::compute::service_attachments::v1::
                      InsertServiceAttachmentRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertServiceAttachment(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  StreamRange<google::cloud::cpp::compute::v1::ServiceAttachment>
  ListServiceAttachments(google::cloud::cpp::compute::service_attachments::v1::
                             ListServiceAttachmentsRequest request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  PatchServiceAttachment(
      google::cloud::cpp::compute::service_attachments::v1::
          PatchServiceAttachmentRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> PatchServiceAttachment(
      NoAwaitTag, google::cloud::cpp::compute::service_attachments::v1::
                      PatchServiceAttachmentRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  PatchServiceAttachment(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  StatusOr<google::cloud::cpp::compute::v1::Policy> SetIamPolicy(
      google::cloud::cpp::compute::service_attachments::v1::
          SetIamPolicyRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
  TestIamPermissions(google::cloud::cpp::compute::service_attachments::v1::
                         TestIamPermissionsRequest const& request) override;

 private:
  std::shared_ptr<compute_service_attachments_v1::ServiceAttachmentsConnection>
      child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<compute_service_attachments_v1::ServiceAttachmentsConnection>
MakeServiceAttachmentsTracingConnection(
    std::shared_ptr<
        compute_service_attachments_v1::ServiceAttachmentsConnection>
        conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_service_attachments_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_SERVICE_ATTACHMENTS_V1_INTERNAL_SERVICE_ATTACHMENTS_TRACING_CONNECTION_H
