// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/container/v1/cluster_service.proto

#include "google/cloud/container/v1/cluster_manager_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace container_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ClusterManagerConnectionIdempotencyPolicy::
    ~ClusterManagerConnectionIdempotencyPolicy() = default;

std::unique_ptr<ClusterManagerConnectionIdempotencyPolicy>
ClusterManagerConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<ClusterManagerConnectionIdempotencyPolicy>(*this);
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::ListClusters(
    google::container::v1::ListClustersRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::GetCluster(
    google::container::v1::GetClusterRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::CreateCluster(
    google::container::v1::CreateClusterRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::UpdateCluster(
    google::container::v1::UpdateClusterRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::UpdateNodePool(
    google::container::v1::UpdateNodePoolRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::SetNodePoolAutoscaling(
    google::container::v1::SetNodePoolAutoscalingRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::SetLoggingService(
    google::container::v1::SetLoggingServiceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::SetMonitoringService(
    google::container::v1::SetMonitoringServiceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::SetAddonsConfig(
    google::container::v1::SetAddonsConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::SetLocations(
    google::container::v1::SetLocationsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::UpdateMaster(
    google::container::v1::UpdateMasterRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::SetMasterAuth(
    google::container::v1::SetMasterAuthRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::DeleteCluster(
    google::container::v1::DeleteClusterRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::ListOperations(
    google::container::v1::ListOperationsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::GetOperation(
    google::container::v1::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::CancelOperation(
    google::container::v1::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::GetServerConfig(
    google::container::v1::GetServerConfigRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::GetJSONWebKeys(
    google::container::v1::GetJSONWebKeysRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::ListNodePools(
    google::container::v1::ListNodePoolsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::GetNodePool(
    google::container::v1::GetNodePoolRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::CreateNodePool(
    google::container::v1::CreateNodePoolRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::DeleteNodePool(
    google::container::v1::DeleteNodePoolRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::CompleteNodePoolUpgrade(
    google::container::v1::CompleteNodePoolUpgradeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::RollbackNodePoolUpgrade(
    google::container::v1::RollbackNodePoolUpgradeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::SetNodePoolManagement(
    google::container::v1::SetNodePoolManagementRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::SetLabels(
    google::container::v1::SetLabelsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::SetLegacyAbac(
    google::container::v1::SetLegacyAbacRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::StartIPRotation(
    google::container::v1::StartIPRotationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::CompleteIPRotation(
    google::container::v1::CompleteIPRotationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::SetNodePoolSize(
    google::container::v1::SetNodePoolSizeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::SetNetworkPolicy(
    google::container::v1::SetNetworkPolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::SetMaintenancePolicy(
    google::container::v1::SetMaintenancePolicyRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ClusterManagerConnectionIdempotencyPolicy::ListUsableSubnetworks(
    google::container::v1::ListUsableSubnetworksRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
ClusterManagerConnectionIdempotencyPolicy::CheckAutopilotCompatibility(
    google::container::v1::CheckAutopilotCompatibilityRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<ClusterManagerConnectionIdempotencyPolicy>
MakeDefaultClusterManagerConnectionIdempotencyPolicy() {
  return std::make_unique<ClusterManagerConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace container_v1
}  // namespace cloud
}  // namespace google
