// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/texttospeech/v1/cloud_tts.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TEXTTOSPEECH_V1_TEXT_TO_SPEECH_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TEXTTOSPEECH_V1_TEXT_TO_SPEECH_CONNECTION_H

#include "google/cloud/texttospeech/v1/internal/text_to_speech_retry_traits.h"
#include "google/cloud/texttospeech/v1/text_to_speech_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/internal/async_read_write_stream_impl.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/texttospeech/v1/cloud_tts.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace texttospeech_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `TextToSpeechConnection`.
class TextToSpeechRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<TextToSpeechRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `TextToSpeechConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class TextToSpeechLimitedErrorCountRetryPolicy
    : public TextToSpeechRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit TextToSpeechLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  TextToSpeechLimitedErrorCountRetryPolicy(
      TextToSpeechLimitedErrorCountRetryPolicy&& rhs) noexcept
      : TextToSpeechLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  TextToSpeechLimitedErrorCountRetryPolicy(
      TextToSpeechLimitedErrorCountRetryPolicy const& rhs) noexcept
      : TextToSpeechLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<TextToSpeechRetryPolicy> clone() const override {
    return std::make_unique<TextToSpeechLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = TextToSpeechRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      texttospeech_v1_internal::TextToSpeechRetryTraits>
      impl_;
};

/**
 * A retry policy for `TextToSpeechConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class TextToSpeechLimitedTimeRetryPolicy : public TextToSpeechRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit TextToSpeechLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  TextToSpeechLimitedTimeRetryPolicy(
      TextToSpeechLimitedTimeRetryPolicy&& rhs) noexcept
      : TextToSpeechLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  TextToSpeechLimitedTimeRetryPolicy(
      TextToSpeechLimitedTimeRetryPolicy const& rhs) noexcept
      : TextToSpeechLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<TextToSpeechRetryPolicy> clone() const override {
    return std::make_unique<TextToSpeechLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = TextToSpeechRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      texttospeech_v1_internal::TextToSpeechRetryTraits>
      impl_;
};

/**
 * The `TextToSpeechConnection` object for `TextToSpeechClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `TextToSpeechClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `TextToSpeechClient`.
 *
 * To create a concrete instance, see `MakeTextToSpeechConnection()`.
 *
 * For mocking, see `texttospeech_v1_mocks::MockTextToSpeechConnection`.
 */
class TextToSpeechConnection {
 public:
  virtual ~TextToSpeechConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<google::cloud::texttospeech::v1::ListVoicesResponse>
  ListVoices(google::cloud::texttospeech::v1::ListVoicesRequest const& request);

  virtual StatusOr<google::cloud::texttospeech::v1::SynthesizeSpeechResponse>
  SynthesizeSpeech(
      google::cloud::texttospeech::v1::SynthesizeSpeechRequest const& request);

  virtual std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
      google::cloud::texttospeech::v1::StreamingSynthesizeRequest,
      google::cloud::texttospeech::v1::StreamingSynthesizeResponse>>
  AsyncStreamingSynthesize();
};

/**
 * A factory function to construct an object of type `TextToSpeechConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of TextToSpeechClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `TextToSpeechConnection`. Expected options are any of the types in
 * the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::texttospeech_v1::TextToSpeechPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `TextToSpeechConnection` created by
 * this function.
 */
std::shared_ptr<TextToSpeechConnection> MakeTextToSpeechConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace texttospeech_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_TEXTTOSPEECH_V1_TEXT_TO_SPEECH_CONNECTION_H
