// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/api/servicemanagement/v1/resources.proto

package servicemanagement

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	configchange "google.golang.org/genproto/googleapis/api/configchange"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Code describes the status of the operation (or one of its steps).
type OperationMetadata_Status int32

const (
	// Unspecifed code.
	OperationMetadata_STATUS_UNSPECIFIED OperationMetadata_Status = 0
	// The operation or step has completed without errors.
	OperationMetadata_DONE OperationMetadata_Status = 1
	// The operation or step has not started yet.
	OperationMetadata_NOT_STARTED OperationMetadata_Status = 2
	// The operation or step is in progress.
	OperationMetadata_IN_PROGRESS OperationMetadata_Status = 3
	// The operation or step has completed with errors. If the operation is
	// rollbackable, the rollback completed with errors too.
	OperationMetadata_FAILED OperationMetadata_Status = 4
	// The operation or step has completed with cancellation.
	OperationMetadata_CANCELLED OperationMetadata_Status = 5
)

// Enum value maps for OperationMetadata_Status.
var (
	OperationMetadata_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "DONE",
		2: "NOT_STARTED",
		3: "IN_PROGRESS",
		4: "FAILED",
		5: "CANCELLED",
	}
	OperationMetadata_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"DONE":               1,
		"NOT_STARTED":        2,
		"IN_PROGRESS":        3,
		"FAILED":             4,
		"CANCELLED":          5,
	}
)

func (x OperationMetadata_Status) Enum() *OperationMetadata_Status {
	p := new(OperationMetadata_Status)
	*p = x
	return p
}

func (x OperationMetadata_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OperationMetadata_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_google_api_servicemanagement_v1_resources_proto_enumTypes[0].Descriptor()
}

func (OperationMetadata_Status) Type() protoreflect.EnumType {
	return &file_google_api_servicemanagement_v1_resources_proto_enumTypes[0]
}

func (x OperationMetadata_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OperationMetadata_Status.Descriptor instead.
func (OperationMetadata_Status) EnumDescriptor() ([]byte, []int) {
	return file_google_api_servicemanagement_v1_resources_proto_rawDescGZIP(), []int{1, 0}
}

// The kind of diagnostic information possible.
type Diagnostic_Kind int32

const (
	// Warnings and errors
	Diagnostic_WARNING Diagnostic_Kind = 0
	// Only errors
	Diagnostic_ERROR Diagnostic_Kind = 1
)

// Enum value maps for Diagnostic_Kind.
var (
	Diagnostic_Kind_name = map[int32]string{
		0: "WARNING",
		1: "ERROR",
	}
	Diagnostic_Kind_value = map[string]int32{
		"WARNING": 0,
		"ERROR":   1,
	}
)

func (x Diagnostic_Kind) Enum() *Diagnostic_Kind {
	p := new(Diagnostic_Kind)
	*p = x
	return p
}

func (x Diagnostic_Kind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Diagnostic_Kind) Descriptor() protoreflect.EnumDescriptor {
	return file_google_api_servicemanagement_v1_resources_proto_enumTypes[1].Descriptor()
}

func (Diagnostic_Kind) Type() protoreflect.EnumType {
	return &file_google_api_servicemanagement_v1_resources_proto_enumTypes[1]
}

func (x Diagnostic_Kind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Diagnostic_Kind.Descriptor instead.
func (Diagnostic_Kind) EnumDescriptor() ([]byte, []int) {
	return file_google_api_servicemanagement_v1_resources_proto_rawDescGZIP(), []int{2, 0}
}

type ConfigFile_FileType int32

const (
	// Unknown file type.
	ConfigFile_FILE_TYPE_UNSPECIFIED ConfigFile_FileType = 0
	// YAML-specification of service.
	ConfigFile_SERVICE_CONFIG_YAML ConfigFile_FileType = 1
	// OpenAPI specification, serialized in JSON.
	ConfigFile_OPEN_API_JSON ConfigFile_FileType = 2
	// OpenAPI specification, serialized in YAML.
	ConfigFile_OPEN_API_YAML ConfigFile_FileType = 3
	// FileDescriptorSet, generated by protoc.
	//
	// To generate, use protoc with imports and source info included.
	// For an example test.proto file, the following command would put the value
	// in a new file named out.pb.
	//
	// $protoc --include_imports --include_source_info test.proto -o out.pb
	ConfigFile_FILE_DESCRIPTOR_SET_PROTO ConfigFile_FileType = 4
	// Uncompiled Proto file. Used for storage and display purposes only,
	// currently server-side compilation is not supported. Should match the
	// inputs to 'protoc' command used to generated FILE_DESCRIPTOR_SET_PROTO. A
	// file of this type can only be included if at least one file of type
	// FILE_DESCRIPTOR_SET_PROTO is included.
	ConfigFile_PROTO_FILE ConfigFile_FileType = 6
)

// Enum value maps for ConfigFile_FileType.
var (
	ConfigFile_FileType_name = map[int32]string{
		0: "FILE_TYPE_UNSPECIFIED",
		1: "SERVICE_CONFIG_YAML",
		2: "OPEN_API_JSON",
		3: "OPEN_API_YAML",
		4: "FILE_DESCRIPTOR_SET_PROTO",
		6: "PROTO_FILE",
	}
	ConfigFile_FileType_value = map[string]int32{
		"FILE_TYPE_UNSPECIFIED":     0,
		"SERVICE_CONFIG_YAML":       1,
		"OPEN_API_JSON":             2,
		"OPEN_API_YAML":             3,
		"FILE_DESCRIPTOR_SET_PROTO": 4,
		"PROTO_FILE":                6,
	}
)

func (x ConfigFile_FileType) Enum() *ConfigFile_FileType {
	p := new(ConfigFile_FileType)
	*p = x
	return p
}

func (x ConfigFile_FileType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConfigFile_FileType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_api_servicemanagement_v1_resources_proto_enumTypes[2].Descriptor()
}

func (ConfigFile_FileType) Type() protoreflect.EnumType {
	return &file_google_api_servicemanagement_v1_resources_proto_enumTypes[2]
}

func (x ConfigFile_FileType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConfigFile_FileType.Descriptor instead.
func (ConfigFile_FileType) EnumDescriptor() ([]byte, []int) {
	return file_google_api_servicemanagement_v1_resources_proto_rawDescGZIP(), []int{4, 0}
}

// Status of a Rollout.
type Rollout_RolloutStatus int32

const (
	// No status specified.
	Rollout_ROLLOUT_STATUS_UNSPECIFIED Rollout_RolloutStatus = 0
	// The Rollout is in progress.
	Rollout_IN_PROGRESS Rollout_RolloutStatus = 1
	// The Rollout has completed successfully.
	Rollout_SUCCESS Rollout_RolloutStatus = 2
	// The Rollout has been cancelled. This can happen if you have overlapping
	// Rollout pushes, and the previous ones will be cancelled.
	Rollout_CANCELLED Rollout_RolloutStatus = 3
	// The Rollout has failed and the rollback attempt has failed too.
	Rollout_FAILED Rollout_RolloutStatus = 4
	// The Rollout has not started yet and is pending for execution.
	Rollout_PENDING Rollout_RolloutStatus = 5
	// The Rollout has failed and rolled back to the previous successful
	// Rollout.
	Rollout_FAILED_ROLLED_BACK Rollout_RolloutStatus = 6
)

// Enum value maps for Rollout_RolloutStatus.
var (
	Rollout_RolloutStatus_name = map[int32]string{
		0: "ROLLOUT_STATUS_UNSPECIFIED",
		1: "IN_PROGRESS",
		2: "SUCCESS",
		3: "CANCELLED",
		4: "FAILED",
		5: "PENDING",
		6: "FAILED_ROLLED_BACK",
	}
	Rollout_RolloutStatus_value = map[string]int32{
		"ROLLOUT_STATUS_UNSPECIFIED": 0,
		"IN_PROGRESS":                1,
		"SUCCESS":                    2,
		"CANCELLED":                  3,
		"FAILED":                     4,
		"PENDING":                    5,
		"FAILED_ROLLED_BACK":         6,
	}
)

func (x Rollout_RolloutStatus) Enum() *Rollout_RolloutStatus {
	p := new(Rollout_RolloutStatus)
	*p = x
	return p
}

func (x Rollout_RolloutStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Rollout_RolloutStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_api_servicemanagement_v1_resources_proto_enumTypes[3].Descriptor()
}

func (Rollout_RolloutStatus) Type() protoreflect.EnumType {
	return &file_google_api_servicemanagement_v1_resources_proto_enumTypes[3]
}

func (x Rollout_RolloutStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Rollout_RolloutStatus.Descriptor instead.
func (Rollout_RolloutStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_api_servicemanagement_v1_resources_proto_rawDescGZIP(), []int{7, 0}
}

// The full representation of a Service that is managed by
// Google Service Management.
type ManagedService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the service. See the
	// [overview](https://cloud.google.com/service-infrastructure/docs/overview)
	// for naming requirements.
	ServiceName string `protobuf:"bytes,2,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// ID of the project that produces and owns this service.
	ProducerProjectId string `protobuf:"bytes,3,opt,name=producer_project_id,json=producerProjectId,proto3" json:"producer_project_id,omitempty"`
}

func (x *ManagedService) Reset() {
	*x = ManagedService{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManagedService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManagedService) ProtoMessage() {}

func (x *ManagedService) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManagedService.ProtoReflect.Descriptor instead.
func (*ManagedService) Descriptor() ([]byte, []int) {
	return file_google_api_servicemanagement_v1_resources_proto_rawDescGZIP(), []int{0}
}

func (x *ManagedService) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

func (x *ManagedService) GetProducerProjectId() string {
	if x != nil {
		return x.ProducerProjectId
	}
	return ""
}

// The metadata associated with a long running operation resource.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full name of the resources that this operation is directly
	// associated with.
	ResourceNames []string `protobuf:"bytes,1,rep,name=resource_names,json=resourceNames,proto3" json:"resource_names,omitempty"`
	// Detailed status information for each step. The order is undetermined.
	Steps []*OperationMetadata_Step `protobuf:"bytes,2,rep,name=steps,proto3" json:"steps,omitempty"`
	// Percentage of completion of this operation, ranging from 0 to 100.
	ProgressPercentage int32 `protobuf:"varint,3,opt,name=progress_percentage,json=progressPercentage,proto3" json:"progress_percentage,omitempty"`
	// The start time of the operation.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_api_servicemanagement_v1_resources_proto_rawDescGZIP(), []int{1}
}

func (x *OperationMetadata) GetResourceNames() []string {
	if x != nil {
		return x.ResourceNames
	}
	return nil
}

func (x *OperationMetadata) GetSteps() []*OperationMetadata_Step {
	if x != nil {
		return x.Steps
	}
	return nil
}

func (x *OperationMetadata) GetProgressPercentage() int32 {
	if x != nil {
		return x.ProgressPercentage
	}
	return 0
}

func (x *OperationMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

// Represents a diagnostic message (error or warning)
type Diagnostic struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// File name and line number of the error or warning.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// The kind of diagnostic information provided.
	Kind Diagnostic_Kind `protobuf:"varint,2,opt,name=kind,proto3,enum=google.api.servicemanagement.v1.Diagnostic_Kind" json:"kind,omitempty"`
	// Message describing the error or warning.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *Diagnostic) Reset() {
	*x = Diagnostic{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Diagnostic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Diagnostic) ProtoMessage() {}

func (x *Diagnostic) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Diagnostic.ProtoReflect.Descriptor instead.
func (*Diagnostic) Descriptor() ([]byte, []int) {
	return file_google_api_servicemanagement_v1_resources_proto_rawDescGZIP(), []int{2}
}

func (x *Diagnostic) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *Diagnostic) GetKind() Diagnostic_Kind {
	if x != nil {
		return x.Kind
	}
	return Diagnostic_WARNING
}

func (x *Diagnostic) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// Represents a source file which is used to generate the service configuration
// defined by `google.api.Service`.
type ConfigSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique ID for a specific instance of this message, typically assigned
	// by the client for tracking purpose. If empty, the server may choose to
	// generate one instead.
	Id string `protobuf:"bytes,5,opt,name=id,proto3" json:"id,omitempty"`
	// Set of source configuration files that are used to generate a service
	// configuration (`google.api.Service`).
	Files []*ConfigFile `protobuf:"bytes,2,rep,name=files,proto3" json:"files,omitempty"`
}

func (x *ConfigSource) Reset() {
	*x = ConfigSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigSource) ProtoMessage() {}

func (x *ConfigSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigSource.ProtoReflect.Descriptor instead.
func (*ConfigSource) Descriptor() ([]byte, []int) {
	return file_google_api_servicemanagement_v1_resources_proto_rawDescGZIP(), []int{3}
}

func (x *ConfigSource) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ConfigSource) GetFiles() []*ConfigFile {
	if x != nil {
		return x.Files
	}
	return nil
}

// Generic specification of a source configuration file
type ConfigFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The file name of the configuration file (full or relative path).
	FilePath string `protobuf:"bytes,1,opt,name=file_path,json=filePath,proto3" json:"file_path,omitempty"`
	// The bytes that constitute the file.
	FileContents []byte `protobuf:"bytes,3,opt,name=file_contents,json=fileContents,proto3" json:"file_contents,omitempty"`
	// The type of configuration file this represents.
	FileType ConfigFile_FileType `protobuf:"varint,4,opt,name=file_type,json=fileType,proto3,enum=google.api.servicemanagement.v1.ConfigFile_FileType" json:"file_type,omitempty"`
}

func (x *ConfigFile) Reset() {
	*x = ConfigFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigFile) ProtoMessage() {}

func (x *ConfigFile) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigFile.ProtoReflect.Descriptor instead.
func (*ConfigFile) Descriptor() ([]byte, []int) {
	return file_google_api_servicemanagement_v1_resources_proto_rawDescGZIP(), []int{4}
}

func (x *ConfigFile) GetFilePath() string {
	if x != nil {
		return x.FilePath
	}
	return ""
}

func (x *ConfigFile) GetFileContents() []byte {
	if x != nil {
		return x.FileContents
	}
	return nil
}

func (x *ConfigFile) GetFileType() ConfigFile_FileType {
	if x != nil {
		return x.FileType
	}
	return ConfigFile_FILE_TYPE_UNSPECIFIED
}

// Represents a service configuration with its name and id.
type ConfigRef struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of a service config. It must have the following
	// format: "services/{service name}/configs/{config id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ConfigRef) Reset() {
	*x = ConfigRef{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigRef) ProtoMessage() {}

func (x *ConfigRef) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigRef.ProtoReflect.Descriptor instead.
func (*ConfigRef) Descriptor() ([]byte, []int) {
	return file_google_api_servicemanagement_v1_resources_proto_rawDescGZIP(), []int{5}
}

func (x *ConfigRef) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Change report associated with a particular service configuration.
//
// It contains a list of ConfigChanges based on the comparison between
// two service configurations.
type ChangeReport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of changes between two service configurations.
	// The changes will be alphabetically sorted based on the identifier
	// of each change.
	// A ConfigChange identifier is a dot separated path to the configuration.
	// Example: visibility.rules[selector='LibraryService.CreateBook'].restriction
	ConfigChanges []*configchange.ConfigChange `protobuf:"bytes,1,rep,name=config_changes,json=configChanges,proto3" json:"config_changes,omitempty"`
}

func (x *ChangeReport) Reset() {
	*x = ChangeReport{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChangeReport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChangeReport) ProtoMessage() {}

func (x *ChangeReport) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChangeReport.ProtoReflect.Descriptor instead.
func (*ChangeReport) Descriptor() ([]byte, []int) {
	return file_google_api_servicemanagement_v1_resources_proto_rawDescGZIP(), []int{6}
}

func (x *ChangeReport) GetConfigChanges() []*configchange.ConfigChange {
	if x != nil {
		return x.ConfigChanges
	}
	return nil
}

// A rollout resource that defines how service configuration versions are pushed
// to control plane systems. Typically, you create a new version of the
// service config, and then create a Rollout to push the service config.
type Rollout struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Unique identifier of this Rollout. Must be no longer than 63
	// characters and only lower case letters, digits, '.', '_' and '-' are
	// allowed.
	//
	// If not specified by client, the server will generate one. The generated id
	// will have the form of <date><revision number>, where "date" is the create
	// date in ISO 8601 format.  "revision number" is a monotonically increasing
	// positive number that is reset every day for each service.
	// An example of the generated rollout_id is '2016-02-16r1'
	RolloutId string `protobuf:"bytes,1,opt,name=rollout_id,json=rolloutId,proto3" json:"rollout_id,omitempty"`
	// Creation time of the rollout. Readonly.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The user who created the Rollout. Readonly.
	CreatedBy string `protobuf:"bytes,3,opt,name=created_by,json=createdBy,proto3" json:"created_by,omitempty"`
	// The status of this rollout. Readonly. In case of a failed rollout,
	// the system will automatically rollback to the current Rollout
	// version. Readonly.
	Status Rollout_RolloutStatus `protobuf:"varint,4,opt,name=status,proto3,enum=google.api.servicemanagement.v1.Rollout_RolloutStatus" json:"status,omitempty"`
	// Strategy that defines which versions of service configurations should be
	// pushed
	// and how they should be used at runtime.
	//
	// Types that are assignable to Strategy:
	//	*Rollout_TrafficPercentStrategy_
	//	*Rollout_DeleteServiceStrategy_
	Strategy isRollout_Strategy `protobuf_oneof:"strategy"`
	// The name of the service associated with this Rollout.
	ServiceName string `protobuf:"bytes,8,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
}

func (x *Rollout) Reset() {
	*x = Rollout{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rollout) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rollout) ProtoMessage() {}

func (x *Rollout) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rollout.ProtoReflect.Descriptor instead.
func (*Rollout) Descriptor() ([]byte, []int) {
	return file_google_api_servicemanagement_v1_resources_proto_rawDescGZIP(), []int{7}
}

func (x *Rollout) GetRolloutId() string {
	if x != nil {
		return x.RolloutId
	}
	return ""
}

func (x *Rollout) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Rollout) GetCreatedBy() string {
	if x != nil {
		return x.CreatedBy
	}
	return ""
}

func (x *Rollout) GetStatus() Rollout_RolloutStatus {
	if x != nil {
		return x.Status
	}
	return Rollout_ROLLOUT_STATUS_UNSPECIFIED
}

func (m *Rollout) GetStrategy() isRollout_Strategy {
	if m != nil {
		return m.Strategy
	}
	return nil
}

func (x *Rollout) GetTrafficPercentStrategy() *Rollout_TrafficPercentStrategy {
	if x, ok := x.GetStrategy().(*Rollout_TrafficPercentStrategy_); ok {
		return x.TrafficPercentStrategy
	}
	return nil
}

func (x *Rollout) GetDeleteServiceStrategy() *Rollout_DeleteServiceStrategy {
	if x, ok := x.GetStrategy().(*Rollout_DeleteServiceStrategy_); ok {
		return x.DeleteServiceStrategy
	}
	return nil
}

func (x *Rollout) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

type isRollout_Strategy interface {
	isRollout_Strategy()
}

type Rollout_TrafficPercentStrategy_ struct {
	// Google Service Control selects service configurations based on
	// traffic percentage.
	TrafficPercentStrategy *Rollout_TrafficPercentStrategy `protobuf:"bytes,5,opt,name=traffic_percent_strategy,json=trafficPercentStrategy,proto3,oneof"`
}

type Rollout_DeleteServiceStrategy_ struct {
	// The strategy associated with a rollout to delete a `ManagedService`.
	// Readonly.
	DeleteServiceStrategy *Rollout_DeleteServiceStrategy `protobuf:"bytes,200,opt,name=delete_service_strategy,json=deleteServiceStrategy,proto3,oneof"`
}

func (*Rollout_TrafficPercentStrategy_) isRollout_Strategy() {}

func (*Rollout_DeleteServiceStrategy_) isRollout_Strategy() {}

// Represents the status of one operation step.
type OperationMetadata_Step struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The short description of the step.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The status code.
	Status OperationMetadata_Status `protobuf:"varint,4,opt,name=status,proto3,enum=google.api.servicemanagement.v1.OperationMetadata_Status" json:"status,omitempty"`
}

func (x *OperationMetadata_Step) Reset() {
	*x = OperationMetadata_Step{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata_Step) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata_Step) ProtoMessage() {}

func (x *OperationMetadata_Step) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata_Step.ProtoReflect.Descriptor instead.
func (*OperationMetadata_Step) Descriptor() ([]byte, []int) {
	return file_google_api_servicemanagement_v1_resources_proto_rawDescGZIP(), []int{1, 0}
}

func (x *OperationMetadata_Step) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *OperationMetadata_Step) GetStatus() OperationMetadata_Status {
	if x != nil {
		return x.Status
	}
	return OperationMetadata_STATUS_UNSPECIFIED
}

// Strategy that specifies how clients of Google Service Controller want to
// send traffic to use different config versions. This is generally
// used by API proxy to split traffic based on your configured percentage for
// each config version.
//
// One example of how to gradually rollout a new service configuration using
// this
// strategy:
// Day 1
//
//	Rollout {
//	  id: "example.googleapis.com/rollout_20160206"
//	  traffic_percent_strategy {
//	    percentages: {
//	      "example.googleapis.com/20160201": 70.00
//	      "example.googleapis.com/20160206": 30.00
//	    }
//	  }
//	}
//
// Day 2
//
//	Rollout {
//	  id: "example.googleapis.com/rollout_20160207"
//	  traffic_percent_strategy: {
//	    percentages: {
//	      "example.googleapis.com/20160206": 100.00
//	    }
//	  }
//	}
type Rollout_TrafficPercentStrategy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Maps service configuration IDs to their corresponding traffic percentage.
	// Key is the service configuration ID, Value is the traffic percentage
	// which must be greater than 0.0 and the sum must equal to 100.0.
	Percentages map[string]float64 `protobuf:"bytes,1,rep,name=percentages,proto3" json:"percentages,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed64,2,opt,name=value,proto3"`
}

func (x *Rollout_TrafficPercentStrategy) Reset() {
	*x = Rollout_TrafficPercentStrategy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rollout_TrafficPercentStrategy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rollout_TrafficPercentStrategy) ProtoMessage() {}

func (x *Rollout_TrafficPercentStrategy) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rollout_TrafficPercentStrategy.ProtoReflect.Descriptor instead.
func (*Rollout_TrafficPercentStrategy) Descriptor() ([]byte, []int) {
	return file_google_api_servicemanagement_v1_resources_proto_rawDescGZIP(), []int{7, 0}
}

func (x *Rollout_TrafficPercentStrategy) GetPercentages() map[string]float64 {
	if x != nil {
		return x.Percentages
	}
	return nil
}

// Strategy used to delete a service. This strategy is a placeholder only
// used by the system generated rollout to delete a service.
type Rollout_DeleteServiceStrategy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Rollout_DeleteServiceStrategy) Reset() {
	*x = Rollout_DeleteServiceStrategy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Rollout_DeleteServiceStrategy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Rollout_DeleteServiceStrategy) ProtoMessage() {}

func (x *Rollout_DeleteServiceStrategy) ProtoReflect() protoreflect.Message {
	mi := &file_google_api_servicemanagement_v1_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Rollout_DeleteServiceStrategy.ProtoReflect.Descriptor instead.
func (*Rollout_DeleteServiceStrategy) Descriptor() ([]byte, []int) {
	return file_google_api_servicemanagement_v1_resources_proto_rawDescGZIP(), []int{7, 1}
}

var File_google_api_servicemanagement_v1_resources_proto protoreflect.FileDescriptor

var file_google_api_servicemanagement_v1_resources_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2f, 0x76,
	0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x63, 0x0a, 0x0e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x22, 0xdb, 0x03, 0x0a, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x25, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x4d, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x52, 0x05,
	0x73, 0x74, 0x65, 0x70, 0x73, 0x12, 0x2f, 0x0a, 0x13, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x12, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x50, 0x65, 0x72, 0x63,
	0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x1a, 0x7b, 0x0a, 0x04, 0x53, 0x74, 0x65, 0x70, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x67,
	0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x41, 0x54,
	0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x08, 0x0a, 0x04, 0x44, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x4f,
	0x54, 0x5f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x49,
	0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06,
	0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43,
	0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x22, 0xa8, 0x01, 0x0a, 0x0a, 0x44, 0x69, 0x61, 0x67,
	0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63, 0x2e, 0x4b, 0x69,
	0x6e, 0x64, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x22, 0x1e, 0x0a, 0x04, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41,
	0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x10, 0x01, 0x22, 0x61, 0x0a, 0x0c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x64, 0x12, 0x41, 0x0a, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x05,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x22, 0xb7, 0x02, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x46, 0x69, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x74,
	0x68, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0c, 0x66, 0x69, 0x6c, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x51, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x08, 0x66, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x93, 0x01, 0x0a, 0x08, 0x46, 0x69,
	0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x17, 0x0a, 0x13, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x43, 0x4f, 0x4e,
	0x46, 0x49, 0x47, 0x5f, 0x59, 0x41, 0x4d, 0x4c, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x4f, 0x50,
	0x45, 0x4e, 0x5f, 0x41, 0x50, 0x49, 0x5f, 0x4a, 0x53, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x11, 0x0a,
	0x0d, 0x4f, 0x50, 0x45, 0x4e, 0x5f, 0x41, 0x50, 0x49, 0x5f, 0x59, 0x41, 0x4d, 0x4c, 0x10, 0x03,
	0x12, 0x1d, 0x0a, 0x19, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x44, 0x45, 0x53, 0x43, 0x52, 0x49, 0x50,
	0x54, 0x4f, 0x52, 0x5f, 0x53, 0x45, 0x54, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x10, 0x04, 0x12,
	0x0e, 0x0a, 0x0a, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x06, 0x22,
	0x1f, 0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x66, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x4f, 0x0a, 0x0c, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x12, 0x3f, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x73, 0x22, 0xf8, 0x06, 0x0a, 0x07, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x22, 0x0a,
	0x0a, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x49,
	0x64, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x42, 0x79, 0x12, 0x4e, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x7b, 0x0a,
	0x18, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x2e, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69,
	0x63, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79,
	0x48, 0x00, 0x52, 0x16, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x50, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x79, 0x0a, 0x17, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x73, 0x74, 0x72,
	0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0xc8, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x48, 0x00, 0x52, 0x15,
	0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x53, 0x74, 0x72,
	0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0xcc, 0x01, 0x0a, 0x16, 0x54, 0x72, 0x61,
	0x66, 0x66, 0x69, 0x63, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x12, 0x72, 0x0a, 0x0b, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x2e, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e,
	0x74, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x2e, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e,
	0x74, 0x61, 0x67, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x70, 0x65, 0x72, 0x63,
	0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x73, 0x1a, 0x3e, 0x0a, 0x10, 0x50, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x61, 0x67, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x17, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79,
	0x22, 0x8d, 0x01, 0x0a, 0x0d, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x1e, 0x0a, 0x1a, 0x52, 0x4f, 0x4c, 0x4c, 0x4f, 0x55, 0x54, 0x5f, 0x53, 0x54,
	0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53,
	0x53, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x02,
	0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12,
	0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x50,
	0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x16, 0x0a, 0x12, 0x46, 0x41, 0x49, 0x4c,
	0x45, 0x44, 0x5f, 0x52, 0x4f, 0x4c, 0x4c, 0x45, 0x44, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x10, 0x06,
	0x42, 0x0a, 0x0a, 0x08, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x42, 0xff, 0x01, 0x0a,
	0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x42, 0x0e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x50, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x3b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0xa2, 0x02, 0x04, 0x47, 0x41, 0x53, 0x4d, 0xaa,
	0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x56, 0x31, 0xca, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_api_servicemanagement_v1_resources_proto_rawDescOnce sync.Once
	file_google_api_servicemanagement_v1_resources_proto_rawDescData = file_google_api_servicemanagement_v1_resources_proto_rawDesc
)

func file_google_api_servicemanagement_v1_resources_proto_rawDescGZIP() []byte {
	file_google_api_servicemanagement_v1_resources_proto_rawDescOnce.Do(func() {
		file_google_api_servicemanagement_v1_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_api_servicemanagement_v1_resources_proto_rawDescData)
	})
	return file_google_api_servicemanagement_v1_resources_proto_rawDescData
}

var file_google_api_servicemanagement_v1_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_api_servicemanagement_v1_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_api_servicemanagement_v1_resources_proto_goTypes = []interface{}{
	(OperationMetadata_Status)(0),          // 0: google.api.servicemanagement.v1.OperationMetadata.Status
	(Diagnostic_Kind)(0),                   // 1: google.api.servicemanagement.v1.Diagnostic.Kind
	(ConfigFile_FileType)(0),               // 2: google.api.servicemanagement.v1.ConfigFile.FileType
	(Rollout_RolloutStatus)(0),             // 3: google.api.servicemanagement.v1.Rollout.RolloutStatus
	(*ManagedService)(nil),                 // 4: google.api.servicemanagement.v1.ManagedService
	(*OperationMetadata)(nil),              // 5: google.api.servicemanagement.v1.OperationMetadata
	(*Diagnostic)(nil),                     // 6: google.api.servicemanagement.v1.Diagnostic
	(*ConfigSource)(nil),                   // 7: google.api.servicemanagement.v1.ConfigSource
	(*ConfigFile)(nil),                     // 8: google.api.servicemanagement.v1.ConfigFile
	(*ConfigRef)(nil),                      // 9: google.api.servicemanagement.v1.ConfigRef
	(*ChangeReport)(nil),                   // 10: google.api.servicemanagement.v1.ChangeReport
	(*Rollout)(nil),                        // 11: google.api.servicemanagement.v1.Rollout
	(*OperationMetadata_Step)(nil),         // 12: google.api.servicemanagement.v1.OperationMetadata.Step
	(*Rollout_TrafficPercentStrategy)(nil), // 13: google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy
	(*Rollout_DeleteServiceStrategy)(nil),  // 14: google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy
	nil,                                    // 15: google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy.PercentagesEntry
	(*timestamppb.Timestamp)(nil),          // 16: google.protobuf.Timestamp
	(*configchange.ConfigChange)(nil),      // 17: google.api.ConfigChange
}
var file_google_api_servicemanagement_v1_resources_proto_depIdxs = []int32{
	12, // 0: google.api.servicemanagement.v1.OperationMetadata.steps:type_name -> google.api.servicemanagement.v1.OperationMetadata.Step
	16, // 1: google.api.servicemanagement.v1.OperationMetadata.start_time:type_name -> google.protobuf.Timestamp
	1,  // 2: google.api.servicemanagement.v1.Diagnostic.kind:type_name -> google.api.servicemanagement.v1.Diagnostic.Kind
	8,  // 3: google.api.servicemanagement.v1.ConfigSource.files:type_name -> google.api.servicemanagement.v1.ConfigFile
	2,  // 4: google.api.servicemanagement.v1.ConfigFile.file_type:type_name -> google.api.servicemanagement.v1.ConfigFile.FileType
	17, // 5: google.api.servicemanagement.v1.ChangeReport.config_changes:type_name -> google.api.ConfigChange
	16, // 6: google.api.servicemanagement.v1.Rollout.create_time:type_name -> google.protobuf.Timestamp
	3,  // 7: google.api.servicemanagement.v1.Rollout.status:type_name -> google.api.servicemanagement.v1.Rollout.RolloutStatus
	13, // 8: google.api.servicemanagement.v1.Rollout.traffic_percent_strategy:type_name -> google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy
	14, // 9: google.api.servicemanagement.v1.Rollout.delete_service_strategy:type_name -> google.api.servicemanagement.v1.Rollout.DeleteServiceStrategy
	0,  // 10: google.api.servicemanagement.v1.OperationMetadata.Step.status:type_name -> google.api.servicemanagement.v1.OperationMetadata.Status
	15, // 11: google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy.percentages:type_name -> google.api.servicemanagement.v1.Rollout.TrafficPercentStrategy.PercentagesEntry
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_api_servicemanagement_v1_resources_proto_init() }
func file_google_api_servicemanagement_v1_resources_proto_init() {
	if File_google_api_servicemanagement_v1_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_api_servicemanagement_v1_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManagedService); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_servicemanagement_v1_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_servicemanagement_v1_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Diagnostic); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_servicemanagement_v1_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfigSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_servicemanagement_v1_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfigFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_servicemanagement_v1_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfigRef); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_servicemanagement_v1_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChangeReport); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_servicemanagement_v1_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rollout); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_servicemanagement_v1_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata_Step); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_servicemanagement_v1_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rollout_TrafficPercentStrategy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_api_servicemanagement_v1_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Rollout_DeleteServiceStrategy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_api_servicemanagement_v1_resources_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*Rollout_TrafficPercentStrategy_)(nil),
		(*Rollout_DeleteServiceStrategy_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_api_servicemanagement_v1_resources_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_api_servicemanagement_v1_resources_proto_goTypes,
		DependencyIndexes: file_google_api_servicemanagement_v1_resources_proto_depIdxs,
		EnumInfos:         file_google_api_servicemanagement_v1_resources_proto_enumTypes,
		MessageInfos:      file_google_api_servicemanagement_v1_resources_proto_msgTypes,
	}.Build()
	File_google_api_servicemanagement_v1_resources_proto = out.File
	file_google_api_servicemanagement_v1_resources_proto_rawDesc = nil
	file_google_api_servicemanagement_v1_resources_proto_goTypes = nil
	file_google_api_servicemanagement_v1_resources_proto_depIdxs = nil
}
