/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.WinProcesses;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.ConsoleImpl;
import com.install4j.runtime.installer.helper.InstallationProperties;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.RunningProcessesDialog;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchStringAction;
import com.install4j.runtime.installer.helper.comm.responses.ObjectResponse;
import com.install4j.runtime.installer.helper.comm.responses.Response;
import com.install4j.runtime.installer.platform.win32.Misc;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;

public class RunningProcessChecker {
    public static final int CLOSE_STRATEGY_NONE = 0;
    public static final int CLOSE_STRATEGY_ASK_ONLY = 1;
    public static final int CLOSE_STRATEGY_ASK_FOR_CLOSE = 2;
    public static final int CLOSE_STRATEGY_ASK_FOR_CLOSE_AND_TERMINATE = 3;
    public static final int CLOSE_STRATEGY_ASK_FOR_TERMINATE = 4;
    public static final int CLOSE_STRATEGY_CLOSE = 5;
    public static final int CLOSE_STRATEGY_TERMINATE = 6;
    private static boolean defaultChecked = false;

    public static boolean areInstalledLaunchersRunning() {
        try {
            return !RunningProcessChecker.checkRunningProcessesInt(RunningProcessChecker.getLauncherFileNames(), null, 0, 0, false);
        }
        catch (UserCanceledException userCanceledException) {
        }
        catch (IOException iOException) {
            Logger.getInstance().log(iOException);
        }
        return false;
    }

    public static boolean checkDefaultRunningLauncher(String string) throws UserCanceledException {
        if (Boolean.getBoolean("install4j.dontCheckProcesses")) {
            return true;
        }
        if (!InstallerUtil.isWindows() || defaultChecked) {
            return true;
        }
        VariableResourceBundleWrapper variableResourceBundleWrapper = Messages.getMessages();
        String string2 = string == null ? null : MessageFormat.format(variableResourceBundleWrapper.getString(string), "install4j", InstallerConfig.getCurrentInstance().getApplicationName());
        try {
            defaultChecked = RunningProcessChecker.checkRunningProcessesInt(RunningProcessChecker.getLauncherFileNames(), string2, 1, 0, false);
            return defaultChecked;
        }
        catch (IOException iOException) {
            Logger.getInstance().log(iOException);
            return true;
        }
    }

    public static boolean checkRunningProcesses(String string, int n, int n2, boolean bl, boolean bl2, File[] fileArray) throws UserCanceledException {
        int n3;
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        HashSet<String> hashSet = new HashSet<String>();
        try {
            if (bl2) {
                hashSet.addAll(RunningProcessChecker.getLauncherFileNames());
            }
            if (fileArray != null) {
                for (n3 = 0; n3 < fileArray.length; ++n3) {
                    if (fileArray[n3].isAbsolute()) {
                        hashSet.add(fileArray[n3].getCanonicalPath());
                        continue;
                    }
                    hashSet.add(fileArray[n3].getName());
                }
            }
        }
        catch (IOException iOException) {
            Logger.getInstance().log(iOException);
        }
        n3 = RunningProcessChecker.checkRunningProcessesInt(hashSet, string, n, n2, bl) ? 1 : 0;
        if (bl2 && n3 != 0) {
            defaultChecked = true;
        }
        return n3 != 0;
    }

    private static boolean checkRunningProcessesInt(Set set, String string, int n, int n2, boolean bl) throws UserCanceledException {
        boolean bl2 = true;
        Collection collection;
        while ((collection = RunningProcessChecker.getRunningProcesses(set)).size() != 0) {
            String string2;
            Serializable serializable;
            if (n == 0) {
                return false;
            }
            if (n == 5) {
                return RunningProcessChecker.closeProcesses(false, n2, collection);
            }
            if (n == 6) {
                return RunningProcessChecker.closeProcesses(true, n2, collection);
            }
            if (InstallerUtil.isUnattended()) {
                if (string != null) {
                    ConsoleImpl.getInstance().println(Messages.getMessages().getString("UnattendedRunningFailure"));
                }
                return false;
            }
            if (string == null) {
                return false;
            }
            TreeSet<String> treeSet = new TreeSet<String>();
            Object object = collection.iterator();
            while (object.hasNext()) {
                serializable = (Misc.ProcessInfo)object.next();
                string2 = WinProcesses.getWindowTitle(((Misc.ProcessInfo)serializable).getProcessId());
                if (string2 != null && string2.trim().length() > 0 && !string2.equals("Default IME") && !string2.equals("theAwtToolkitWindow")) {
                    treeSet.add(string2);
                    continue;
                }
                treeSet.add(new File(((Misc.ProcessInfo)serializable).getModuleName()).getAbsolutePath());
            }
            object = Messages.getMessages();
            serializable = new ArrayList();
            switch (n) {
                case 2: {
                    serializable.add(((ResourceBundle)object).getString("ButtonCloseProcesses"));
                    break;
                }
                case 3: {
                    serializable.add(((ResourceBundle)object).getString(bl2 ? "ButtonCloseProcesses" : "ButtonTerminateProcesses"));
                    break;
                }
                case 4: {
                    serializable.add(((ResourceBundle)object).getString("ButtonTerminateProcesses"));
                }
            }
            serializable.add(((ResourceBundle)object).getString("ButtonRetry"));
            if (bl) {
                serializable.add(((ResourceBundle)object).getString("ButtonIgnore"));
            }
            if ((string2 = RunningProcessChecker.showDialog(string, treeSet, (List)((Object)serializable))) == null) {
                return false;
            }
            if (string2.equals(((ResourceBundle)object).getString("ButtonIgnore"))) {
                return true;
            }
            if (string2.equals(((ResourceBundle)object).getString("ButtonTerminateProcesses")) ? RunningProcessChecker.closeProcesses(true, n2, collection) : string2.equals(((ResourceBundle)object).getString("ButtonCloseProcesses")) && RunningProcessChecker.closeProcesses(false, n2, collection)) {
                return true;
            }
            bl2 = false;
        }
        return true;
    }

    private static String showDialog(final String string, final Collection collection, final List list) throws UserCanceledException {
        if (InstallerUtil.isConsole()) {
            ConsoleImpl consoleImpl = ConsoleImpl.getInstance();
            consoleImpl.println(string);
            consoleImpl.println();
            String[] stringArray = collection.iterator();
            while (stringArray.hasNext()) {
                consoleImpl.println("* " + stringArray.next());
            }
            consoleImpl.println();
            stringArray = list.toArray(new String[list.size()]);
            return stringArray[consoleImpl.askOption(null, stringArray, null)];
        }
        return HelperCommunication.getInstance().fetchString(ExecutionContext.UNELEVATED, new FetchStringAction(){

            protected String fetchValue(Context context) throws Exception {
                RunningProcessesDialog runningProcessesDialog = RunningProcessesDialog.create(Util.getParentWindow(), string, collection, list);
                runningProcessesDialog.setVisible(true);
                if (runningProcessesDialog.isCanceled()) {
                    return null;
                }
                return (String)list.get(runningProcessesDialog.getSelectedButtonIndex());
            }
        });
    }

    private static boolean closeProcesses(final boolean bl, final int n, Collection collection) {
        final int[] nArray = new int[collection.size()];
        int n2 = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            nArray[n2++] = ((Misc.ProcessInfo)iterator.next()).getProcessId();
        }
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.MAXIMUM, new FetchBooleanAction(){

            protected boolean fetchValue(Context context) throws Exception {
                return Misc.terminateProcesses(nArray, bl, n) == 1;
            }
        });
    }

    private static Set getLauncherFileNames() throws IOException {
        ContextInt contextInt = ContextImpl.getContextInt(ContextImpl.getSingleContextInt());
        InstallationProperties installationProperties = contextInt.getInstallationProperties();
        Set set = installationProperties.getCanonicalPathPropertySet("launcher");
        if (!(contextInt instanceof UninstallerContext)) {
            set.add(new File(contextInt.getInstallationDirectory(), InstallerConfig.getCurrentInstance().getUninstallerPath() + ".exe").getCanonicalPath());
        }
        return set;
    }

    private static Collection getRunningProcesses(Set set) {
        HashSet hashSet = new HashSet();
        RunningProcessChecker.checkModules(hashSet, set, HelperCommunication.getInstance().executeAction(ExecutionContext.SAME, new GetModulesRemoteCallable()));
        if (HelperCommunication.getInstance().isConnected()) {
            RunningProcessChecker.checkModules(hashSet, set, HelperCommunication.getInstance().executeAction(ExecutionContext.OTHER, new GetModulesRemoteCallable()));
        }
        return hashSet;
    }

    public static Collection getAllRunningProcesses() {
        return RunningProcessChecker.getRunningProcesses(null);
    }

    private static void checkModules(Collection collection, Set set, Response response) {
        if (response == null) {
            return;
        }
        Misc.ProcessInfo[] processInfoArray = (Misc.ProcessInfo[])((ObjectResponse)response).getValue();
        if (processInfoArray != null) {
            if (set == null) {
                collection.addAll(Arrays.asList(processInfoArray));
            } else {
                for (int i = 0; i < processInfoArray.length; ++i) {
                    File file;
                    try {
                        file = new File(processInfoArray[i].getModuleName()).getCanonicalFile();
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    if (!set.contains(file.getAbsolutePath()) && !set.contains(file.getName())) continue;
                    collection.add(processInfoArray[i]);
                }
            }
        }
    }

    private static class GetModulesRemoteCallable
    extends FetchObjectAction {
        private GetModulesRemoteCallable() {
        }

        protected Object fetchValue(Context context) throws Exception {
            RunningProcessThread runningProcessThread = new RunningProcessThread();
            runningProcessThread.start();
            try {
                runningProcessThread.join(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (runningProcessThread.isAlive()) {
                runningProcessThread.stop();
            }
            return runningProcessThread.getModules();
        }
    }

    private static class RunningProcessThread
    extends Thread {
        private Misc.ProcessInfo[] modules = null;

        public RunningProcessThread() {
            super("running-process-thread");
            this.setDaemon(true);
            this.setPriority(3);
        }

        public Misc.ProcessInfo[] getModules() {
            return this.modules;
        }

        public void run() {
            this.modules = Misc.getRunningProcesses();
        }
    }
}

