/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.runtime.installer.AbstractRemoteCallable;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.platform.win32.Win32Services;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class ServiceHandler {
    private static boolean servicesStopped = false;
    static /* synthetic */ Class class$com$install4j$runtime$installer$helper$ServiceHandler;

    public static void resetStopState() {
        servicesStopped = false;
    }

    public static void stopServices(Context context, boolean bl) {
        if (!bl && servicesStopped) {
            return;
        }
        if (!InstallerUtil.isWindows() || InstallerUtil.isWindows9X()) {
            return;
        }
        List list = ContextImpl.getContextInt(context).getInstallationProperties().getPropertyList("service");
        List list2 = ContextImpl.getContextInt(context).getInstallationProperties().getPropertyList("serviceName");
        if (list.size() > 0 || list2.size() > 0) {
            ProgressInterface progressInterface = context.getProgressInterface();
            progressInterface.setStatusMessage(Messages.getMessages().getString("StatusStoppingServices"));
            progressInterface.setDetailMessage(" ");
            progressInterface.setIndeterminateProgress(true);
            context.runElevated(new StopRemoteCallable(list, list2), true);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            progressInterface.setIndeterminateProgress(false);
        }
        servicesStopped = true;
    }

    private static class StopRemoteCallable
    extends AbstractRemoteCallable {
        List services;
        List serviceNames;

        private StopRemoteCallable(List list, List list2) {
            this.services = list;
            this.serviceNames = list2;
        }

        public Serializable execute() {
            String string;
            Iterator iterator = this.services.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                Logger.getInstance().info(class$com$install4j$runtime$installer$helper$ServiceHandler == null ? ServiceHandler.class$("com.install4j.runtime.installer.helper.ServiceHandler") : class$com$install4j$runtime$installer$helper$ServiceHandler, "Stopping service " + string);
                if (!new File(string).exists()) continue;
                try {
                    Process process = Runtime.getRuntime().exec(new String[]{string, "/stop"});
                    process.waitFor();
                }
                catch (IOException iOException) {
                    Logger.getInstance().log(iOException);
                }
                catch (InterruptedException interruptedException) {
                    Logger.getInstance().log(interruptedException);
                }
            }
            iterator = this.serviceNames.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                Logger.getInstance().info(class$com$install4j$runtime$installer$helper$ServiceHandler == null ? ServiceHandler.class$("com.install4j.runtime.installer.helper.ServiceHandler") : class$com$install4j$runtime$installer$helper$ServiceHandler, "Stopping service " + string);
                try {
                    Win32Services.stopService(string);
                }
                catch (Win32Services.ServiceException serviceException) {
                    if (serviceException.getErrorCode() == 1062 || serviceException.getErrorCode() == 1060) continue;
                    Logger.getInstance().log(serviceException);
                }
            }
            return null;
        }
    }
}

