/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.fileinst;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.fileinst.BackupPair;
import com.install4j.runtime.installer.helper.fileinst.FileInstallerState;
import com.install4j.runtime.installer.helper.fileinst.FileLogger;
import com.install4j.runtime.installer.helper.fileinst.InstallFile;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class HelperFileInstallerState
extends FileInstallerState {
    public void setRollbackBarrier() {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            protected void run(Context context) {
                FileInstallerState.getInstance().setRollbackBarrier();
            }
        });
    }

    public void setLogDir(final File file) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            protected void run(Context context) {
                FileInstallerState.getInstance().setLogDir(file);
            }
        });
    }

    public void writeLog() throws IOException, UserCanceledException {
        HelperCommunication.getInstance().executeActionChecked(ExecutionContext.UNELEVATED, new RunAction(){

            protected void run(Context context) throws UserCanceledException {
                try {
                    FileInstallerState.getInstance().writeLog();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        });
    }

    public boolean wasPreviouslyCreated(final File file) {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            protected boolean fetchValue(Context context) throws UserCanceledException {
                return FileInstallerState.getInstance().wasPreviouslyCreated(file);
            }
        });
    }

    public boolean hasRollbackFiles() {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            protected boolean fetchValue(Context context) throws UserCanceledException {
                return FileInstallerState.getInstance().hasRollbackFiles();
            }
        });
    }

    public boolean hasUnrollbackedFiles() {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            protected boolean fetchValue(Context context) throws UserCanceledException {
                return FileInstallerState.getInstance().hasUnrollbackedFiles();
            }
        });
    }

    public void addReplacedFile(final BackupPair backupPair) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            protected void run(Context context) {
                FileInstallerState.getInstance().addReplacedFile(backupPair);
            }
        });
    }

    public void addCreatedDir(final InstallFile installFile) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            protected void run(Context context) {
                FileInstallerState.getInstance().addCreatedDir(installFile);
            }
        });
    }

    public void registerCleanupFile(final File file) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            protected void run(Context context) {
                FileInstallerState.getInstance().registerCleanupFile(file);
            }
        });
    }

    public void addCreatedFile(final InstallFile installFile, final boolean bl) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            protected void run(Context context) {
                FileInstallerState.getInstance().addCreatedFile(installFile, bl);
            }
        });
    }

    public FileLogger getRollbackFileLogger() {
        return (FileLogger)HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction(){

            protected Object fetchValue(Context context) throws UserCanceledException {
                return FileInstallerState.getInstance().getRollbackFileLogger();
            }
        });
    }

    public List getReplacedFiles() {
        return (List)HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction(){

            protected Object fetchValue(Context context) throws UserCanceledException {
                return FileInstallerState.getInstance().getReplacedFiles();
            }
        });
    }

    public List getCleanupFiles() {
        return (List)HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction(){

            protected Object fetchValue(Context context) throws UserCanceledException {
                return FileInstallerState.getInstance().getCleanupFiles();
            }
        });
    }

    public boolean isCurrentRebootRequired() {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            protected boolean fetchValue(Context context) throws UserCanceledException {
                return FileInstallerState.getInstance().isCurrentRebootRequired();
            }
        });
    }

    public void setCurrentRebootRequired(final boolean bl) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            protected void run(Context context) {
                FileInstallerState.getInstance().setCurrentRebootRequired(bl);
            }
        });
    }
}

