/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.unix.Execution;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PlistHelper {
    public static Element findValue(Element element, String string) throws IOException {
        String string2 = "";
        Iterator iterator = XmlHelper.childElements(element);
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            if (element2.getTagName().equals("key")) {
                string2 = XmlHelper.getTextValue(element2);
                continue;
            }
            if (!string2.equals(string)) continue;
            return element2;
        }
        throw new NotFoundException("could not find key: " + string);
    }

    public static Element getFirstChild(Element element, String string) throws IOException {
        Iterator iterator = XmlHelper.childElements(element);
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            if (!element2.getTagName().equals(string)) continue;
            return element2;
        }
        throw new NotFoundException("could not find child: " + string);
    }

    public static boolean removeElementWithChild(String string, String string2, String[] stringArray, String string3, boolean bl) throws IOException {
        File file = new File(new File(Util.getUserHome(), "Library/Preferences"), string + ".plist");
        File file2 = PlistHelper.getPlistXmlFile(file);
        Document document = XmlHelper.parseFile(file2);
        if (PlistHelper.removeElementWithChild(PlistHelper.findValue(PlistHelper.getFirstChild(document.getDocumentElement(), "dict"), string2), stringArray, string3, bl)) {
            Logger.getInstance().log(null, "removed child", true);
            XmlHelper.writeFile(file2, document);
            return PlistHelper.storePlistFile(file2, file);
        }
        return false;
    }

    public static boolean removeElementWithChild(Element element, String[] stringArray, String string, boolean bl) throws IOException {
        Iterator iterator = XmlHelper.childElements(element);
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            try {
                String string2;
                Element element3 = element2;
                for (int i = 0; element3 != null && i < stringArray.length; ++i) {
                    element3 = PlistHelper.findValue(element3, stringArray[i]);
                }
                if (element3 == null || !string.equals(string2 = XmlHelper.getTextValue(element3)) && (!bl || string2 == null || string2.indexOf(string) <= -1)) continue;
                element.removeChild(element2);
                return true;
            }
            catch (IOException iOException) {
            }
        }
        return false;
    }

    public static File getPlistXmlFile(File file) throws IOException {
        File file2 = File.createTempFile("i4j", ".plist");
        file2.deleteOnExit();
        FileUtil.copyFile(file, file2);
        StringBuffer stringBuffer = new StringBuffer();
        if (Execution.executeAndWait(new String[]{"plutil", "-convert", "xml1", file2.getAbsolutePath()}, stringBuffer)) {
            return file2;
        }
        file2.delete();
        throw new IOException("plutil returned " + stringBuffer.toString());
    }

    public static boolean storePlistFile(File file, File file2) throws IOException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (Execution.executeAndWait(new String[]{"plutil", "-convert", "binary1", file.getAbsolutePath()}, stringBuffer)) {
                FileUtil.copyFile(file, file2);
                boolean bl = true;
                return bl;
            }
            throw new IOException("plutil returned " + stringBuffer.toString());
        }
        finally {
            file.delete();
        }
    }

    public static boolean addToPlist(String string, String string2, Object[][] objectArray) {
        Integer n = LaunchHelper.launchApplication(new LaunchDescriptor(new File("/usr/bin/defaults")).arguments(new String[]{"write", string, string2, "-array-add", PlistHelper.getDict(objectArray)}).executionContext(ExecutionContext.UNELEVATED).wait(true));
        return n != null && n == 0;
    }

    public static String getDict(Object[][] objectArray) {
        if (objectArray.length != 2) {
            throw new IllegalArgumentException("array length: " + objectArray.length);
        }
        Object[] objectArray2 = objectArray[0];
        Object[] objectArray3 = objectArray[1];
        if (objectArray2.length != objectArray3.length) {
            throw new IllegalArgumentException("keys: " + objectArray2.length + ", values: " + objectArray3.length);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<dict>");
        for (int i = 0; i < objectArray2.length; ++i) {
            stringBuffer.append("<key>").append(objectArray2[i]).append("</key>");
            if (objectArray3[i] instanceof String) {
                stringBuffer.append("<string>").append(objectArray3[i]).append("</string>");
                continue;
            }
            if (objectArray3[i] instanceof Boolean) {
                if (((Boolean)objectArray3[i]).booleanValue()) {
                    stringBuffer.append("<true/>");
                    continue;
                }
                stringBuffer.append("<false/>");
                continue;
            }
            if (objectArray3[i] instanceof Integer) {
                stringBuffer.append("<integer>").append(objectArray3[i]).append("</integer>");
                continue;
            }
            if (objectArray3[i] instanceof Object[][]) {
                stringBuffer.append(PlistHelper.getDict((Object[][])objectArray3[i]));
                continue;
            }
            throw new IllegalArgumentException();
        }
        stringBuffer.append("</dict>");
        return stringBuffer.toString();
    }

    public static class NotFoundException
    extends IOException {
        public NotFoundException(String string) {
            super(string);
        }
    }
}

