/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.unix;

import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.StreamConsumerThread;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class Execution {
    public static boolean executeAndWait(String[] stringArray, StringBuffer stringBuffer) throws IOException {
        return Execution.executeWithReturnCode(stringArray, stringBuffer, false) == 0;
    }

    public static int executeWithReturnCode(String[] stringArray, StringBuffer stringBuffer, boolean bl) throws IOException {
        if (InstallerUtil.isWindows()) {
            Process process = Runtime.getRuntime().exec(stringArray);
            return Execution.handleProcess(process, stringBuffer, bl);
        }
        File file = File.createTempFile("i4j", ".sh");
        Process process = Execution.executeWithScript(stringArray, file);
        int n = Execution.handleProcess(process, stringBuffer, bl);
        file.delete();
        return n;
    }

    public static Process execute(String[] stringArray) throws IOException {
        if (InstallerUtil.isMacOS()) {
            File file = File.createTempFile("i4j", ".sh");
            return Execution.executeWithScript(stringArray, file);
        }
        return Runtime.getRuntime().exec(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int handleProcess(Process process, StringBuffer stringBuffer, boolean bl) throws IOException {
        try {
            StreamConsumerThread.consumeOutput(process, stringBuffer, bl);
            int n = process.waitFor();
            return n;
        }
        catch (InterruptedException interruptedException) {
            int n = 1;
            return n;
        }
        finally {
            process.destroy();
        }
    }

    private static Process executeWithScript(String[] stringArray, File file) throws IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), "UTF-8"));
        printWriter.println("#!/bin/sh");
        for (int i = 0; i < stringArray.length; ++i) {
            printWriter.print("\"" + stringArray[i] + "\"");
            if (i >= stringArray.length - 1) continue;
            printWriter.print(" ");
        }
        printWriter.println();
        printWriter.close();
        String[] stringArray2 = new String[]{"/bin/sh", file.getAbsolutePath()};
        return Runtime.getRuntime().exec(stringArray2);
    }
}

