/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import git4idea.history.GitCompressedRecord;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecordBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J$\u0010\u001c\u001a\u00020\u00022\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00140\u001e2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lgit4idea/history/CompressedRecordBuilder;", "Lgit4idea/history/GitLogRecordBuilder;", "Lgit4idea/history/GitCompressedRecord;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "pathsEncoder", "Lcom/intellij/vcs/log/impl/VcsLogIndexer$PathsEncoder;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/vcs/log/impl/VcsLogIndexer$PathsEncoder;)V", "changes", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lcom/intellij/openapi/vcs/changes/Change$Type;", "parents", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "renames", "Lit/unimi/dsi/fastutil/ints/Int2IntOpenHashMap;", "addPath", "", "type", "firstPath", "", "secondPath", "relativePath", "pathId", "", "addParents", "path", "getParentPath", "build", "options", "", "Lgit4idea/history/GitLogParser$GitLogOption;", "supportsRawBody", "", "clear", "intellij.vcs.git"})
public final class CompressedRecordBuilder
implements GitLogRecordBuilder<GitCompressedRecord> {
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final VcsLogIndexer.PathsEncoder pathsEncoder;
    @NotNull
    private Int2ObjectOpenHashMap<Change.Type> changes;
    @NotNull
    private IntOpenHashSet parents;
    @NotNull
    private Int2IntOpenHashMap renames;

    public CompressedRecordBuilder(@NotNull VirtualFile root, @NotNull VcsLogIndexer.PathsEncoder pathsEncoder) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)pathsEncoder, (String)"pathsEncoder");
        this.root = root;
        this.pathsEncoder = pathsEncoder;
        this.changes = new Int2ObjectOpenHashMap();
        this.parents = new IntOpenHashSet();
        this.renames = new Int2IntOpenHashMap();
    }

    @Override
    public void addPath(@NotNull Change.Type type, @NotNull String firstPath, @Nullable String secondPath) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)firstPath, (String)"firstPath");
        CharSequence charSequence = secondPath;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && !StringsKt.isBlank((CharSequence)firstPath)) {
            int beforeId = this.pathsEncoder.encode(this.root, firstPath, false);
            int afterId = this.pathsEncoder.encode(this.root, secondPath, false);
            this.addPath(firstPath, beforeId, Change.Type.DELETED);
            this.addPath(secondPath, afterId, Change.Type.NEW);
            this.renames.put(beforeId, afterId);
        } else if (!StringsKt.isBlank((CharSequence)firstPath)) {
            int pathId = this.pathsEncoder.encode(this.root, firstPath, false);
            this.addPath(firstPath, pathId, type);
        }
    }

    private final void addPath(String relativePath, int pathId, Change.Type type) {
        this.changes.put(pathId, (Object)type);
        this.addParents(relativePath);
    }

    private final void addParents(String path) {
        String parentPath = this.getParentPath(path);
        if (((CharSequence)parentPath).length() == 0) {
            return;
        }
        int parentPathId = this.pathsEncoder.encode(this.root, parentPath, true);
        while (!this.parents.contains(parentPathId)) {
            this.parents.add(parentPathId);
            parentPath = this.getParentPath(parentPath);
            if (((CharSequence)parentPath).length() == 0) break;
            parentPathId = this.pathsEncoder.encode(this.root, parentPath, true);
        }
    }

    private final String getParentPath(String path) {
        if (((CharSequence)path).length() == 0) {
            return "";
        }
        int end = StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
        switch (end) {
            case -1: 
            case 0: {
                return "";
            }
        }
        String string = path.substring(0, end);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @Override
    @NotNull
    public GitCompressedRecord build(@NotNull Map<GitLogParser.GitLogOption, String> options, boolean supportsRawBody) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        IntIterator intIterator = this.parents.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"iterator(...)");
        IntIterator iterator = intIterator;
        while (iterator.hasNext()) {
            this.changes.put(iterator.nextInt(), (Object)Change.Type.MODIFICATION);
        }
        return new GitCompressedRecord(options, (Int2ObjectMap<Change.Type>)((Int2ObjectMap)this.changes), (Int2IntMap)this.renames, supportsRawBody);
    }

    @Override
    public void clear() {
        this.changes = new Int2ObjectOpenHashMap();
        this.parents = new IntOpenHashSet();
        this.renames = new Int2IntOpenHashMap();
    }
}

