/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitVcs;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.GitBinaryHandler;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerInputProcessorUtil;
import git4idea.index.GitIndexUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitRevisionContentPreLoaderKt;
import git4idea.util.GitFileUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ,\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00100\u0015H\u0002J,\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lgit4idea/stash/GitRevisionContentPreLoader;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "RECORD_SEPARATOR", "", "preload", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "calcBlobHashesWithPaths", "", "Lgit4idea/stash/GitRevisionContentPreLoader$HashAndPath;", "toPreload", "", "Lcom/intellij/openapi/vcs/FilePath;", "splitOutput", "", "output", "hashes", "HashAndPath", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRevisionContentPreLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRevisionContentPreLoader.kt\ngit4idea/stash/GitRevisionContentPreLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,148:1\n1563#2:149\n1634#2,3:150\n1563#2:153\n1634#2,3:154\n1563#2:159\n1634#2,3:160\n216#3,2:157\n*S KotlinDebug\n*F\n+ 1 GitRevisionContentPreLoader.kt\ngit4idea/stash/GitRevisionContentPreLoader\n*L\n30#1:149\n30#1:150,3\n63#1:153\n63#1:154,3\n93#1:159\n93#1:160,3\n77#1:157,2\n*E\n"})
public final class GitRevisionContentPreLoader {
    @NotNull
    private final Project project;
    @NotNull
    private final String RECORD_SEPARATOR;

    /*
     * WARNING - void declaration
     */
    public GitRevisionContentPreLoader(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Iterable iterable = (Iterable)new IntRange(1, 10);
        GitRevisionContentPreLoader gitRevisionContentPreLoader = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.valueOf(StringsKt.random((CharSequence)"\u0001\u0002\u0003", (Random)((Random)Random.Default))));
        }
        gitRevisionContentPreLoader.RECORD_SEPARATOR = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    public final void preload(@NotNull VirtualFile root, @NotNull Collection<? extends Change> changes) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object beforeRevision;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Map toPreload = new LinkedHashMap();
        GitRevisionNumber gitRevisionNumber = GitChangeUtils.resolveReference(this.project, root, "HEAD");
        Intrinsics.checkNotNullExpressionValue((Object)gitRevisionNumber, (String)"resolveReference(...)");
        GitRevisionNumber head = gitRevisionNumber;
        for (Change change : changes) {
            FilePath path;
            beforeRevision = change.getBeforeRevision();
            if (!(beforeRevision instanceof GitContentRevision)) {
                Object object = beforeRevision;
                Object object2 = beforeRevision;
                GitRevisionContentPreLoaderKt.access$getLOG$p().warn("Skipping unsupported change " + change + ": revision: " + (beforeRevision != null && (object = object.getClass()) != null ? ((Class)object).getName() : null) + ", revisionNumber: " + (beforeRevision != null && (object2 = object2.getRevisionNumber()) != null && (object2 = object2.getClass()) != null ? ((Class)object2).getName() : null));
                continue;
            }
            if (!Intrinsics.areEqual((Object)((GitContentRevision)beforeRevision).getRevisionNumber(), (Object)head)) {
                GitRevisionContentPreLoaderKt.access$getLOG$p().warn("Skipping change " + change + " because beforeRevision does not match: '" + ((GitContentRevision)beforeRevision).getRevisionNumber() + "' vs '" + head + "'");
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)((GitContentRevision)beforeRevision).getFile(), (String)"getFile(...)");
            toPreload.put(path, change);
        }
        if (toPreload.isEmpty()) {
            return;
        }
        List<HashAndPath> list = this.calcBlobHashesWithPaths(root, toPreload);
        if (list == null) {
            return;
        }
        List<HashAndPath> hashesAndPaths = list;
        GitBinaryHandler gitBinaryHandler = new GitBinaryHandler(this.project, root, GitCommand.CAT_FILE);
        gitBinaryHandler.setSilent(true);
        GitFileUtils.addTextConvParameters(this.project, gitBinaryHandler, false);
        beforeRevision = new String[]{"--batch=" + this.RECORD_SEPARATOR + "%(objectname)"};
        gitBinaryHandler.addParameters((String)beforeRevision);
        gitBinaryHandler.endOptions();
        beforeRevision = hashesAndPaths;
        GitBinaryHandler gitBinaryHandler2 = gitBinaryHandler;
        boolean $i$f$map = false;
        void var9_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HashAndPath hashAndPath = (HashAndPath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getHash() + " " + it.getRelativePath());
        }
        gitBinaryHandler2.setInputProcessor(GitHandlerInputProcessorUtil.writeLines((List)destination$iv$iv, StandardCharsets.UTF_8));
        byte[] output2 = null;
        try {
            byte[] byArray = gitBinaryHandler.run();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"run(...)");
            output2 = byArray;
        }
        catch (Exception e) {
            GitRevisionContentPreLoaderKt.access$getLOG$p().error("Couldn't get git cat-file for " + hashesAndPaths, (Throwable)e);
            return;
        }
        Map<FilePath, byte[]> map2 = this.splitOutput(output2, hashesAndPaths);
        if (map2 == null) {
            return;
        }
        Map<FilePath, byte[]> split = map2;
        Map $this$forEach$iv = toPreload;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            FilePath path = (FilePath)entry.getKey();
            Change change = (Change)entry.getValue();
            ContentRevision contentRevision = change.getBeforeRevision();
            Intrinsics.checkNotNull((Object)contentRevision, (String)"null cannot be cast to non-null type git4idea.GitContentRevision");
            GitContentRevision oldBeforeRevision = (GitContentRevision)contentRevision;
            byte[] content = split.get(path);
            ContentRevisionCache cache2 = ProjectLevelVcsManager.getInstance((Project)this.project).getContentRevisionCache();
            cache2.putIntoConstantCache(oldBeforeRevision.getFile(), oldBeforeRevision.getRevisionNumber(), GitVcs.getKey(), content);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<HashAndPath> calcBlobHashesWithPaths(VirtualFile root, Map<FilePath, ? extends Change> toPreload) {
        void $this$mapTo$iv$iv;
        Repository repository2 = GitRepositoryManager.getInstance(this.project).getRepositoryForRoot(root);
        Intrinsics.checkNotNull((Object)repository2);
        GitRepository repository3 = (GitRepository)repository2;
        List<GitIndexUtil.StagedFileOrDirectory> list = GitIndexUtil.listTree(repository3, (Collection<? extends FilePath>)toPreload.keySet(), (VcsRevisionNumber)GitRevisionNumber.HEAD);
        Intrinsics.checkNotNullExpressionValue(list, (String)"listTree(...)");
        List<GitIndexUtil.StagedFileOrDirectory> trees = list;
        if (trees.size() != toPreload.size()) {
            GitRevisionContentPreLoaderKt.access$getLOG$p().warn("Incorrect number of trees " + trees.size() + " != " + toPreload.size());
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = trees;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void tree;
            GitIndexUtil.StagedFileOrDirectory stagedFileOrDirectory = (GitIndexUtil.StagedFileOrDirectory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (!(tree instanceof GitIndexUtil.StagedFile)) {
                GitRevisionContentPreLoaderKt.access$getLOG$p().warn("Unexpected tree: " + (GitIndexUtil.StagedFileOrDirectory)tree);
                return null;
            }
            String relativePath = VcsFileUtil.relativePath((VirtualFile)root, (FilePath)((GitIndexUtil.StagedFile)tree).getPath());
            if (relativePath == null) {
                Attachment[] attachmentArray = new Attachment[]{new Attachment("trees.txt", CollectionsKt.joinToString$default((Iterable)trees, null, null, null, (int)0, null, null, (int)63, null))};
                GitRevisionContentPreLoaderKt.access$getLOG$p().error("Unexpected ls-tree output", attachmentArray);
                return null;
            }
            String string = ((GitIndexUtil.StagedFile)tree).getBlobHash();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBlobHash(...)");
            FilePath filePath = ((GitIndexUtil.StagedFile)tree).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getPath(...)");
            collection.add(new HashAndPath(string, filePath, relativePath));
        }
        return (List)destination$iv$iv;
    }

    private final Map<FilePath, byte[]> splitOutput(byte[] output2, List<HashAndPath> hashes) {
        Map result2 = new LinkedHashMap();
        int currentPosition = 0;
        for (HashAndPath hashAndPath : hashes) {
            Attachment[] attachmentArray;
            int endIndex;
            byte[] plainSeparatorBytes;
            byte[] separatorBytes;
            String hash = hashAndPath.component1();
            FilePath path = hashAndPath.component2();
            String string = this.RECORD_SEPARATOR + hash + "\n";
            Intrinsics.checkNotNullExpressionValue((Object)string.getBytes(Charsets.UTF_8), (String)"getBytes(...)");
            if (!ArrayUtil.startsWith((byte[])output2, (int)currentPosition, (byte[])separatorBytes)) {
                string = new Attachment[]{new Attachment("catfile.txt", new String(output2, Charsets.UTF_8))};
                GitRevisionContentPreLoaderKt.access$getLOG$p().error("Unexpected output for hash " + hash + " at position " + currentPosition, (Attachment[])string);
                return null;
            }
            int startIndex = currentPosition + separatorBytes.length;
            String string2 = this.RECORD_SEPARATOR;
            Intrinsics.checkNotNullExpressionValue((Object)string2.getBytes(Charsets.UTF_8), (String)"getBytes(...)");
            int nextSeparator = ArrayUtil.indexOf((byte[])output2, (byte[])plainSeparatorBytes, (int)startIndex);
            int n = endIndex = nextSeparator > 0 ? nextSeparator : output2.length;
            if (endIndex > output2.length) {
                attachmentArray = new Attachment[]{new Attachment("catfile.txt", new String(output2, Charsets.UTF_8))};
                GitRevisionContentPreLoaderKt.access$getLOG$p().error("Unexpected output for hash " + hash + " at position " + currentPosition, attachmentArray);
                return null;
            }
            if (endIndex <= startIndex || output2[endIndex - 1] != 10) {
                attachmentArray = new Attachment[]{new Attachment("catfile.txt", new String(output2, Charsets.UTF_8))};
                GitRevisionContentPreLoaderKt.access$getLOG$p().error("Unexpected output for hash " + hash + " at position " + endIndex, attachmentArray);
                return null;
            }
            byte[] content = ArraysKt.copyOfRange((byte[])output2, (int)startIndex, (int)(endIndex - 1));
            result2.put(path, content);
            currentPosition = endIndex;
        }
        if (result2.size() != hashes.size()) {
            Attachment[] attachmentArray = new Attachment[]{new Attachment("catfile.txt", new String(output2, Charsets.UTF_8))};
            GitRevisionContentPreLoaderKt.access$getLOG$p().error("Invalid git cat-file output for " + hashes, attachmentArray);
            return null;
        }
        return result2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0018"}, d2={"Lgit4idea/stash/GitRevisionContentPreLoader$HashAndPath;", "", "hash", "", "path", "Lcom/intellij/openapi/vcs/FilePath;", "relativePath", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/vcs/FilePath;Ljava/lang/String;)V", "getHash", "()Ljava/lang/String;", "getPath", "()Lcom/intellij/openapi/vcs/FilePath;", "getRelativePath", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.git"})
    private static final class HashAndPath {
        @NotNull
        private final String hash;
        @NotNull
        private final FilePath path;
        @NotNull
        private final String relativePath;

        public HashAndPath(@NotNull String hash, @NotNull FilePath path, @NotNull String relativePath) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            this.hash = hash;
            this.path = path;
            this.relativePath = relativePath;
        }

        @NotNull
        public final String getHash() {
            return this.hash;
        }

        @NotNull
        public final FilePath getPath() {
            return this.path;
        }

        @NotNull
        public final String getRelativePath() {
            return this.relativePath;
        }

        @NotNull
        public final String component1() {
            return this.hash;
        }

        @NotNull
        public final FilePath component2() {
            return this.path;
        }

        @NotNull
        public final String component3() {
            return this.relativePath;
        }

        @NotNull
        public final HashAndPath copy(@NotNull String hash, @NotNull FilePath path, @NotNull String relativePath) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            return new HashAndPath(hash, path, relativePath);
        }

        public static /* synthetic */ HashAndPath copy$default(HashAndPath hashAndPath, String string, FilePath filePath, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = hashAndPath.hash;
            }
            if ((n & 2) != 0) {
                filePath = hashAndPath.path;
            }
            if ((n & 4) != 0) {
                string2 = hashAndPath.relativePath;
            }
            return hashAndPath.copy(string, filePath, string2);
        }

        @NotNull
        public String toString() {
            return "HashAndPath(hash=" + this.hash + ", path=" + this.path + ", relativePath=" + this.relativePath + ")";
        }

        public int hashCode() {
            int result2 = this.hash.hashCode();
            result2 = result2 * 31 + this.path.hashCode();
            result2 = result2 * 31 + this.relativePath.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HashAndPath)) {
                return false;
            }
            HashAndPath hashAndPath = (HashAndPath)other;
            if (!Intrinsics.areEqual((Object)this.hash, (Object)hashAndPath.hash)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path, (Object)hashAndPath.path)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.relativePath, (Object)hashAndPath.relativePath);
        }
    }
}

