/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.Calendar;
import org.languagetool.rules.AbstractDateCheckWithSuggestionsFilter;
import org.languagetool.rules.en.DateFilterHelper;
import org.languagetool.tools.StringTools;

public class DateCheckFilter
extends AbstractDateCheckWithSuggestionsFilter {
    private final DateFilterHelper dateFilterHelper = new DateFilterHelper();

    protected Calendar getCalendar() {
        return this.dateFilterHelper.getCalendar();
    }

    protected String getErrorMessageWrongYear() {
        return "This date is wrong. Did you mean \"{currentYear}\"?";
    }

    protected int getDayOfWeek(String dayStr) {
        return this.dateFilterHelper.getDayOfWeek(dayStr);
    }

    protected String getDayOfWeek(Calendar date) {
        return this.dateFilterHelper.getDayOfWeek(date);
    }

    protected int getMonth(String monthStr) {
        return this.dateFilterHelper.getMonth(monthStr);
    }

    protected String getDayStrLikeOriginal(String day, String original) {
        if (StringTools.isNumeric((String)original)) {
            return day;
        }
        int number = Integer.parseInt(day);
        if (number >= 11 && number <= 13) {
            return number + "th";
        }
        switch (number % 10) {
            case 1: {
                return number + "st";
            }
            case 2: {
                return number + "nd";
            }
            case 3: {
                return number + "rd";
            }
        }
        return number + "th";
    }
}

