/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.io;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public enum BOM {
    UTF32_LE("UTF-32LE"),
    UTF32_BE("UTF-32BE"),
    UTF16_LE("UTF-16LE"),
    UTF16_BE("UTF-16BE"),
    UTF8("UTF-8");

    private String encoding;
    private int[] expected;

    private BOM(String encoding) {
        this.encoding = encoding;
        byte[] byteBom = "\ufeff".getBytes(Charset.forName(encoding));
        this.expected = new int[byteBom.length];
        for (int i = 0; i < byteBom.length; ++i) {
            this.expected[i] = byteBom[i] & 0xFF;
        }
    }

    public String encoding() {
        return this.encoding;
    }

    public int[] expected() {
        return this.expected;
    }

    private boolean matches(ByteBuffer buffer) {
        int pos = buffer.position();
        for (int i : this.expected) {
            if (i == (buffer.get() & 0xFF)) continue;
            buffer.position(pos);
            return false;
        }
        return true;
    }

    public static BOM detect(ByteBuffer buffer) {
        int available = buffer.remaining();
        for (BOM bom : BOM.values()) {
            if (available >= bom.expected.length) {
                if (!bom.matches(buffer)) continue;
                return bom;
            }
            return null;
        }
        return null;
    }
}

