/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.zipflinger.BytesSource;
import com.android.zipflinger.LargeFileSource;
import com.android.zipflinger.ZipArchive;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;

public interface ApkSetWriter {
    public Path getSplitsDirectory();

    public void writeApkSet(Commands.BuildApksResult var1) throws IOException;

    public void writeApkSetWithoutToc(Commands.BuildApksResult var1) throws IOException;

    public void writeApkSet(Commands.BuildSdkApksResult var1) throws IOException;

    public static ApkSetWriter directory(final Path outputDirectory) {
        return new ApkSetWriter(){

            @Override
            public Path getSplitsDirectory() {
                return outputDirectory;
            }

            @Override
            public void writeApkSet(Commands.BuildApksResult toc) throws IOException {
                Files.write(this.getSplitsDirectory().resolve("toc.pb"), toc.toByteArray(), new OpenOption[0]);
            }

            @Override
            public void writeApkSetWithoutToc(Commands.BuildApksResult toc) {
            }

            @Override
            public void writeApkSet(Commands.BuildSdkApksResult toc) throws IOException {
                Files.write(this.getSplitsDirectory().resolve("toc.pb"), toc.toByteArray(), new OpenOption[0]);
            }
        };
    }

    public static ApkSetWriter zip(final Path tempDirectory, final Path outputFile) {
        return new ApkSetWriter(){

            @Override
            public Path getSplitsDirectory() {
                return tempDirectory;
            }

            @Override
            public void writeApkSet(Commands.BuildApksResult toc) throws IOException {
                this.zipApkSet(this.getApkRelativePaths(toc), toc.toByteArray());
            }

            @Override
            public void writeApkSetWithoutToc(Commands.BuildApksResult toc) throws IOException {
                this.zipApkSet(this.getApkRelativePaths(toc), toc.toByteArray(), false);
            }

            @Override
            public void writeApkSet(Commands.BuildSdkApksResult toc) throws IOException {
                Stream<String> apks = toc.getVariantList().stream().flatMap(variant -> variant.getApkSetList().stream()).flatMap(apkSet -> apkSet.getApkDescriptionList().stream());
                ImmutableSet<String> apkRelativePaths = apks.map(Commands.ApkDescription::getPath).sorted().collect(ImmutableSet.toImmutableSet());
                this.zipApkSet(apkRelativePaths, toc.toByteArray());
            }

            private void zipApkSet(ImmutableSet<String> apkRelativePaths, byte[] tocBytes) throws IOException {
                this.zipApkSet(apkRelativePaths, tocBytes, true);
            }

            private void zipApkSet(ImmutableSet<String> apkRelativePaths, byte[] tocBytes, boolean serializeToc) throws IOException {
                try (ZipArchive zipArchive = new ZipArchive(outputFile);){
                    if (serializeToc) {
                        zipArchive.add(new BytesSource(tocBytes, "toc.pb", 0));
                    }
                    for (String relativePath : apkRelativePaths) {
                        zipArchive.add(new LargeFileSource(this.getSplitsDirectory().resolve(relativePath), null, relativePath, 0));
                    }
                }
            }

            private ImmutableSet<String> getApkRelativePaths(Commands.BuildApksResult toc) {
                Stream apks = toc.getVariantList().stream().flatMap(variant -> variant.getApkSetList().stream()).flatMap(apkSet -> apkSet.getApkDescriptionList().stream());
                Stream assets = toc.getAssetSliceSetList().stream().flatMap(assetSliceSet -> assetSliceSet.getApkDescriptionList().stream());
                return Stream.concat(apks, assets).map(Commands.ApkDescription::getPath).sorted().collect(ImmutableSet.toImmutableSet());
            }
        };
    }
}

