// Copyright 2020-2022 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             (unknown)
// source: buf/alpha/registry/v1alpha1/authz.proto

package registryv1alpha1

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// AuthzServiceClient is the client API for AuthzService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AuthzServiceClient interface {
	// UserCanCreateOrganizationRepository returns whether the user is authorized
	// to create repositories in an organization.
	UserCanCreateOrganizationRepository(ctx context.Context, in *UserCanCreateOrganizationRepositoryRequest, opts ...grpc.CallOption) (*UserCanCreateOrganizationRepositoryResponse, error)
	// UserCanSeeRepositorySettings returns whether the user is authorized
	// to see repository settings.
	UserCanSeeRepositorySettings(ctx context.Context, in *UserCanSeeRepositorySettingsRequest, opts ...grpc.CallOption) (*UserCanSeeRepositorySettingsResponse, error)
	// UserCanSeeOrganizationSettings returns whether the user is authorized
	// to see organization settings.
	UserCanSeeOrganizationSettings(ctx context.Context, in *UserCanSeeOrganizationSettingsRequest, opts ...grpc.CallOption) (*UserCanSeeOrganizationSettingsResponse, error)
	// UserCanReadPlugin returns whether the user has read access to the specified plugin.
	UserCanReadPlugin(ctx context.Context, in *UserCanReadPluginRequest, opts ...grpc.CallOption) (*UserCanReadPluginResponse, error)
	// UserCanCreatePluginVersion returns whether the user is authorized
	// to create a plugin version under the specified plugin.
	UserCanCreatePluginVersion(ctx context.Context, in *UserCanCreatePluginVersionRequest, opts ...grpc.CallOption) (*UserCanCreatePluginVersionResponse, error)
	// UserCanCreateTemplateVersion returns whether the user is authorized
	// to create a template version under the specified template.
	UserCanCreateTemplateVersion(ctx context.Context, in *UserCanCreateTemplateVersionRequest, opts ...grpc.CallOption) (*UserCanCreateTemplateVersionResponse, error)
	// UserCanCreateOrganizationPlugin returns whether the user is authorized to create
	// a plugin in an organization.
	UserCanCreateOrganizationPlugin(ctx context.Context, in *UserCanCreateOrganizationPluginRequest, opts ...grpc.CallOption) (*UserCanCreateOrganizationPluginResponse, error)
	// UserCanCreateOrganizationPlugin returns whether the user is authorized to create
	// a template in an organization.
	UserCanCreateOrganizationTemplate(ctx context.Context, in *UserCanCreateOrganizationTemplateRequest, opts ...grpc.CallOption) (*UserCanCreateOrganizationTemplateResponse, error)
	// UserCanSeePluginSettings returns whether the user is authorized
	// to see plugin settings.
	UserCanSeePluginSettings(ctx context.Context, in *UserCanSeePluginSettingsRequest, opts ...grpc.CallOption) (*UserCanSeePluginSettingsResponse, error)
	// UserCanSeeTemplateSettings returns whether the user is authorized
	// to see template settings.
	UserCanSeeTemplateSettings(ctx context.Context, in *UserCanSeeTemplateSettingsRequest, opts ...grpc.CallOption) (*UserCanSeeTemplateSettingsResponse, error)
	// UserCanAddOrganizationMember returns whether the user is authorized to add
	// any members to the organization and the list of roles they can add.
	UserCanAddOrganizationMember(ctx context.Context, in *UserCanAddOrganizationMemberRequest, opts ...grpc.CallOption) (*UserCanAddOrganizationMemberResponse, error)
	// UserCanUpdateOrganizationMember returns whether the user is authorized to update
	// any members' membership information in the organization and the list of roles they can update.
	UserCanUpdateOrganizationMember(ctx context.Context, in *UserCanUpdateOrganizationMemberRequest, opts ...grpc.CallOption) (*UserCanUpdateOrganizationMemberResponse, error)
	// UserCanRemoveOrganizationMember returns whether the user is authorized to remove
	// any members from the organization and the list of roles they can remove.
	UserCanRemoveOrganizationMember(ctx context.Context, in *UserCanRemoveOrganizationMemberRequest, opts ...grpc.CallOption) (*UserCanRemoveOrganizationMemberResponse, error)
	// UserCanDeleteOrganization returns whether the user is authorized
	// to delete an organization.
	UserCanDeleteOrganization(ctx context.Context, in *UserCanDeleteOrganizationRequest, opts ...grpc.CallOption) (*UserCanDeleteOrganizationResponse, error)
	// UserCanDeleteRepository returns whether the user is authorized
	// to delete a repository.
	UserCanDeleteRepository(ctx context.Context, in *UserCanDeleteRepositoryRequest, opts ...grpc.CallOption) (*UserCanDeleteRepositoryResponse, error)
	// UserCanDeleteTemplate returns whether the user is authorized
	// to delete a template.
	UserCanDeleteTemplate(ctx context.Context, in *UserCanDeleteTemplateRequest, opts ...grpc.CallOption) (*UserCanDeleteTemplateResponse, error)
	// UserCanDeletePlugin returns whether the user is authorized
	// to delete a plugin.
	UserCanDeletePlugin(ctx context.Context, in *UserCanDeletePluginRequest, opts ...grpc.CallOption) (*UserCanDeletePluginResponse, error)
	// UserCanDeleteUser returns whether the user is authorized
	// to delete a user.
	UserCanDeleteUser(ctx context.Context, in *UserCanDeleteUserRequest, opts ...grpc.CallOption) (*UserCanDeleteUserResponse, error)
	// UserCanSeeServerAdminPanel returns whether the user is authorized
	// to see server admin panel.
	UserCanSeeServerAdminPanel(ctx context.Context, in *UserCanSeeServerAdminPanelRequest, opts ...grpc.CallOption) (*UserCanSeeServerAdminPanelResponse, error)
	// UserCanManageRepositoryContributors returns whether the user is authorized to manage
	// any contributors to the repository and the list of roles they can manage.
	UserCanManageRepositoryContributors(ctx context.Context, in *UserCanManageRepositoryContributorsRequest, opts ...grpc.CallOption) (*UserCanManageRepositoryContributorsResponse, error)
	// UserCanManagePluginContributors returns whether the user is authorized to manage
	// any contributors to the plugin and the list of roles they can manage.
	UserCanManagePluginContributors(ctx context.Context, in *UserCanManagePluginContributorsRequest, opts ...grpc.CallOption) (*UserCanManagePluginContributorsResponse, error)
	// UserCanManageTemplateContributors returns whether the user is authorized to manage
	// any contributors to the template and the list of roles they can manage.
	UserCanManageTemplateContributors(ctx context.Context, in *UserCanManageTemplateContributorsRequest, opts ...grpc.CallOption) (*UserCanManageTemplateContributorsResponse, error)
}

type authzServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAuthzServiceClient(cc grpc.ClientConnInterface) AuthzServiceClient {
	return &authzServiceClient{cc}
}

func (c *authzServiceClient) UserCanCreateOrganizationRepository(ctx context.Context, in *UserCanCreateOrganizationRepositoryRequest, opts ...grpc.CallOption) (*UserCanCreateOrganizationRepositoryResponse, error) {
	out := new(UserCanCreateOrganizationRepositoryResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreateOrganizationRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanSeeRepositorySettings(ctx context.Context, in *UserCanSeeRepositorySettingsRequest, opts ...grpc.CallOption) (*UserCanSeeRepositorySettingsResponse, error) {
	out := new(UserCanSeeRepositorySettingsResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeeRepositorySettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanSeeOrganizationSettings(ctx context.Context, in *UserCanSeeOrganizationSettingsRequest, opts ...grpc.CallOption) (*UserCanSeeOrganizationSettingsResponse, error) {
	out := new(UserCanSeeOrganizationSettingsResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeeOrganizationSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanReadPlugin(ctx context.Context, in *UserCanReadPluginRequest, opts ...grpc.CallOption) (*UserCanReadPluginResponse, error) {
	out := new(UserCanReadPluginResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanReadPlugin", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanCreatePluginVersion(ctx context.Context, in *UserCanCreatePluginVersionRequest, opts ...grpc.CallOption) (*UserCanCreatePluginVersionResponse, error) {
	out := new(UserCanCreatePluginVersionResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreatePluginVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanCreateTemplateVersion(ctx context.Context, in *UserCanCreateTemplateVersionRequest, opts ...grpc.CallOption) (*UserCanCreateTemplateVersionResponse, error) {
	out := new(UserCanCreateTemplateVersionResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreateTemplateVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanCreateOrganizationPlugin(ctx context.Context, in *UserCanCreateOrganizationPluginRequest, opts ...grpc.CallOption) (*UserCanCreateOrganizationPluginResponse, error) {
	out := new(UserCanCreateOrganizationPluginResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreateOrganizationPlugin", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanCreateOrganizationTemplate(ctx context.Context, in *UserCanCreateOrganizationTemplateRequest, opts ...grpc.CallOption) (*UserCanCreateOrganizationTemplateResponse, error) {
	out := new(UserCanCreateOrganizationTemplateResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreateOrganizationTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanSeePluginSettings(ctx context.Context, in *UserCanSeePluginSettingsRequest, opts ...grpc.CallOption) (*UserCanSeePluginSettingsResponse, error) {
	out := new(UserCanSeePluginSettingsResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeePluginSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanSeeTemplateSettings(ctx context.Context, in *UserCanSeeTemplateSettingsRequest, opts ...grpc.CallOption) (*UserCanSeeTemplateSettingsResponse, error) {
	out := new(UserCanSeeTemplateSettingsResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeeTemplateSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanAddOrganizationMember(ctx context.Context, in *UserCanAddOrganizationMemberRequest, opts ...grpc.CallOption) (*UserCanAddOrganizationMemberResponse, error) {
	out := new(UserCanAddOrganizationMemberResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanAddOrganizationMember", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanUpdateOrganizationMember(ctx context.Context, in *UserCanUpdateOrganizationMemberRequest, opts ...grpc.CallOption) (*UserCanUpdateOrganizationMemberResponse, error) {
	out := new(UserCanUpdateOrganizationMemberResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanUpdateOrganizationMember", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanRemoveOrganizationMember(ctx context.Context, in *UserCanRemoveOrganizationMemberRequest, opts ...grpc.CallOption) (*UserCanRemoveOrganizationMemberResponse, error) {
	out := new(UserCanRemoveOrganizationMemberResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanRemoveOrganizationMember", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanDeleteOrganization(ctx context.Context, in *UserCanDeleteOrganizationRequest, opts ...grpc.CallOption) (*UserCanDeleteOrganizationResponse, error) {
	out := new(UserCanDeleteOrganizationResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeleteOrganization", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanDeleteRepository(ctx context.Context, in *UserCanDeleteRepositoryRequest, opts ...grpc.CallOption) (*UserCanDeleteRepositoryResponse, error) {
	out := new(UserCanDeleteRepositoryResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeleteRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanDeleteTemplate(ctx context.Context, in *UserCanDeleteTemplateRequest, opts ...grpc.CallOption) (*UserCanDeleteTemplateResponse, error) {
	out := new(UserCanDeleteTemplateResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeleteTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanDeletePlugin(ctx context.Context, in *UserCanDeletePluginRequest, opts ...grpc.CallOption) (*UserCanDeletePluginResponse, error) {
	out := new(UserCanDeletePluginResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeletePlugin", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanDeleteUser(ctx context.Context, in *UserCanDeleteUserRequest, opts ...grpc.CallOption) (*UserCanDeleteUserResponse, error) {
	out := new(UserCanDeleteUserResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeleteUser", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanSeeServerAdminPanel(ctx context.Context, in *UserCanSeeServerAdminPanelRequest, opts ...grpc.CallOption) (*UserCanSeeServerAdminPanelResponse, error) {
	out := new(UserCanSeeServerAdminPanelResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeeServerAdminPanel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanManageRepositoryContributors(ctx context.Context, in *UserCanManageRepositoryContributorsRequest, opts ...grpc.CallOption) (*UserCanManageRepositoryContributorsResponse, error) {
	out := new(UserCanManageRepositoryContributorsResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanManageRepositoryContributors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanManagePluginContributors(ctx context.Context, in *UserCanManagePluginContributorsRequest, opts ...grpc.CallOption) (*UserCanManagePluginContributorsResponse, error) {
	out := new(UserCanManagePluginContributorsResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanManagePluginContributors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *authzServiceClient) UserCanManageTemplateContributors(ctx context.Context, in *UserCanManageTemplateContributorsRequest, opts ...grpc.CallOption) (*UserCanManageTemplateContributorsResponse, error) {
	out := new(UserCanManageTemplateContributorsResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.AuthzService/UserCanManageTemplateContributors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AuthzServiceServer is the server API for AuthzService service.
// All implementations should embed UnimplementedAuthzServiceServer
// for forward compatibility
type AuthzServiceServer interface {
	// UserCanCreateOrganizationRepository returns whether the user is authorized
	// to create repositories in an organization.
	UserCanCreateOrganizationRepository(context.Context, *UserCanCreateOrganizationRepositoryRequest) (*UserCanCreateOrganizationRepositoryResponse, error)
	// UserCanSeeRepositorySettings returns whether the user is authorized
	// to see repository settings.
	UserCanSeeRepositorySettings(context.Context, *UserCanSeeRepositorySettingsRequest) (*UserCanSeeRepositorySettingsResponse, error)
	// UserCanSeeOrganizationSettings returns whether the user is authorized
	// to see organization settings.
	UserCanSeeOrganizationSettings(context.Context, *UserCanSeeOrganizationSettingsRequest) (*UserCanSeeOrganizationSettingsResponse, error)
	// UserCanReadPlugin returns whether the user has read access to the specified plugin.
	UserCanReadPlugin(context.Context, *UserCanReadPluginRequest) (*UserCanReadPluginResponse, error)
	// UserCanCreatePluginVersion returns whether the user is authorized
	// to create a plugin version under the specified plugin.
	UserCanCreatePluginVersion(context.Context, *UserCanCreatePluginVersionRequest) (*UserCanCreatePluginVersionResponse, error)
	// UserCanCreateTemplateVersion returns whether the user is authorized
	// to create a template version under the specified template.
	UserCanCreateTemplateVersion(context.Context, *UserCanCreateTemplateVersionRequest) (*UserCanCreateTemplateVersionResponse, error)
	// UserCanCreateOrganizationPlugin returns whether the user is authorized to create
	// a plugin in an organization.
	UserCanCreateOrganizationPlugin(context.Context, *UserCanCreateOrganizationPluginRequest) (*UserCanCreateOrganizationPluginResponse, error)
	// UserCanCreateOrganizationPlugin returns whether the user is authorized to create
	// a template in an organization.
	UserCanCreateOrganizationTemplate(context.Context, *UserCanCreateOrganizationTemplateRequest) (*UserCanCreateOrganizationTemplateResponse, error)
	// UserCanSeePluginSettings returns whether the user is authorized
	// to see plugin settings.
	UserCanSeePluginSettings(context.Context, *UserCanSeePluginSettingsRequest) (*UserCanSeePluginSettingsResponse, error)
	// UserCanSeeTemplateSettings returns whether the user is authorized
	// to see template settings.
	UserCanSeeTemplateSettings(context.Context, *UserCanSeeTemplateSettingsRequest) (*UserCanSeeTemplateSettingsResponse, error)
	// UserCanAddOrganizationMember returns whether the user is authorized to add
	// any members to the organization and the list of roles they can add.
	UserCanAddOrganizationMember(context.Context, *UserCanAddOrganizationMemberRequest) (*UserCanAddOrganizationMemberResponse, error)
	// UserCanUpdateOrganizationMember returns whether the user is authorized to update
	// any members' membership information in the organization and the list of roles they can update.
	UserCanUpdateOrganizationMember(context.Context, *UserCanUpdateOrganizationMemberRequest) (*UserCanUpdateOrganizationMemberResponse, error)
	// UserCanRemoveOrganizationMember returns whether the user is authorized to remove
	// any members from the organization and the list of roles they can remove.
	UserCanRemoveOrganizationMember(context.Context, *UserCanRemoveOrganizationMemberRequest) (*UserCanRemoveOrganizationMemberResponse, error)
	// UserCanDeleteOrganization returns whether the user is authorized
	// to delete an organization.
	UserCanDeleteOrganization(context.Context, *UserCanDeleteOrganizationRequest) (*UserCanDeleteOrganizationResponse, error)
	// UserCanDeleteRepository returns whether the user is authorized
	// to delete a repository.
	UserCanDeleteRepository(context.Context, *UserCanDeleteRepositoryRequest) (*UserCanDeleteRepositoryResponse, error)
	// UserCanDeleteTemplate returns whether the user is authorized
	// to delete a template.
	UserCanDeleteTemplate(context.Context, *UserCanDeleteTemplateRequest) (*UserCanDeleteTemplateResponse, error)
	// UserCanDeletePlugin returns whether the user is authorized
	// to delete a plugin.
	UserCanDeletePlugin(context.Context, *UserCanDeletePluginRequest) (*UserCanDeletePluginResponse, error)
	// UserCanDeleteUser returns whether the user is authorized
	// to delete a user.
	UserCanDeleteUser(context.Context, *UserCanDeleteUserRequest) (*UserCanDeleteUserResponse, error)
	// UserCanSeeServerAdminPanel returns whether the user is authorized
	// to see server admin panel.
	UserCanSeeServerAdminPanel(context.Context, *UserCanSeeServerAdminPanelRequest) (*UserCanSeeServerAdminPanelResponse, error)
	// UserCanManageRepositoryContributors returns whether the user is authorized to manage
	// any contributors to the repository and the list of roles they can manage.
	UserCanManageRepositoryContributors(context.Context, *UserCanManageRepositoryContributorsRequest) (*UserCanManageRepositoryContributorsResponse, error)
	// UserCanManagePluginContributors returns whether the user is authorized to manage
	// any contributors to the plugin and the list of roles they can manage.
	UserCanManagePluginContributors(context.Context, *UserCanManagePluginContributorsRequest) (*UserCanManagePluginContributorsResponse, error)
	// UserCanManageTemplateContributors returns whether the user is authorized to manage
	// any contributors to the template and the list of roles they can manage.
	UserCanManageTemplateContributors(context.Context, *UserCanManageTemplateContributorsRequest) (*UserCanManageTemplateContributorsResponse, error)
}

// UnimplementedAuthzServiceServer should be embedded to have forward compatible implementations.
type UnimplementedAuthzServiceServer struct {
}

func (UnimplementedAuthzServiceServer) UserCanCreateOrganizationRepository(context.Context, *UserCanCreateOrganizationRepositoryRequest) (*UserCanCreateOrganizationRepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanCreateOrganizationRepository not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanSeeRepositorySettings(context.Context, *UserCanSeeRepositorySettingsRequest) (*UserCanSeeRepositorySettingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanSeeRepositorySettings not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanSeeOrganizationSettings(context.Context, *UserCanSeeOrganizationSettingsRequest) (*UserCanSeeOrganizationSettingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanSeeOrganizationSettings not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanReadPlugin(context.Context, *UserCanReadPluginRequest) (*UserCanReadPluginResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanReadPlugin not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanCreatePluginVersion(context.Context, *UserCanCreatePluginVersionRequest) (*UserCanCreatePluginVersionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanCreatePluginVersion not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanCreateTemplateVersion(context.Context, *UserCanCreateTemplateVersionRequest) (*UserCanCreateTemplateVersionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanCreateTemplateVersion not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanCreateOrganizationPlugin(context.Context, *UserCanCreateOrganizationPluginRequest) (*UserCanCreateOrganizationPluginResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanCreateOrganizationPlugin not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanCreateOrganizationTemplate(context.Context, *UserCanCreateOrganizationTemplateRequest) (*UserCanCreateOrganizationTemplateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanCreateOrganizationTemplate not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanSeePluginSettings(context.Context, *UserCanSeePluginSettingsRequest) (*UserCanSeePluginSettingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanSeePluginSettings not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanSeeTemplateSettings(context.Context, *UserCanSeeTemplateSettingsRequest) (*UserCanSeeTemplateSettingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanSeeTemplateSettings not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanAddOrganizationMember(context.Context, *UserCanAddOrganizationMemberRequest) (*UserCanAddOrganizationMemberResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanAddOrganizationMember not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanUpdateOrganizationMember(context.Context, *UserCanUpdateOrganizationMemberRequest) (*UserCanUpdateOrganizationMemberResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanUpdateOrganizationMember not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanRemoveOrganizationMember(context.Context, *UserCanRemoveOrganizationMemberRequest) (*UserCanRemoveOrganizationMemberResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanRemoveOrganizationMember not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanDeleteOrganization(context.Context, *UserCanDeleteOrganizationRequest) (*UserCanDeleteOrganizationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanDeleteOrganization not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanDeleteRepository(context.Context, *UserCanDeleteRepositoryRequest) (*UserCanDeleteRepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanDeleteRepository not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanDeleteTemplate(context.Context, *UserCanDeleteTemplateRequest) (*UserCanDeleteTemplateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanDeleteTemplate not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanDeletePlugin(context.Context, *UserCanDeletePluginRequest) (*UserCanDeletePluginResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanDeletePlugin not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanDeleteUser(context.Context, *UserCanDeleteUserRequest) (*UserCanDeleteUserResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanDeleteUser not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanSeeServerAdminPanel(context.Context, *UserCanSeeServerAdminPanelRequest) (*UserCanSeeServerAdminPanelResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanSeeServerAdminPanel not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanManageRepositoryContributors(context.Context, *UserCanManageRepositoryContributorsRequest) (*UserCanManageRepositoryContributorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanManageRepositoryContributors not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanManagePluginContributors(context.Context, *UserCanManagePluginContributorsRequest) (*UserCanManagePluginContributorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanManagePluginContributors not implemented")
}
func (UnimplementedAuthzServiceServer) UserCanManageTemplateContributors(context.Context, *UserCanManageTemplateContributorsRequest) (*UserCanManageTemplateContributorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCanManageTemplateContributors not implemented")
}

// UnsafeAuthzServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AuthzServiceServer will
// result in compilation errors.
type UnsafeAuthzServiceServer interface {
	mustEmbedUnimplementedAuthzServiceServer()
}

func RegisterAuthzServiceServer(s grpc.ServiceRegistrar, srv AuthzServiceServer) {
	s.RegisterService(&AuthzService_ServiceDesc, srv)
}

func _AuthzService_UserCanCreateOrganizationRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanCreateOrganizationRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanCreateOrganizationRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreateOrganizationRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanCreateOrganizationRepository(ctx, req.(*UserCanCreateOrganizationRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanSeeRepositorySettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanSeeRepositorySettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanSeeRepositorySettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeeRepositorySettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanSeeRepositorySettings(ctx, req.(*UserCanSeeRepositorySettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanSeeOrganizationSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanSeeOrganizationSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanSeeOrganizationSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeeOrganizationSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanSeeOrganizationSettings(ctx, req.(*UserCanSeeOrganizationSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanReadPlugin_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanReadPluginRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanReadPlugin(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanReadPlugin",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanReadPlugin(ctx, req.(*UserCanReadPluginRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanCreatePluginVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanCreatePluginVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanCreatePluginVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreatePluginVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanCreatePluginVersion(ctx, req.(*UserCanCreatePluginVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanCreateTemplateVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanCreateTemplateVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanCreateTemplateVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreateTemplateVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanCreateTemplateVersion(ctx, req.(*UserCanCreateTemplateVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanCreateOrganizationPlugin_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanCreateOrganizationPluginRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanCreateOrganizationPlugin(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreateOrganizationPlugin",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanCreateOrganizationPlugin(ctx, req.(*UserCanCreateOrganizationPluginRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanCreateOrganizationTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanCreateOrganizationTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanCreateOrganizationTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanCreateOrganizationTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanCreateOrganizationTemplate(ctx, req.(*UserCanCreateOrganizationTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanSeePluginSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanSeePluginSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanSeePluginSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeePluginSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanSeePluginSettings(ctx, req.(*UserCanSeePluginSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanSeeTemplateSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanSeeTemplateSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanSeeTemplateSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeeTemplateSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanSeeTemplateSettings(ctx, req.(*UserCanSeeTemplateSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanAddOrganizationMember_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanAddOrganizationMemberRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanAddOrganizationMember(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanAddOrganizationMember",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanAddOrganizationMember(ctx, req.(*UserCanAddOrganizationMemberRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanUpdateOrganizationMember_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanUpdateOrganizationMemberRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanUpdateOrganizationMember(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanUpdateOrganizationMember",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanUpdateOrganizationMember(ctx, req.(*UserCanUpdateOrganizationMemberRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanRemoveOrganizationMember_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanRemoveOrganizationMemberRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanRemoveOrganizationMember(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanRemoveOrganizationMember",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanRemoveOrganizationMember(ctx, req.(*UserCanRemoveOrganizationMemberRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanDeleteOrganization_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanDeleteOrganizationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanDeleteOrganization(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeleteOrganization",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanDeleteOrganization(ctx, req.(*UserCanDeleteOrganizationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanDeleteRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanDeleteRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanDeleteRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeleteRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanDeleteRepository(ctx, req.(*UserCanDeleteRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanDeleteTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanDeleteTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanDeleteTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeleteTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanDeleteTemplate(ctx, req.(*UserCanDeleteTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanDeletePlugin_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanDeletePluginRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanDeletePlugin(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeletePlugin",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanDeletePlugin(ctx, req.(*UserCanDeletePluginRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanDeleteUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanDeleteUserRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanDeleteUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanDeleteUser",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanDeleteUser(ctx, req.(*UserCanDeleteUserRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanSeeServerAdminPanel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanSeeServerAdminPanelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanSeeServerAdminPanel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanSeeServerAdminPanel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanSeeServerAdminPanel(ctx, req.(*UserCanSeeServerAdminPanelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanManageRepositoryContributors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanManageRepositoryContributorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanManageRepositoryContributors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanManageRepositoryContributors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanManageRepositoryContributors(ctx, req.(*UserCanManageRepositoryContributorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanManagePluginContributors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanManagePluginContributorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanManagePluginContributors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanManagePluginContributors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanManagePluginContributors(ctx, req.(*UserCanManagePluginContributorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuthzService_UserCanManageTemplateContributors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCanManageTemplateContributorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuthzServiceServer).UserCanManageTemplateContributors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.AuthzService/UserCanManageTemplateContributors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuthzServiceServer).UserCanManageTemplateContributors(ctx, req.(*UserCanManageTemplateContributorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AuthzService_ServiceDesc is the grpc.ServiceDesc for AuthzService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AuthzService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "buf.alpha.registry.v1alpha1.AuthzService",
	HandlerType: (*AuthzServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "UserCanCreateOrganizationRepository",
			Handler:    _AuthzService_UserCanCreateOrganizationRepository_Handler,
		},
		{
			MethodName: "UserCanSeeRepositorySettings",
			Handler:    _AuthzService_UserCanSeeRepositorySettings_Handler,
		},
		{
			MethodName: "UserCanSeeOrganizationSettings",
			Handler:    _AuthzService_UserCanSeeOrganizationSettings_Handler,
		},
		{
			MethodName: "UserCanReadPlugin",
			Handler:    _AuthzService_UserCanReadPlugin_Handler,
		},
		{
			MethodName: "UserCanCreatePluginVersion",
			Handler:    _AuthzService_UserCanCreatePluginVersion_Handler,
		},
		{
			MethodName: "UserCanCreateTemplateVersion",
			Handler:    _AuthzService_UserCanCreateTemplateVersion_Handler,
		},
		{
			MethodName: "UserCanCreateOrganizationPlugin",
			Handler:    _AuthzService_UserCanCreateOrganizationPlugin_Handler,
		},
		{
			MethodName: "UserCanCreateOrganizationTemplate",
			Handler:    _AuthzService_UserCanCreateOrganizationTemplate_Handler,
		},
		{
			MethodName: "UserCanSeePluginSettings",
			Handler:    _AuthzService_UserCanSeePluginSettings_Handler,
		},
		{
			MethodName: "UserCanSeeTemplateSettings",
			Handler:    _AuthzService_UserCanSeeTemplateSettings_Handler,
		},
		{
			MethodName: "UserCanAddOrganizationMember",
			Handler:    _AuthzService_UserCanAddOrganizationMember_Handler,
		},
		{
			MethodName: "UserCanUpdateOrganizationMember",
			Handler:    _AuthzService_UserCanUpdateOrganizationMember_Handler,
		},
		{
			MethodName: "UserCanRemoveOrganizationMember",
			Handler:    _AuthzService_UserCanRemoveOrganizationMember_Handler,
		},
		{
			MethodName: "UserCanDeleteOrganization",
			Handler:    _AuthzService_UserCanDeleteOrganization_Handler,
		},
		{
			MethodName: "UserCanDeleteRepository",
			Handler:    _AuthzService_UserCanDeleteRepository_Handler,
		},
		{
			MethodName: "UserCanDeleteTemplate",
			Handler:    _AuthzService_UserCanDeleteTemplate_Handler,
		},
		{
			MethodName: "UserCanDeletePlugin",
			Handler:    _AuthzService_UserCanDeletePlugin_Handler,
		},
		{
			MethodName: "UserCanDeleteUser",
			Handler:    _AuthzService_UserCanDeleteUser_Handler,
		},
		{
			MethodName: "UserCanSeeServerAdminPanel",
			Handler:    _AuthzService_UserCanSeeServerAdminPanel_Handler,
		},
		{
			MethodName: "UserCanManageRepositoryContributors",
			Handler:    _AuthzService_UserCanManageRepositoryContributors_Handler,
		},
		{
			MethodName: "UserCanManagePluginContributors",
			Handler:    _AuthzService_UserCanManagePluginContributors_Handler,
		},
		{
			MethodName: "UserCanManageTemplateContributors",
			Handler:    _AuthzService_UserCanManageTemplateContributors_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "buf/alpha/registry/v1alpha1/authz.proto",
}
