/*  $Id: RobotSprite.h,v 1.10 2012/07/14 04:46:56 sarrazip Exp $
    RobotSprite.h - Sprite that represents a robot.

    afternoonstalker - A robot-killing video game.
    Copyright (C) 2001-2012 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public
    License along with this program; if not, write to the Free
    Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA  02110-1301, USA.
*/

#ifndef _H_RobotSprite
#define _H_RobotSprite

#include <flatzebra/Sprite.h>

using namespace flatzebra;


class RobotSprite : public Sprite
/*  Sprite that represents a robot (duh).
*/
{
public:
    RobotSprite(const PixmapArray &pixmapArray,
                const Couple &pos,
                const Couple &collBoxPos,
                const Couple &collBoxSize,
                const PixmapArray &explosionPA);
    /*  Keeps a pointer to 'explosionPA'.
    */

    virtual ~RobotSprite();

    long timeOfLastShot;
    /*  Time (in ticks) when the last bullet was shot by this robot.
        Initialized by the constructor to -1, which means never.
    */

    bool smart;
    /*  Indicates if the robot is smart or not.
        Initialized by the constructor to false.
    */

    size_t numShotsBeforeDeath;
    /*  Number of shots that this robot must take before dying.
        Initialized by the constructor to 1.
    */

    unsigned long endOfBlinkTime;
    /*  Time in ticks when this robot will stop blinking.
        Initialized by the constructor to 0.
        Any value that is inferior or equal to the game's "tickCount" means
        no blinking.
    */

    bool bigBullets;
    /*        Indicates that this robot fires "big" bullets instead of the
        normal ones.
        Initialized by the constructor to false.
    */


    const PixmapArray *getExplosionPA() const;
    /*  Returns the explosion pixmap array designated to the constructor.
    */

    void startBlinking(PixmapArray &pa, unsigned long endOfBlinkTime);
    /*  Creates a Sprite with the given pixmap array that will represent
        a blinking effect.
        Sets the 'endOfBlinkTime' member to the given value.
    */

    Sprite *getBlinkSprite() const;
    /*  Returns the blink sprite created by startBlinking(),
        or NULL if none is currently present.
    */

    void stopBlinking();
    /*  Destroys the blink sprite if one is present.
        Does nothing otherwise.
    */

private:

    const PixmapArray *theExplosionPA;
    Sprite *blinkSprite;

    /*        Forbidden operations:
    */
    RobotSprite(const RobotSprite &x);
    RobotSprite &operator = (const RobotSprite &x);
};


inline const PixmapArray *
RobotSprite::getExplosionPA() const
{
    return theExplosionPA;
}


#endif  /* _H_RobotSprite */
