typedef enum {
    MAXIMUM,
    HALF,
    QUARTER,
    MINIMUM
} FwksVidWinSize;

struct Camera {
    gboolean open;  /* whether or not a camera is open */
    int device;
    GString *device_name;
    gfloat bytes_per_pixel;  /* float because some YUV formats have
                              * 1.5 bytes per pixel (and thus must
                              * have an even number of pixels) (or
                              * must they?) */
    gboolean bgr;  /* If RGB24 format, whether or not to swap R and B
                    * (BGR24).  Afaik, video4linux cannot provide this
                    * info so it must be a user controlled option */
    struct video_capability vid_caps;
    struct video_window vid_win;
    struct video_picture vid_pic;
/*    struct video_clip vid_clips[32]; */

    guint8 *mmap;  /* pointer to our mmap (if using mmap) */
    struct video_mbuf vmbuf;
    gboolean force_read;  /* force read() instead of mmap() */

    struct RawBuf *buf_a;  /* holds data being read from the camera */
    struct RawBuf *buf_b;  /* holds previous data read from the camera */

    GPtrArray *data_for_avg;  /* holds data to be averaged */
    struct RawBuf *buf_avg;  /* holds averaged data */

    char devname[256];
    GMutex *read_mutex;  /* lock while reading */
    GMutex *buf_b_mutex;  /* lock to touch any of the buffer b */
    GCond *buf_b_cond;  /* threads can wait for buffer b */
    gboolean buf_b_ready;  /* condition for waiting on buffer b */
};

int frameworks_camera_initialize(struct Camera *camera,
                                 GString *device_name,
                                 gboolean force_read);

int frameworks_camera_read(struct Camera *camera);
void frameworks_camera_swap(struct Camera *camera);

void frameworks_camera_read_averaged(struct Camera *camera, gint num, struct Interface *interface);


int frameworks_camera_get_max_width(struct Camera *camera);
int frameworks_camera_get_max_height(struct Camera *camera);
int frameworks_camera_get_min_width(struct Camera *camera);
int frameworks_camera_get_min_height(struct Camera *camera);
int frameworks_camera_get_capture_width(struct Camera *camera);
int frameworks_camera_get_capture_height(struct Camera *camera);

int frameworks_camera_set_brightness(struct Camera *camera, int brightness);
int frameworks_camera_set_whitebalance(struct Camera *camera, int whitebalance);
int frameworks_camera_set_contrast(struct Camera *camera, int contrast);
int frameworks_camera_set_color(struct Camera *camera, int color);
int frameworks_camera_set_hue(struct Camera *camera, int hue);

void frameworks_camera_set_size(struct Camera *camera, FwksVidWinSize size);

void frameworks_camera_change_device(struct Camera *camera, GString *device_name);
