/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.generation.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.local.generation.generation.SearchState;
import org.jetbrains.completion.full.line.local.generation.search.BeamSearchNode;
import org.jetbrains.completion.full.line.tokenizer.Tokenizer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/completion/full/line/local/generation/search/BeamSearchGraph;", "", "tokenizer", "Lorg/jetbrains/completion/full/line/tokenizer/Tokenizer;", "<init>", "(Lorg/jetbrains/completion/full/line/tokenizer/Tokenizer;)V", "nodes", "", "Lorg/jetbrains/completion/full/line/local/generation/search/BeamSearchNode;", "getNodes", "()Ljava/util/List;", "lastUpdateNodes", "currentId", "", "lastNodes", "", "getLastNodes", "update", "", "searchState", "Lorg/jetbrains/completion/full/line/local/generation/generation/SearchState;", "terminateHypotheses", "step", "indices", "", "intellij.fullLine.local"})
@SourceDebugExtension(value={"SMAP\nBeamSearchInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BeamSearchInfo.kt\norg/jetbrains/completion/full/line/local/generation/search/BeamSearchGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n626#2,12:105\n774#2:117\n865#2,2:118\n*S KotlinDebug\n*F\n+ 1 BeamSearchInfo.kt\norg/jetbrains/completion/full/line/local/generation/search/BeamSearchGraph\n*L\n37#1:105,12\n63#1:117\n63#1:118,2\n*E\n"})
public final class BeamSearchGraph {
    @NotNull
    private final Tokenizer tokenizer;
    @NotNull
    private final List<BeamSearchNode> nodes;
    @NotNull
    private final List<BeamSearchNode> lastUpdateNodes;
    private int currentId;

    public BeamSearchGraph(@NotNull Tokenizer tokenizer) {
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        this.tokenizer = tokenizer;
        this.nodes = new ArrayList();
        this.lastUpdateNodes = new ArrayList();
    }

    @NotNull
    public final List<BeamSearchNode> getNodes() {
        return this.nodes;
    }

    @NotNull
    public final List<BeamSearchNode> getLastNodes() {
        return this.lastUpdateNodes;
    }

    public final void update(@NotNull SearchState searchState) {
        Intrinsics.checkNotNullParameter((Object)searchState, (String)"searchState");
        int step = searchState.getLength() - 1;
        this.lastUpdateNodes.clear();
        Iterator iterator2 = ((Iterable)ArraysKt.zip((int[])searchState.getSortMask(), (int[])searchState.getLastPredictions())).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int indent;
            int reorderedId = n++;
            Pair lastHyp = (Pair)iterator2.next();
            int originalId = ((Number)lastHyp.getFirst()).intValue();
            int tokenId = ((Number)lastHyp.getSecond()).intValue();
            String text = this.tokenizer.decode(tokenId);
            BeamSearchNode parent = null;
            int n2 = tokenId;
            int n3 = n2 == this.tokenizer.getScopeInId() ? 1 : (indent = n2 == this.tokenizer.getScopeOutId() ? -1 : 0);
            if (step != 0) {
                Iterable $this$single$iv = this.nodes;
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$single$iv) {
                    BeamSearchNode it = (BeamSearchNode)element$iv;
                    boolean bl = false;
                    if (!(it.getStep() == step - 1 && it.getHypId() == originalId)) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                parent = single$iv;
                indent += parent.getIndent();
            }
            int n4 = this.currentId;
            this.currentId = n4 + 1;
            BeamSearchNode node = new BeamSearchNode(n4, reorderedId, tokenId, text, text, step, Math.exp(((Number)searchState.getHypothesesScores().get(reorderedId)).doubleValue()), Math.exp(((Number)CollectionsKt.last(searchState.getHypothesesProbabilities().get(reorderedId))).doubleValue()), parent, indent, false, 1024, null);
            if (parent != null) {
                parent.addChild(node);
                node.setFullText(parent.getFullText() + text);
            }
            this.lastUpdateNodes.add(node);
        }
        this.nodes.addAll((Collection<BeamSearchNode>)this.lastUpdateNodes);
    }

    /*
     * WARNING - void declaration
     */
    public final void terminateHypotheses(int step, @NotNull Collection<Integer> indices) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        Iterable $this$filter$iv = this.nodes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BeamSearchNode it = (BeamSearchNode)element$iv$iv;
            boolean bl = false;
            if (!(it.getStep() == step)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List lastStepHypotheses = (List)destination$iv$iv;
        int currentId = 0;
        Iterator iterator2 = ((Iterable)lastStepHypotheses).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            BeamSearchNode hyp = (BeamSearchNode)iterator2.next();
            if (indices.contains(hyp.getHypId())) {
                hyp.setHypId(lastStepHypotheses.size() - indices.size() + currentId++);
                hyp.setTerminated(true);
                continue;
            }
            hyp.setHypId(i - currentId);
        }
    }
}

