/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events;

import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.events.EventField;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\r\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/BaseEventId;", "", "eventId", "", "recorder", "description", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;)V", "getEventId", "()Ljava/lang/String;", "getRecorder", "getDescription", "getLogger", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogger;", "getLogger$intellij_platform_statistics", "getFields", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "intellij.platform.statistics"})
public abstract class BaseEventId {
    @NotNull
    private final String eventId;
    @NotNull
    private final String recorder;
    @Nullable
    private final String description;

    public BaseEventId(@NotNull String eventId, @NotNull String recorder, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)recorder, (String)"recorder");
        this.eventId = eventId;
        this.recorder = recorder;
        this.description = description;
    }

    @NotNull
    public final String getEventId() {
        return this.eventId;
    }

    @NotNull
    public final String getRecorder() {
        return this.recorder;
    }

    @Nullable
    public final String getDescription() {
        return this.description;
    }

    @Deprecated(message="Recorder ID should be explicitly provided", replaceWith=@ReplaceWith(expression="BaseEventId(eventId, recorder)", imports={}))
    @ApiStatus.ScheduledForRemoval
    public BaseEventId(@NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        this(eventId, "FUS", null);
    }

    @NotNull
    public final StatisticsEventLogger getLogger$intellij_platform_statistics() {
        return StatisticsEventLogProviderUtil.getEventLogProvider(this.recorder).getLogger();
    }

    @NotNull
    public abstract List<EventField<?>> getFields();
}

