/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.NodePackageVersion;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.packaging.PackageVersionComparator;
import com.intellij.webcore.util.JsonUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodePackageVersionUtil {
    private static final Logger LOG = Logger.getInstance(NodePackageVersionUtil.class);
    private static final Map<String, TimestampedVersion> PACKAGE_VERSION_CACHE = Collections.synchronizedMap(new FixedHashMap(10));

    @Nullable
    public static NodePackageVersion getPackageVersion(@NotNull String packageDirPath) {
        Path packageJson;
        if (packageDirPath == null) {
            NodePackageVersionUtil.$$$reportNull$$$0(0);
        }
        try {
            packageJson = Path.of(packageDirPath, "package.json");
        }
        catch (InvalidPathException e) {
            LOG.warn("Invalid path " + packageDirPath, (Throwable)e);
            return null;
        }
        return NodePackageVersionUtil.getPackageVersionByPackageJson(packageJson);
    }

    @Nullable
    public static SemVer getPackageVersion(@NotNull Path packageDir) {
        NodePackageVersion packageVersion;
        if (packageDir == null) {
            NodePackageVersionUtil.$$$reportNull$$$0(1);
        }
        return (packageVersion = NodePackageVersionUtil.getPackageVersionByPackageJson(packageDir.resolve("package.json"))) != null ? packageVersion.getSemVer() : null;
    }

    @Nullable
    private static NodePackageVersion getPackageVersionByPackageJson(@NotNull Path packageJson) {
        if (packageJson == null) {
            NodePackageVersionUtil.$$$reportNull$$$0(2);
        }
        if (!Files.isRegularFile(packageJson, new LinkOption[0])) {
            return null;
        }
        String path2 = packageJson.toAbsolutePath().toString();
        TimestampedVersion r = PACKAGE_VERSION_CACHE.get(path2);
        Timestamp upToDateTimestamp = Timestamp.create(packageJson);
        if (r == null || !r.myTimestamp.equals(upToDateTimestamp)) {
            NodePackageVersion packageVersion = NodePackageVersionUtil.calc(packageJson);
            r = new TimestampedVersion(upToDateTimestamp, packageVersion);
            PACKAGE_VERSION_CACHE.put(path2, r);
        }
        return r.getPackageVersion();
    }

    @Nullable
    private static NodePackageVersion calc(@NotNull Path packageJson) {
        NodePackageVersion nodePackageVersion;
        block9: {
            if (packageJson == null) {
                NodePackageVersionUtil.$$$reportNull$$$0(3);
            }
            BufferedReader reader = Files.newBufferedReader(packageJson, StandardCharsets.UTF_8);
            try {
                JsonReader jsonReader = new JsonReader((Reader)reader);
                nodePackageVersion = NodePackageVersionUtil.parseNodePackageVersion(jsonReader);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("Failed to parse " + packageJson, (Throwable)e);
                    return null;
                }
            }
            reader.close();
        }
        return nodePackageVersion;
    }

    @Nullable
    private static NodePackageVersion parseNodePackageVersion(@NotNull JsonReader reader) throws IOException {
        JsonToken token;
        if (reader == null) {
            NodePackageVersionUtil.$$$reportNull$$$0(4);
        }
        if ((token = reader.peek()) != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return null;
        }
        reader.beginObject();
        String name = null;
        SemVer semVer = null;
        while (reader.hasNext()) {
            String key = reader.nextName();
            if ("version".equals(key)) {
                String value = JsonUtil.nextStringOrSkip((JsonReader)reader);
                if (value == null) continue;
                semVer = SemVer.parseFromText((String)value);
                continue;
            }
            if ("name".equals(key)) {
                name = JsonUtil.nextStringOrSkip((JsonReader)reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return new NodePackageVersion(name, semVer);
    }

    public static int comparePackageVersions(@NotNull String version1, @NotNull String version2) {
        if (version1 == null) {
            NodePackageVersionUtil.$$$reportNull$$$0(5);
        }
        if (version2 == null) {
            NodePackageVersionUtil.$$$reportNull$$$0(6);
        }
        if ((version1 = version1.trim()).equals(version2 = version2.trim())) {
            return 0;
        }
        SemVer ver1 = SemVer.parseFromText((String)version1);
        SemVer ver2 = SemVer.parseFromText((String)version2);
        if (ver1 == null) {
            return ver2 == null ? 0 : -1;
        }
        if (ver2 == null) {
            return 1;
        }
        int result2 = ver1.compareTo(ver2);
        if (result2 == 0) {
            if (version1.equals(ver1.getParsedVersion())) {
                return 1;
            }
            if (version2.equals(ver2.getParsedVersion())) {
                return -1;
            }
            result2 = PackageVersionComparator.VERSION_COMPARATOR.compare(version1, version2);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDirPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDir";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/NodePackageVersionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageVersionByPackageJson";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calc";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "parseNodePackageVersion";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "comparePackageVersions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class TimestampedVersion {
        private final Timestamp myTimestamp;
        private final NodePackageVersion myPackageVersion;

        private TimestampedVersion(@NotNull Timestamp timestamp, @Nullable NodePackageVersion packageVersion) {
            if (timestamp == null) {
                TimestampedVersion.$$$reportNull$$$0(0);
            }
            this.myTimestamp = timestamp;
            this.myPackageVersion = packageVersion;
        }

        @Nullable
        public NodePackageVersion getPackageVersion() {
            return this.myPackageVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timestamp", "com/intellij/javascript/nodejs/NodePackageVersionUtil$TimestampedVersion", "<init>"));
        }
    }

    private static final class Timestamp {
        private final FileTime myFileLastModified;
        private final long myVfsModificationStamp;

        private Timestamp(@Nullable FileTime fileLastModified, long vfsModificationStamp) {
            this.myFileLastModified = fileLastModified;
            this.myVfsModificationStamp = vfsModificationStamp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Timestamp timestamp = (Timestamp)o;
            return this.myVfsModificationStamp == timestamp.myVfsModificationStamp && Objects.equals(this.myFileLastModified, timestamp.myFileLastModified);
        }

        private static long getVfsModificationStamp(@NotNull Path packageJson) {
            if (packageJson == null) {
                Timestamp.$$$reportNull$$$0(0);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return -1L;
            }
            VirtualFile vfsPackageJson = LocalFileSystem.getInstance().findFileByNioFile(packageJson);
            return vfsPackageJson != null ? vfsPackageJson.getModificationStamp() : -1L;
        }

        @NotNull
        public static Timestamp create(@NotNull Path packageJson) {
            FileTime lastModified;
            if (packageJson == null) {
                Timestamp.$$$reportNull$$$0(1);
            }
            try {
                lastModified = Files.getLastModifiedTime(packageJson, new LinkOption[0]);
            }
            catch (IOException e) {
                lastModified = null;
            }
            long vfsModificationStamp = Timestamp.getVfsModificationStamp(packageJson);
            return new Timestamp(lastModified, vfsModificationStamp);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "packageJson";
            objectArray2[1] = "com/intellij/javascript/nodejs/NodePackageVersionUtil$Timestamp";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getVfsModificationStamp";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

