/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.documentation.mdn.MdnApiNamespace;
import com.intellij.documentation.mdn.MdnDocumentationKt;
import com.intellij.documentation.mdn.MdnSymbolDocumentation;
import com.intellij.ide.BrowserUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.DojoCommentBuilder;
import com.intellij.lang.javascript.documentation.JSExternalLibraryDocBundle;
import com.intellij.lang.javascript.documentation.PlainCommentBuilder;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDocOwner;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSBinaryExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocBlockTags;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocCommentVisitor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocCustomTagsHandler;
import com.intellij.lang.javascript.psi.jsdoc.JSDocDescriptionProcessor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocInlineTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocInlineTags;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagPart;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCustomTags;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSDestructuringContext;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSDocumentationUtils {
    public static final JSDocDescriptionProcessor DEFAULT_DESCRIPTION_PROCESSOR = new JSDocDescriptionProcessor(){

        @Override
        @NotNull
        public String transformInlineTag(@NotNull JSDocInlineTag tag) {
            if (tag == null) {
                1.$$$reportNull$$$0(0);
            }
            String string = JSDocumentationUtils.transformInlineTag(tag);
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/documentation/JSDocumentationUtils$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocumentationUtils$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "transformInlineTag";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "transformInlineTag";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };
    private static final String NO_NAME_CHARS = ".~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}";
    private static final String IDENTIFIER_NAME = "[\\p{L}_$][\\p{LD}_$]*";
    public static final String NAME = "[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+";
    private static final String NAME_IN_TYPE = "[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}/]+";
    private static final String DOUBLE_QUOTED_NAME = "\"(?:[^\"\\\\]|\\\\.)+\"";
    private static final String SINGLE_QUOTED_NAME = "'(?:[^'\\\\]|\\\\.)+'";
    private static final String IMPORT_TYPE_NAME = "import\\s*\\(\\s*(?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\s*\\)";
    private static final String SPECIAL_NAME_PREFIX = "(?:module:|event:|external:)";
    private static final String NAME_OR_QUOTED = "(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')";
    private static final String NAMEPATH_START = "import\\s*\\(\\s*(?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\s*\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+";
    private static final String NAMEPATH_IN_TYPE_START = "(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}/]+";
    private static final String NAMEPATH_PART = "(?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')";
    public static final String NAMEPATH_SEPARATORS = ".#~";
    public static final String NAMEPATH = "(?:[.#~])?(?:import\\s*\\(\\s*(?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\s*\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?";
    private static final String NAMEPATH_IN_TYPE = "(?:[.#~])?(?:(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}/]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?";
    private static final Pattern NAMEPATH_START_PATTERN = Pattern.compile("import\\s*\\(\\s*(?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\s*\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+");
    private static final Pattern NAMEPATH_PART_PATTERN = Pattern.compile("(?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')");
    public static final Pattern NAMEPATH_PATTERN = Pattern.compile("(?:[.#~])?(?:import\\s*\\(\\s*(?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\s*\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?");
    public static final Pattern NAMEPATH_IN_TYPE_PATTERN = Pattern.compile("(?:[.#~])?(?:(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}/]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?");
    private static final String PARAM_FIELD = "((?:(?:\\[\\])*\\.[\\p{L}_$][\\p{LD}_$]*)+)?";
    private static final Pattern ourJSDocParametersRestPattern = Pattern.compile("^\\s*(?:(\\[?\\(?\\{?`?([\\p{L}_$][\\p{LD}_$]*(?:\\|[\\p{L}_$][\\p{LD}_$]*)*)((?:(?:\\[\\])*\\.[\\p{L}_$][\\p{LD}_$]*)+)?(\\.\\.\\.)?`?(?:\\s*=\\s*((?:\\[[^\\]]*\\])|[^\\]\\s]*|(?:'[^']*')|(?:\"[^\"]*\")))?\\)?\\]?)(?:\\s:\\s(\\S+))?)?(?:\\s*-\\s*)?(.*)$");
    private static final Pattern ourJSDocExtendedTypeNamePattern = Pattern.compile("^[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+$");
    private static final String EOL_MULTILINE_END_ESCAPE = "&#42;&#47;";
    static final String HYPERLINK_SEPARATOR = "%";
    static final String INDEX_POSITION_SEPARATOR = ":";
    private static final Key<JSStubElementImpl.StubBuildCachedValue<PsiComment>> DOC_COMMENT_KEY = new Key("js.stub.building.doc.comment");
    private static final TokenSet DOC_COMMENT_ALLOWED_AFTER = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.COMMENTS_AND_WHITESPACES, JSStubElementTypes.ATTRIBUTE_LISTS});
    public static final TokenSet ourPrimitiveTypeFilter = JSKeywordSets.PRIMITIVE_TYPES;

    public static void processDocumentationTextFromComment(@NotNull PsiElement context2, @NotNull ASTNode _initialComment, @NotNull JSDocCommentVisitor processor) {
        ASTNode initialComment;
        IElementType type;
        ASTNode prev;
        if (context2 == null) {
            JSDocumentationUtils.$$$reportNull$$$0(0);
        }
        if (_initialComment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            JSDocumentationUtils.$$$reportNull$$$0(2);
        }
        if ((prev = _initialComment.getTreePrev()) != null && prev.getPsi() instanceof OuterLanguageElement) {
            while (prev != null && prev.getPsi() instanceof OuterLanguageElement) {
                prev = prev.getTreePrev();
            }
        } else {
            prev = null;
        }
        if (prev != null && !(prev.getPsi() instanceof PsiComment)) {
            prev = null;
        }
        if ((type = (initialComment = prev != null ? prev : _initialComment).getElementType()) == JSTokenTypes.DOC_COMMENT) {
            ((JSDocComment)initialComment.getPsi()).acceptChildren(processor);
        } else {
            String commentText = type == JSTokenTypes.END_OF_LINE_COMMENT ? JSDocumentationUtils.buildDocCommentFromEolComment(initialComment).replace("*/", EOL_MULTILINE_END_ESCAPE) : JSDocumentationUtils.unwrapCommentDelimiters(initialComment.getText());
            JSPsiElementFactory.createJSDocComment("/** " + commentText + " */", context2).acceptChildren(processor);
        }
    }

    @NotNull
    public static String buildDescription(@NotNull PsiElement element, @NotNull JSDocDescriptionProcessor processor) {
        PsiElement cur;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            JSDocumentationUtils.$$$reportNull$$$0(4);
        }
        for (cur = element.getFirstChild(); cur != null && (cur.getNode().getElementType() == JSDocTokenTypes.DOC_WHITESPACE || cur.getNode().getElementType() == JSDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK); cur = cur.getNextSibling()) {
        }
        if (cur == null) {
            return "";
        }
        PsiFile file = element.getContainingFile();
        if (file.getName().startsWith("dummy.") && file.getFirstChild() == file.getLastChild() && file.getFirstChild() instanceof JSDocComment && element.getText().contains(EOL_MULTILINE_END_ESCAPE)) {
            processor = new JSDocReplacingDescriptionProcessor(processor, EOL_MULTILINE_END_ESCAPE, "*/");
        }
        StringBuilder result2 = new StringBuilder();
        StringBuilder textBuilder = new StringBuilder();
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)cur);
        if (prevLeaf != null && prevLeaf.getNode().getElementType() == JSDocTokenTypes.DOC_WHITESPACE) {
            String text = JSDocumentationUtils.getWhitespaceTextAsterisksAware(prevLeaf.getNode());
            int lastNewLine = text.lastIndexOf(10);
            textBuilder.append(lastNewLine < 0 ? text : text.substring(lastNewLine + 1));
        }
        while (cur != null) {
            IElementType type = cur.getNode().getElementType();
            if ((type == JSDocTokenTypes.DOC_PRE || cur instanceof JSDocInlineTag) && !textBuilder.isEmpty()) {
                result2.append(processor.transformText(textBuilder.toString()));
                textBuilder.setLength(0);
            }
            if (type == JSDocTokenTypes.DOC_WHITESPACE) {
                textBuilder.append(JSDocumentationUtils.getWhitespaceTextAsterisksAware(cur.getNode()));
            } else if (type == JSDocTokenTypes.DOC_PRE) {
                String pre = cur.getText();
                StringBuilder preContents = new StringBuilder();
                for (cur = cur.getNextSibling(); cur != null && cur.getNode().getElementType() != JSDocTokenTypes.DOC_PRE; cur = cur.getNextSibling()) {
                    type = cur.getNode().getElementType();
                    if (type == JSDocTokenTypes.DOC_WHITESPACE) {
                        preContents.append(JSDocumentationUtils.getWhitespaceTextAsterisksAware(cur.getNode()));
                        continue;
                    }
                    if (type != JSDocTokenTypes.DOC_COMMENT_DATA) continue;
                    preContents.append(cur.getText());
                }
                String indentation = JSDocumentationUtils.getIndentation(preContents);
                result2.append(processor.transformPreContent(pre, preContents.toString(), indentation));
            } else if (cur instanceof JSDocInlineTag) {
                JSDocInlineTag tag = (JSDocInlineTag)cur;
                result2.append(processor.transformInlineTag(tag));
            } else if (type != JSDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK) {
                textBuilder.append(cur.getText());
            }
            cur = cur != null ? cur.getNextSibling() : null;
        }
        if (!textBuilder.isEmpty()) {
            result2.append(processor.transformText(textBuilder.toString()));
        }
        String string = processor.postProcessDescription(result2.toString());
        if (string == null) {
            JSDocumentationUtils.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String transformInlineTag(@NotNull JSDocInlineTag tag) {
        if (tag == null) {
            JSDocumentationUtils.$$$reportNull$$$0(6);
        }
        if (tag.is(JSDocInlineTags.LINK)) {
            int separatorIndex;
            StringBuilder result2 = new StringBuilder();
            String linkText = tag.getParameterText();
            String linkUrl = (String)ObjectUtils.doIfNotNull((Object)tag.getNamepath(), JSDocTagPart::getTextWithoutLeadingAsterisks);
            if (linkUrl == null) {
                linkUrl = (String)ObjectUtils.doIfNotNull((Object)tag.getValue(), JSDocTagPart::getTextWithoutLeadingAsterisks);
            }
            if (linkUrl == null) {
                return "";
            }
            if (linkText == null && (separatorIndex = StringUtil.indexOfAny((String)linkUrl, (String)" |")) >= 0) {
                linkText = linkUrl.substring(separatorIndex + 1).trim();
                linkUrl = linkUrl.substring(0, separatorIndex);
            }
            if (linkText == null || linkText.isBlank()) {
                linkText = linkUrl;
            }
            if (BrowserUtil.isAbsoluteURL((String)linkUrl)) {
                result2.append("<a href=\"").append(linkUrl).append("\">").append(linkText).append("</a>");
            } else {
                JSDocumentationUtils.appendHyperLinkToElement(null, linkUrl, result2, linkText, true, true, 0);
            }
            String string = result2.toString();
            if (string == null) {
                JSDocumentationUtils.$$$reportNull$$$0(7);
            }
            return string;
        }
        JSDocCustomTagsHandler handler = JSDocCustomTags.INSTANCE.getHandler(tag.getTagDefinition());
        if (handler != null) {
            String string = handler.transformInlineTag(tag);
            if (string == null) {
                JSDocumentationUtils.$$$reportNull$$$0(8);
            }
            return string;
        }
        return "";
    }

    public static String getWhitespaceTextAsterisksAware(ASTNode cur) {
        int lastNewLine;
        assert (cur.getElementType() == JSDocTokenTypes.DOC_WHITESPACE);
        String text = cur.getText();
        ASTNode prevSibling = cur.getTreePrev();
        ASTNode nextSibling = cur.getTreeNext();
        if (prevSibling != null && prevSibling.getElementType() == JSDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK) {
            text = StringUtil.trimStart((String)text, (String)" ");
        }
        if (nextSibling != null && nextSibling.getElementType() == JSDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK && (lastNewLine = text.lastIndexOf(10)) >= 0) {
            text = text.substring(0, lastNewLine + 1);
        }
        return text;
    }

    @Nullable
    public static JSDocTag getNextJSDocTag(@NotNull PsiElement element) {
        PsiElement nextTag;
        JSDocTag tag;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(9);
        }
        JSDocTag jSDocTag = tag = element instanceof JSDocTag ? (JSDocTag)element : (JSDocTag)ObjectUtils.tryCast((Object)element.getParent(), JSDocTag.class);
        if (tag == null) {
            return null;
        }
        for (nextTag = tag.getNextSibling(); nextTag != null && !(nextTag instanceof JSDocTag); nextTag = nextTag.getNextSibling()) {
        }
        return (JSDocTag)nextTag;
    }

    @Nullable
    public static JSDocTag getPreviousJSDocTag(@NotNull PsiElement element) {
        PsiElement prevTag;
        JSDocTag tag;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(10);
        }
        JSDocTag jSDocTag = tag = element instanceof JSDocTag ? (JSDocTag)element : (JSDocTag)ObjectUtils.tryCast((Object)element.getParent(), JSDocTag.class);
        if (tag == null) {
            return null;
        }
        for (prevTag = tag.getPrevSibling(); prevTag != null && !(prevTag instanceof JSDocTag); prevTag = prevTag.getPrevSibling()) {
        }
        return (JSDocTag)prevTag;
    }

    @Nullable
    public static JSDocTag getPreviousParamTagForConfigTag(@Nullable JSDocTag tag) {
        if (tag == null || !JSDocBlockTags.CONFIG.isSameName(tag.getName())) {
            return null;
        }
        while (tag != null && JSDocBlockTags.CONFIG.isSameName(tag.getName())) {
            tag = JSDocumentationUtils.getPreviousJSDocTag((PsiElement)tag);
        }
        return tag != null && tag.is(JSDocBlockTags.PARAM) ? tag : null;
    }

    public static String unwrapCommentDelimiters(String text) {
        String marker;
        block7: {
            block8: {
                block6: {
                    marker = "/**";
                    if (!text.startsWith("/**")) break block6;
                    text = text.substring(marker.length());
                    break block7;
                }
                marker = "/*";
                if (text.startsWith("/*")) break block8;
                marker = "//";
                if (!text.startsWith("//")) break block7;
            }
            text = text.substring(marker.length());
        }
        marker = "*/";
        if (text.endsWith("*/")) {
            text = text.substring(0, text.length() - marker.length());
        }
        marker = "-->";
        if (text.endsWith("-->")) {
            text = text.substring(0, text.length() - marker.length());
        }
        marker = "<!---";
        if (text.startsWith("<!---")) {
            text = text.substring(marker.length());
        }
        return text;
    }

    private static String buildDocCommentFromEolComment(@NotNull ASTNode eolComment) {
        if (eolComment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(11);
        }
        assert (eolComment.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT);
        Object result2 = null;
        while (eolComment != null && (eolComment.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT || eolComment.getElementType() == JSTokenTypes.WHITE_SPACE)) {
            if (eolComment.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT) {
                Object line = new CharSequenceSubSequence((CharSequence)eolComment.getText());
                if (StringUtil.startsWith((CharSequence)line, (CharSequence)"//")) {
                    line = line.subSequence(2, line.length());
                }
                if (StringUtil.startsWith((CharSequence)line, (CharSequence)" ")) {
                    line = line.subSequence(1, line.length());
                }
                if (result2 == null) {
                    result2 = DojoCommentBuilder.isDojoCommentFirstLine((CharSequence)line) ? new DojoCommentBuilder() : new PlainCommentBuilder();
                }
                try {
                    result2.append((CharSequence)line);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            eolComment = eolComment.getTreeNext();
        }
        return result2 == null ? "" : result2.toString();
    }

    @Nullable
    private static ASTNode findTrailingCommentInFunctionBody(@NotNull JSFunction function) {
        ASTNode block;
        if (function == null) {
            JSDocumentationUtils.$$$reportNull$$$0(12);
        }
        if ((block = function.getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS)) == null) {
            return null;
        }
        for (ASTNode prev = block.getLastChildNode(); prev != null; prev = prev.getTreePrev()) {
            if (prev.getElementType() == JSStubElementTypes.RETURN_STATEMENT) {
                PsiElement prevLeaf;
                ASTNode comment = block.findChildByType(JSTokenTypes.COMMENTS, prev);
                if (comment != null && (prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)comment.getPsi())) instanceof PsiWhiteSpace && prevLeaf.textContains('\n')) {
                    comment = null;
                }
                return comment;
            }
            if (JSExtendedLanguagesTokenSetProvider.STATEMENTS.contains(prev.getElementType())) break;
        }
        return null;
    }

    @Nullable
    static ASTNode findLeadingCommentInFunctionBody(@NotNull PsiElement element) {
        ASTNode node;
        ASTNode functionNode;
        ASTNode block;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(13);
        }
        ASTNode aSTNode = block = (functionNode = element.getNode()) != null ? functionNode.findChildByType(JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS) : null;
        if (block == null) {
            return null;
        }
        ASTNode firstChildNode = block.getFirstChildNode();
        ASTNode aSTNode2 = node = firstChildNode != null ? firstChildNode.getTreeNext() : null;
        while (node != null) {
            IElementType nodeType = node.getElementType();
            if (nodeType != TokenType.WHITE_SPACE) {
                if (JSTokenTypes.COMMENTS.contains(nodeType)) {
                    return node;
                }
                return null;
            }
            node = node.getTreeNext();
        }
        return null;
    }

    @Nullable
    public static JSType findTypeFromInlineComment(@NotNull PsiElement element) {
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(14);
        }
        PsiElement prevSibling = element.getPrevSibling();
        while (prevSibling instanceof PsiWhiteSpace) {
            prevSibling = prevSibling.getPrevSibling();
        }
        if (prevSibling instanceof JSDocComment) {
            String type = ((JSDocComment)prevSibling).getType();
            return JSTypeParser.createTypeFromJSDoc(element.getProject(), type, JSTypeSourceFactory.createTypeSource(prevSibling, true));
        }
        return null;
    }

    @Nullable
    public static JSDocComment findOwnDocComment(@NotNull PsiElement element) {
        PsiElement anchor;
        PsiElement prevSibling;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(15);
        }
        if (element instanceof JSExpression && (prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)(anchor = element instanceof JSDefinitionExpression ? element.getParent() : element))) instanceof JSDocComment) {
            return (JSDocComment)prevSibling;
        }
        if (element instanceof JSQualifiedNamedElement || element instanceof JSExportAssignment) {
            PsiElement parent;
            JSDocComment comment = JSDocumentationUtils.getStartingChildDocComment(element.getNode());
            if (comment != null) {
                return comment;
            }
            if (element instanceof JSVariable && (parent = element.getParent()) instanceof JSVarStatement && (comment = JSDocumentationUtils.getStartingChildDocComment(parent.getNode())) != null && JSDocumentationUtils.hasSingleVariable((JSVarStatement)parent)) {
                return comment;
            }
        }
        if (element instanceof JSExpression && element.getParent() instanceof JSExportAssignment) {
            return JSDocumentationUtils.findOwnDocComment(element.getParent());
        }
        return null;
    }

    private static boolean hasSingleVariable(@NotNull JSVarStatement statement) {
        JSInitializerOwner[] declarations;
        if (statement == null) {
            JSDocumentationUtils.$$$reportNull$$$0(16);
        }
        return (declarations = statement.getDeclarations()).length == 1 && declarations[0] instanceof JSVariable;
    }

    @Nullable
    public static PsiComment findScopeComment(@NotNull JSElement element) {
        PsiElement scope2;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(17);
        }
        if ((scope2 = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSFunction.class, JSClass.class})) != null) {
            JSClass clazz;
            PsiComment scopeComment = JSDocumentationUtils.findDocComment(scope2);
            if (scopeComment != null) {
                return scopeComment;
            }
            if (scope2 instanceof JSFunction && (clazz = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)scope2, JSClass.class)) != null) {
                return JSDocumentationUtils.findDocComment(clazz);
            }
        }
        return null;
    }

    public static PsiComment findDocComment(@NotNull PsiElement element) {
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(18);
        }
        return JSDocumentationUtils.findDocComment(element, null, null);
    }

    @NotNull
    private static PsiElement findAttributeListAnchor(@NotNull PsiElement element, @Nullable PsiElement context2) {
        JSAttributeListOwner jsClass;
        block12: {
            block11: {
                if (element == null) {
                    JSDocumentationUtils.$$$reportNull$$$0(19);
                }
                if (!(element instanceof JSAttributeListOwner)) break block11;
                jsClass = (JSAttributeListOwner)element;
                if (context2 == null) break block12;
            }
            PsiElement psiElement = element;
            if (psiElement == null) {
                JSDocumentationUtils.$$$reportNull$$$0(20);
            }
            return psiElement;
        }
        JSAttributeList attributeList = jsClass.getAttributeList();
        PsiElement anchor = null;
        if (attributeList == null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                JSDocumentationUtils.$$$reportNull$$$0(21);
            }
            return psiElement;
        }
        for (ASTNode currentNode = attributeList.getNode().getLastChildNode(); currentNode != null; currentNode = currentNode.getTreePrev()) {
            IElementType nodeType = currentNode.getElementType();
            if (JSTokenTypes.MODIFIERS.contains(nodeType) || nodeType == JSStubElementTypes.ES6_DECORATOR || nodeType == JSTokenTypes.WHITE_SPACE || nodeType == JSElementTypes.REFERENCE_EXPRESSION || nodeType == JSStubElementTypes.ATTRIBUTE) continue;
            ASTNode nextNode = currentNode.getTreeNext();
            if (nextNode == null) break;
            anchor = nextNode.getPsi();
            break;
        }
        if (anchor != null) {
            PsiElement psiElement = anchor;
            if (psiElement == null) {
                JSDocumentationUtils.$$$reportNull$$$0(22);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            JSDocumentationUtils.$$$reportNull$$$0(23);
        }
        return psiElement;
    }

    public static PsiComment findDocComment(@NotNull PsiElement element, @Nullable PsiElement context2, @Nullable Ref<? super PsiElement> elementToAttach) {
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(24);
        }
        ProgressManager.checkCanceled();
        if (element instanceof JSDocComment) {
            JSDocComment docComment = (JSDocComment)element;
            return docComment;
        }
        if (element instanceof TypeScriptProxyImplicitElement) {
            TypeScriptProxyImplicitElement proxyImplicitElement = (TypeScriptProxyImplicitElement)element;
            element = proxyImplicitElement.getExplicitElement();
        }
        if ((element = JSDocumentationUtils.findAttributeListAnchor(element, context2)) instanceof PsiFileSystemItem) {
            return null;
        }
        if (element instanceof ImplicitJSVariableImpl) {
            return null;
        }
        if (elementToAttach == null) {
            return JSStubElementImpl.getCachedValueIfBuildingStubs(element, DOC_COMMENT_KEY, element, el -> JSDocumentationUtils.findDocCommentNoCache(el, null));
        }
        return JSDocumentationUtils.findDocCommentNoCache(element, elementToAttach);
    }

    public static PsiComment findDocCommentNoCache(@NotNull PsiElement element, @Nullable Ref<? super PsiElement> elementToAttach) {
        JSDocComment _docComment;
        PsiElement parentToSearchDocComment;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(25);
        }
        PsiComment docComment = null;
        if (element instanceof JSParameter) {
            JSFunction function;
            PsiElement prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
            if (prevSibling instanceof PsiComment) {
                docComment = (PsiComment)prevSibling;
            }
            if ((function = ((JSParameter)element).getDeclaringFunction()) != null) {
                element = function;
            }
        }
        if (element instanceof JSFunctionExpression || element instanceof JSDefinitionExpression) {
            element = JSDocumentationUtils.getElementOverAssignmentParent(element);
        }
        if (element instanceof JSFieldVariable) {
            JSDocComment _docComment2 = JSDocumentationUtils.getStartingChildDocComment(element.getNode());
            if (_docComment2 != null) {
                docComment = _docComment2;
            } else {
                PsiElement parent = element.getParent();
                if (!(parent instanceof TypeScriptObjectType)) {
                    element = parent;
                }
            }
        }
        if ((parentToSearchDocComment = JSDocumentationUtils.getParentToSearchDocComment(element)) != null && (_docComment = JSDocumentationUtils.getStartingChildDocComment(parentToSearchDocComment.getNode())) != null) {
            docComment = _docComment;
        }
        if (docComment == null) {
            docComment = JSDocumentationUtils.searchPreviousNonDocComment(element);
        }
        if (docComment != null) {
            docComment = JSDocumentationUtils.skipOuterElements(docComment);
        }
        if (docComment != null && JSDocumentationUtils.isSelfSufficientComment(docComment)) {
            return null;
        }
        if (elementToAttach != null) {
            elementToAttach.set((Object)JSDocumentationUtils.getAssociatedElement(element, parentToSearchDocComment));
        }
        return docComment;
    }

    private static boolean isSelfSufficientComment(@NotNull PsiComment comment) {
        if (comment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(26);
        }
        if (!(comment instanceof JSDocComment)) {
            return false;
        }
        List<Pair<String, String>> typedefs = ((JSDocComment)comment).getTypedefs();
        return !typedefs.isEmpty() && !ContainerUtil.exists(typedefs, pair -> StringUtil.isEmpty((String)((String)pair.first)));
    }

    @Nullable
    private static PsiComment searchPreviousNonDocComment(@NotNull PsiElement element) {
        ASTNode parent;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(27);
        }
        String propName = null;
        ASTNode elementToProcess = parent = element.getNode();
        PsiComment docComment = null;
        while (!(elementToProcess instanceof FileASTNode)) {
            if (elementToProcess != null && elementToProcess.getElementType() == JSElementTypes.EXPRESSION_STATEMENT) {
                String currentPropertyName = JSDocumentationUtils.getPropertyNameFromExprStatement(elementToProcess);
                if (propName == null ? elementToProcess == parent : propName.equals(currentPropertyName)) {
                    docComment = JSDocumentationUtils.getStartingChildDocComment(elementToProcess);
                    if (docComment != null) break;
                    if (propName == null) {
                        propName = currentPropertyName;
                    }
                    if (propName != null) {
                        elementToProcess = elementToProcess.getTreePrev();
                        continue;
                    }
                }
            }
            if (elementToProcess != null && JSTokenTypes.COMMENTS.contains(elementToProcess.getElementType())) {
                docComment = (PsiComment)elementToProcess.getPsi();
                break;
            }
            if (elementToProcess != null && (JSTokenTypes.PARSER_WHITE_SPACE_TOKENS.contains(elementToProcess.getElementType()) || elementToProcess == parent)) {
                elementToProcess = elementToProcess.getTreePrev();
                continue;
            }
            if (parent == null || !JSElementTypes.EXPRESSIONS.contains(parent.getElementType())) break;
            elementToProcess = parent = parent.getTreeParent();
        }
        if (docComment != null) {
            PsiElement docCommentPrevSibling = docComment.getPrevSibling();
            if (docCommentPrevSibling != null && !JSUtils.isLineBreakWhiteSpace(docCommentPrevSibling) && docCommentPrevSibling.getPrevSibling() instanceof JSSourceElement) {
                docComment = null;
            }
            if (docComment != null && !(docComment instanceof JSDocComment)) {
                JSDocComment jsDocComment = JSDocumentationUtils.findPreviousJSDocComment(docComment);
                if (jsDocComment != null) {
                    return jsDocComment;
                }
                PsiElement docCommentNextSibling = docComment.getNextSibling();
                if (docCommentNextSibling instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)docCommentNextSibling.getText()) > 1) {
                    docComment = null;
                }
            }
        }
        return docComment;
    }

    @Nullable
    private static JSDocComment findPreviousJSDocComment(@NotNull PsiComment docComment) {
        if (docComment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(28);
        }
        while (docComment != null && !(docComment instanceof JSDocComment)) {
            docComment = (PsiComment)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesBackward((PsiElement)docComment), PsiComment.class);
        }
        return (JSDocComment)docComment;
    }

    @NotNull
    private static PsiComment skipOuterElements(@NotNull PsiComment docComment) {
        PsiElement siblingSibling;
        if (docComment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(29);
        }
        while (docComment.getPrevSibling() instanceof OuterLanguageElement && (siblingSibling = docComment.getPrevSibling().getPrevSibling()) instanceof PsiComment) {
            docComment = (PsiComment)siblingSibling;
        }
        PsiComment psiComment = docComment;
        if (psiComment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(30);
        }
        return psiComment;
    }

    @Nullable
    private static PsiElement getParentToSearchDocComment(@NotNull PsiElement element) {
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(31);
        }
        if (element instanceof JSImplicitElement || element instanceof FakePsiElement) {
            PsiElement parent = element.getParent();
            if (parent instanceof JSExportAssignment) {
                return parent;
            }
        } else {
            ASTNode parent;
            ASTNode node = element.getNode();
            ASTNode aSTNode = parent = node != null ? node.getTreeParent() : null;
            if (parent != null && JSElementTypes.EXPORT_ASSIGNMENTS.contains(parent.getElementType())) {
                return parent.getPsi();
            }
        }
        if (element instanceof JSFunction || element instanceof JSClass || element instanceof JSExpressionStatement || element instanceof JSNamespaceDeclaration || element instanceof TypeScriptTypeMember || element instanceof JSVarStatement || element instanceof JSExportAssignment) {
            return element;
        }
        if (element instanceof JSProperty) {
            JSProperty property = (JSProperty)element;
            JSFunctionExpression value = (JSFunctionExpression)ObjectUtils.tryCast((Object)property.getValue(), JSFunctionExpression.class);
            return value != null && (value.isGetProperty() || value.isSetProperty()) ? value : element;
        }
        return null;
    }

    @NotNull
    private static PsiElement getElementOverAssignmentParent(@NotNull PsiElement element) {
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(32);
        }
        PsiElement parent = element.getParent();
        while (parent instanceof JSAssignmentExpression) {
            element = parent;
            parent = parent.getParent();
        }
        if (parent instanceof JSProperty || parent instanceof JSVariable || parent instanceof JSExportAssignment) {
            element = parent;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            JSDocumentationUtils.$$$reportNull$$$0(33);
        }
        return psiElement;
    }

    @Nullable
    private static PsiElement getAssociatedElement(@NotNull PsiElement element, @Nullable PsiElement parentToSearchDocComment) {
        PsiElement associatedElement;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(34);
        }
        PsiElement psiElement = associatedElement = parentToSearchDocComment != null ? parentToSearchDocComment : element;
        if (associatedElement instanceof JSFunction || associatedElement instanceof JSVarStatement || associatedElement instanceof JSProperty || associatedElement instanceof JSClass) {
            associatedElement = associatedElement.getFirstChild();
            while (associatedElement instanceof OuterLanguageElement) {
                associatedElement = associatedElement.getNextSibling();
            }
        }
        return associatedElement;
    }

    @Nullable
    private static JSDocComment getStartingChildDocComment(@Nullable ASTNode node) {
        if (node == null) {
            return null;
        }
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (type == JSStubElementTypes.DOC_COMMENT) {
                return (JSDocComment)child.getPsi();
            }
            if (!DOC_COMMENT_ALLOWED_AFTER.contains(type)) break;
        }
        return null;
    }

    public static void createOrUpdateTagsInDocComment(@NotNull PsiElement element, @Nullable List<String> tagsToCreate, @Nullable Map<Integer, String> tagsToUpdate, @Nullable Set<Integer> tagsToDelete) {
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(35);
        }
        ArrayList<Pair> indexedTagsToCreate = null;
        if (tagsToCreate != null) {
            indexedTagsToCreate = new ArrayList<Pair>(tagsToCreate.size());
            for (String s : tagsToCreate) {
                indexedTagsToCreate.add(Pair.create((Object)Integer.MAX_VALUE, (Object)s));
            }
        }
        JSDocumentationUtils.createOrUpdateTagsWithInsertionIndexes(element, indexedTagsToCreate, tagsToUpdate, tagsToDelete);
    }

    public static void createOrUpdateTagsWithInsertionIndexes(@NotNull PsiElement element, @Nullable List<Pair<Integer, String>> tagsToCreate, @Nullable Map<Integer, String> tagsToUpdate, @Nullable Set<Integer> tagsToDelete) {
        Ref elementToAttachRef;
        PsiComment docComment;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(36);
        }
        if (tagsToCreate != null) {
            tagsToCreate.sort(Pair.comparingByFirst());
        }
        if (!((docComment = JSDocumentationUtils.findDocComment(element, null, (Ref<? super PsiElement>)(elementToAttachRef = Ref.create(null)))) instanceof JSDocComment)) {
            PsiElement elementToAttach = (PsiElement)elementToAttachRef.get();
            if (elementToAttach == null) {
                return;
            }
            StringBuilder comment = new StringBuilder("/**\n");
            if (tagsToCreate != null) {
                for (Pair<Integer, String> tag : tagsToCreate) {
                    comment.append(" * @").append((String)tag.second).append("\n");
                }
            }
            comment.append(" */");
            JSDocComment newDocComment = JSPsiElementFactory.createJSDocComment(comment.toString(), elementToAttach);
            elementToAttach.getParent().addBefore((PsiElement)newDocComment, elementToAttach);
            JSChangeUtil.addWs(elementToAttach.getParent().getNode(), elementToAttach.getNode(), "\n");
        } else {
            String newComment;
            JSDocComment jsDocComment = (JSDocComment)docComment;
            String oldText = docComment.getText();
            StringBuilder comment = new StringBuilder(oldText);
            int modifiedCommentLengthDelta = 0;
            JSDocTag[] tags = jsDocComment.getTags();
            ListIterator<Pair<Integer, String>> tagsToCreateIterator = tagsToCreate != null ? tagsToCreate.listIterator() : null;
            for (int i = 0; i < tags.length; ++i) {
                int tagEnd;
                String newTagValue;
                JSDocTag tag = tags[i];
                while (tagsToCreateIterator != null && tagsToCreateIterator.hasNext()) {
                    Pair<Integer, String> next = tagsToCreateIterator.next();
                    if ((Integer)next.first == i) {
                        char c;
                        int offsetInParent = modifiedCommentLengthDelta + tag.getStartOffsetInParent();
                        StringBuilder spacesPrefix = new StringBuilder();
                        for (int j = tag.getStartOffsetInParent() - 1; j >= 0 && ((c = oldText.charAt(j)) == ' ' || c == '\t' || c == '*' && j > 0 && oldText.charAt(j - 1) != '*'); --j) {
                            spacesPrefix.insert(0, c);
                        }
                        String tagToInsert = "@" + (String)next.second + "\n" + spacesPrefix;
                        comment.insert(offsetInParent, tagToInsert);
                        modifiedCommentLengthDelta += tagToInsert.length();
                        continue;
                    }
                    tagsToCreateIterator.previous();
                    break;
                }
                String string = newTagValue = tagsToUpdate != null ? tagsToUpdate.get(i) : null;
                if (newTagValue != null) {
                    JSDocTagValue oldTagValue = tag.getValue();
                    int offsetInParent = modifiedCommentLengthDelta + (oldTagValue != null ? oldTagValue.getStartOffsetInParent() + tag.getStartOffsetInParent() : tag.getStartOffsetInParent() + tag.getTextLength());
                    int oldLength = oldTagValue != null ? oldTagValue.getTextLength() : 0;
                    comment.replace(offsetInParent, offsetInParent + oldLength, newTagValue);
                    modifiedCommentLengthDelta += newTagValue.length() - oldLength;
                    continue;
                }
                if (tagsToDelete == null || !tagsToDelete.contains(i)) continue;
                int tagStart = oldText.lastIndexOf(10, tag.getStartOffsetInParent());
                if (tagStart == -1) {
                    tagStart = tag.getStartOffsetInParent();
                }
                if ((tagEnd = oldText.indexOf(10, tag.getStartOffsetInParent())) == -1) {
                    tagEnd = tag.getStartOffsetInParent() + tag.getTextLength();
                }
                comment.delete(tagStart + modifiedCommentLengthDelta, tagEnd + modifiedCommentLengthDelta);
                modifiedCommentLengthDelta -= tagEnd - tagStart;
            }
            if (tagsToCreateIterator != null && tagsToCreateIterator.hasNext()) {
                int newTagOffset;
                newComment = comment.toString();
                int lastIndexOfNewline = newComment.lastIndexOf(10);
                if (lastIndexOfNewline != -1) {
                    newTagOffset = lastIndexOfNewline + 1;
                } else {
                    comment.insert(comment.length() - 2, '\n');
                    newTagOffset = comment.length() - 2;
                }
                while (tagsToCreateIterator.hasNext()) {
                    String tag = (String)tagsToCreateIterator.next().second;
                    comment.insert(newTagOffset, "\n").insert(newTagOffset, tag).insert(newTagOffset, " * @");
                    newTagOffset += tag.length() + 1 + 4;
                }
            }
            if ((newComment = comment.toString()).replaceAll("[\\s*/]", "").isEmpty()) {
                jsDocComment.delete();
            } else {
                jsDocComment.replace((PsiElement)JSPsiElementFactory.createJSDocComment(newComment, (PsiElement)docComment));
            }
        }
    }

    @Nullable
    private static String getPropertyNameFromExprStatement(@NotNull ASTNode node) {
        ASTNode rOperand;
        if (node == null) {
            JSDocumentationUtils.$$$reportNull$$$0(37);
        }
        String propName = null;
        if (node.getElementType() == JSElementTypes.EXPRESSION_STATEMENT) {
            node = node.findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
        }
        if (node != null && node.getElementType() == JSStubElementTypes.ASSIGNMENT_EXPRESSION && (rOperand = JSBinaryExpressionImpl.getROperandNode(node)) != null && JSElementTypes.FUNCTION_EXPRESSIONS.contains(rOperand.getElementType())) {
            String name = ((JSFunctionExpression)rOperand.getPsi()).getName();
            propName = JSDocumentationUtils.getPropertyName(name);
        }
        return propName;
    }

    @Nullable
    public static String getPropertyName(String name) {
        if (name != null && name.length() > 3 && (StringUtil.startsWith((CharSequence)name, (CharSequence)"get") || StringUtil.startsWith((CharSequence)name, (CharSequence)"set"))) {
            return name.substring(3);
        }
        return null;
    }

    @Nullable
    private static JSType getTypeFromPrecedingComment(JSVariable variable) {
        if (variable instanceof JSParameter) {
            JSParameterTypeDecorator paramType = JSDocumentationUtils.getParameterTypeFromPrecedingComment((JSParameter)variable);
            return paramType != null ? paramType.getSimpleType() : null;
        }
        PsiElement prevSibling = JSDocumentationUtils.getReasonablePrevElement(variable);
        if (prevSibling instanceof PsiComment) {
            return JSDocumentationUtils.tryCreateTypeFromComment((PsiComment)prevSibling, false, false, false);
        }
        return null;
    }

    public static JSParameterTypeDecorator getParameterTypeFromPrecedingComment(@NotNull JSParameter parameter) {
        PsiElement prevSibling;
        if (parameter == null) {
            JSDocumentationUtils.$$$reportNull$$$0(38);
        }
        if ((prevSibling = JSDocumentationUtils.getReasonablePrevElement(parameter)) == null) {
            prevSibling = JSDocumentationUtils.findPossiblyRelatedCommentForArrowFunctionParam(parameter);
        }
        if (prevSibling instanceof PsiComment && prevSibling.getNode().getElementType() != JSTokenTypes.END_OF_LINE_COMMENT && JSDocumentationUtils.isTypeStringAcceptable(JSDocumentationUtils.unwrapCommentDelimiters(prevSibling.getText()), true)) {
            return JSTypeParser.createParameterType(parameter.getProject(), JSDocumentationUtils.unwrapCommentDelimiters(prevSibling.getText()), JSTypeSourceFactory.createTypeSource(prevSibling, true), true, true);
        }
        return null;
    }

    @Nullable
    private static PsiComment findPossiblyRelatedCommentForArrowFunctionParam(@NotNull JSParameter parameter) {
        PsiElement parent;
        if (parameter == null) {
            JSDocumentationUtils.$$$reportNull$$$0(39);
        }
        if ((parent = parameter.getParent()) instanceof JSParameterList && parent.getFirstChild() == parameter) {
            PsiElement prevSibling;
            for (prevSibling = parent.getPrevSibling(); prevSibling != null && (prevSibling instanceof PsiWhiteSpace || prevSibling.getTextRange().isEmpty()); prevSibling = prevSibling.getPrevSibling()) {
            }
            if (prevSibling instanceof PsiComment) {
                return (PsiComment)prevSibling;
            }
        }
        return null;
    }

    private static PsiElement getReasonablePrevElement(@NotNull JSVariable variable) {
        PsiElement prevSibling;
        if (variable == null) {
            JSDocumentationUtils.$$$reportNull$$$0(40);
        }
        if ((prevSibling = variable.getFirstChild()) != null && JSVariableBaseImpl.IDENTIFIER_TOKENS_SET.contains(prevSibling.getNode().getElementType())) {
            prevSibling = variable.getPrevSibling();
        }
        if (prevSibling instanceof PsiWhiteSpace) {
            prevSibling = prevSibling.getPrevSibling();
        }
        return prevSibling;
    }

    @Nullable
    private static JSType rawGetTypeForVariable(JSVariable variable) {
        String typeString;
        JSType typeFromPrecedingComment = JSDocumentationUtils.getTypeFromPrecedingComment(variable);
        if (typeFromPrecedingComment != null) {
            return typeFromPrecedingComment;
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)variable);
        if (docComment instanceof JSDocComment && (typeString = JSDocumentationUtils.getTypeFromComment((JSDocComment)docComment)) != null) {
            return JSTypeParser.createTypeFromJSDoc(docComment.getProject(), typeString, JSTypeSourceFactory.createTypeSource((PsiElement)docComment, true));
        }
        return null;
    }

    @Nullable
    public static PsiComment findDocCommentWider(@Nullable PsiElement _anchor) {
        PsiElement anchor = _anchor;
        PsiComment docComment = null;
        if (_anchor instanceof JSExpression && (docComment = JSDocumentationUtils.findDocComment(_anchor)) == null) {
            anchor = PsiTreeUtil.getParentOfType((PsiElement)_anchor, (Class[])new Class[]{JSStatement.class, JSProperty.class});
        }
        if (anchor != null && docComment == null) {
            docComment = JSDocumentationUtils.findDocComment(anchor);
        }
        return docComment;
    }

    @Nullable
    public static String findType(@Nullable PsiElement def) {
        if (def == null) {
            return null;
        }
        PsiComment comment = JSDocumentationUtils.findDocCommentWider(def);
        if (comment instanceof JSDocComment) {
            JSDocComment docComment = (JSDocComment)comment;
            String type = docComment.getType();
            for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
                type = handler.adjustTypeFromJSDoc(def, docComment, type);
            }
            return type;
        }
        return null;
    }

    @Nullable
    private static String getTypeFromComment(@NotNull JSDocComment comment) {
        if (comment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(41);
        }
        return comment.getType();
    }

    @Nullable
    public static JSType findContextType(@Nullable PsiElement anchor) {
        JSType thisType;
        JSType type;
        String fromTag;
        if (anchor == null || DialectDetector.isTypeScript(anchor)) {
            return null;
        }
        PsiComment element = JSDocumentationUtils.findDocCommentWider(anchor);
        if (element instanceof JSDocComment && (fromTag = ((JSDocComment)element).getThisType()) != null) {
            return JSTypeParser.createTypeFromJSDoc(element.getProject(), fromTag, JSTypeSourceFactory.createTypeSource((PsiElement)element, true));
        }
        String fromType = JSDocumentationUtils.findType(anchor);
        if (fromType != null && (type = JSTypeParser.createTypeFromJSDoc(anchor.getProject(), fromType, JSTypeSource.EMPTY)) instanceof JSFunctionTypeImpl && (thisType = ((JSFunctionTypeImpl)type).getThisType()) != null) {
            return thisType;
        }
        return null;
    }

    public static String findEnumType(PsiElement anchor) {
        PsiComment docComment = JSDocumentationUtils.findDocCommentWider(anchor);
        return docComment instanceof JSDocComment ? ((JSDocComment)docComment).getEnumType() : null;
    }

    @Contract(value="null, _ -> false")
    public static boolean hasJSDocTag(@Nullable PsiElement anchor, JSDocBlockTags ... docTypesArray) {
        if (docTypesArray.length == 0) {
            return false;
        }
        PsiComment docComment = JSDocumentationUtils.findDocCommentWider(anchor);
        final Set docTypes = CollectionFactory.createCaseInsensitiveStringSet((Collection)ContainerUtil.map((Object[])docTypesArray, it -> it.getName()));
        if (docComment != null) {
            final Ref hasNeededTag = Ref.create((Object)Boolean.FALSE);
            JSDocumentationUtils.processDocumentationTextFromComment((PsiElement)docComment, docComment.getNode(), new JSDocCommentVisitor(){

                @Override
                public void visitJSDocTag(@NotNull JSDocTag tag) {
                    if (tag == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (docTypes.contains(tag.getName())) {
                        hasNeededTag.set((Object)Boolean.TRUE);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/documentation/JSDocumentationUtils$2", "visitJSDocTag"));
                }
            });
            return (Boolean)hasNeededTag.get();
        }
        return false;
    }

    public static boolean isDeprecated(PsiElement element) {
        JSDocOwner docOwner;
        return element instanceof JSDocOwner && (docOwner = (JSDocOwner)element).isDeprecated();
    }

    public static boolean calculateDeprecated(@NotNull PsiElement element) {
        JSDocComment docComment;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(42);
        }
        return (docComment = JSDocumentationUtils.findOwnDocComment(element)) != null && docComment.hasDeprecatedTag();
    }

    @NlsSafe
    @Nullable
    public static String getDeprecationMessage(@NotNull PsiElement element) {
        JSDocComment docComment;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(43);
        }
        return (docComment = JSDocumentationUtils.findOwnDocComment(element)) != null && docComment.hasDeprecatedTag() ? docComment.getDeprecationMessage() : null;
    }

    @NlsSafe
    @Nullable
    public static String getSinceMessage(@NotNull PsiElement element) {
        JSDocComment docComment;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(44);
        }
        return (docComment = JSDocumentationUtils.findOwnDocComment(element)) != null ? docComment.getSinceMessage() : null;
    }

    public static boolean calculateConst(@NotNull PsiElement element) {
        JSDocComment docComment;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(45);
        }
        return (docComment = JSDocumentationUtils.findOwnDocComment(element)) != null && docComment.hasConstTag();
    }

    public static void appendHyperLinkToElement(@Nullable PsiElement element, String elementName, StringBuilder buffer, String presentableName, boolean addElementName, boolean addFilename, int elementId) {
        String prefix;
        PsiFile containingFile = element != null ? element.getContainingFile() : null;
        String fileName = containingFile == null ? null : containingFile.getViewProvider().getVirtualFile().getName();
        String path2 = containingFile != null && !JSResolveUtil.isFromPredefinedFile(containingFile) ? containingFile.getVirtualFile().getPresentableUrl() : fileName;
        boolean isJsElement = element instanceof JSElementBase;
        JSQualifiedName namespace = isJsElement ? ((JSElementBase)element).getNamespace() : null;
        String string = prefix = path2 != null ? FileUtilRt.toSystemIndependentName((String)path2) + HYPERLINK_SEPARATOR : "";
        String linkText = prefix + elementName + (String)(namespace != null ? HYPERLINK_SEPARATOR + namespace.getQualifiedName() : (isJsElement ? "%null" : ""));
        if (elementId > 0) {
            linkText = linkText + INDEX_POSITION_SEPARATOR + elementId;
        }
        String quote = element != null ? "`" : "";
        DocumentationManagerUtil.createHyperlink((StringBuilder)buffer, (String)linkText, (String)((String)(addElementName ? quote + presentableName + quote : "") + (String)(StringUtil.isEmpty((String)fileName) || !addFilename ? "" : (addElementName ? " in " : "") + fileName)), (boolean)true);
    }

    @Nullable
    public static PsiComment findFunctionComment(JSFunction _anchor) {
        PsiComment docComment;
        JSFunction anchor = _anchor;
        if (anchor instanceof JSFunctionExpression) {
            docComment = JSDocumentationUtils.findDocComment(anchor);
            if (docComment instanceof JSDocComment && JSDocumentationUtils.findFunctionAppliedTo((JSDocComment)docComment) == _anchor) {
                return docComment;
            }
            PsiElement parent = anchor.getParent();
            PsiElement grandparent = parent.getParent();
            anchor = parent instanceof JSVariable && grandparent.getNode().findChildByType(JSElementTypes.BODY_VARIABLES) != parent.getNode() ? parent : PsiTreeUtil.getParentOfType((PsiElement)anchor, (Class[])new Class[]{JSStatement.class, JSProperty.class});
        }
        if (anchor != null && (docComment = JSDocumentationUtils.findDocComment(anchor)) instanceof JSDocComment && JSDocumentationUtils.findFunctionAppliedTo((JSDocComment)docComment) == _anchor) {
            return docComment;
        }
        return null;
    }

    @Nullable
    public static JSFunction findFunctionAppliedTo(@NotNull JSDocComment comment) {
        JSExpression assignedExpression;
        Object parent;
        if (comment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(46);
        }
        if ((parent = comment.getParent()) instanceof JSFunction) {
            return (JSFunction)parent;
        }
        if (parent instanceof JSExpressionStatement) {
            parent = ((JSExpressionStatement)parent).getExpression();
        }
        if (parent instanceof JSVarStatement) {
            parent = PsiTreeUtil.getNextSiblingOfType((PsiElement)comment, JSVariable.class);
        }
        if ((assignedExpression = JSPsiImplUtils.getAssignedExpression(parent)) instanceof JSFunction) {
            return (JSFunction)((Object)assignedExpression);
        }
        return null;
    }

    @Nullable
    public static JSType getTypeFromTrailingComment(JSFunction function) {
        ASTNode lastCommentInFunctionBody = JSDocumentationUtils.findTrailingCommentInFunctionBody(function);
        if (lastCommentInFunctionBody != null) {
            JSType type = JSDocumentationUtils.tryCreateTypeFromComment((PsiComment)lastCommentInFunctionBody.getPsi(), false, true, false);
            if (!(type instanceof JSSpecialNamedTypeImpl)) {
                type = JSTypeUtils.copyWithStrict(type, false);
            }
            return type;
        }
        return null;
    }

    @Nullable
    public static JSType getTypeFromReturnTypeComment(JSFunction function) {
        JSParameterList list = function.getParameterList();
        JSType type = null;
        if (list != null) {
            PsiElement reasonableNextElement = list.getNextSibling();
            if (reasonableNextElement instanceof PsiWhiteSpace) {
                reasonableNextElement = reasonableNextElement.getNextSibling();
            }
            if (reasonableNextElement instanceof JSDocComment) {
                type = JSDocumentationUtils.tryCreateTypeFromComment((JSDocComment)reasonableNextElement, false, true, false);
            }
        }
        return type;
    }

    public static JSType tryCreateTypeFromComment(@NotNull PsiComment comment, boolean spaceAllowed, boolean allowEOLComment, boolean allowCommentAfterType) {
        if (comment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(47);
        }
        if (!allowEOLComment && comment.getNode().getElementType() == JSTokenTypes.END_OF_LINE_COMMENT) {
            return null;
        }
        String body2 = JSDocumentationUtils.unwrapCommentDelimiters(comment.getText());
        if (allowEOLComment) {
            body2 = body2.trim();
        }
        if (!JSDocumentationUtils.isTypeStringAcceptable(body2, spaceAllowed)) {
            return null;
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)comment, true);
        return JSTypeParser.createType(comment.getProject(), body2, typeSource, allowCommentAfterType);
    }

    private static boolean isTypeStringAcceptable(String typeString, boolean spaceAllowed) {
        if (typeString.indexOf(10) != -1) {
            return false;
        }
        if (!spaceAllowed && typeString.indexOf(32) != -1) {
            return false;
        }
        return !(typeString = typeString.trim()).equals("TODO") && !typeString.equals("INTERNAL") && !typeString.isEmpty() && !typeString.endsWith(",") && !typeString.startsWith(",");
    }

    @Nullable
    public static JSType findTypeFromComments(JSNamedElement element) {
        if (element instanceof JSVariable) {
            return JSDocumentationUtils.rawGetTypeForVariable((JSVariable)element);
        }
        if (element instanceof JSFunction) {
            JSType type = JSDocumentationUtils.getTypeFromTrailingComment((JSFunction)element);
            if (type != null) {
                return type;
            }
            PsiComment docComment = JSDocumentationUtils.findDocCommentWider((PsiElement)element);
            if (docComment instanceof JSDocComment) {
                String returnType = ((JSDocComment)docComment).getReturnType();
                if (returnType == null) {
                    returnType = ((JSDocComment)docComment).getType();
                }
                if (returnType != null) {
                    return JSTypeParser.createTypeFromJSDoc(docComment.getProject(), returnType, JSTypeSourceFactory.createTypeSource((PsiElement)element, true));
                }
            }
        }
        return null;
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static String doCapitalizeCommentTypeIfNeeded(String comment) {
        if (StringUtil.isEmpty((String)comment)) {
            return comment;
        }
        String wrapperType = JSCommonTypeNames.TYPE_TO_WRAPPER_MAP.get(comment);
        if (wrapperType != null) {
            return wrapperType;
        }
        if (comment.equals("array")) {
            return "Array";
        }
        if ("Integer".equals(comment)) {
            return "int";
        }
        return comment;
    }

    @Nullable
    public static String stripTypeDecorations(@Nullable String textFragment) {
        int commaIndex;
        if (textFragment == null) {
            return null;
        }
        textFragment = textFragment.trim();
        textFragment = StringUtil.trimStart((String)textFragment, (String)"...");
        int i = (textFragment = StringUtil.trimStart((String)textFragment, (String)"!")).indexOf(63);
        if (i != -1) {
            textFragment = i == 0 ? textFragment.substring(1) : textFragment.substring(0, i);
        }
        if (i < 1 && (i = textFragment.indexOf(61)) != -1) {
            textFragment = textFragment.substring(0, i);
        }
        if ((textFragment = StringUtil.trimEnd((String)textFragment, (String)".")).startsWith("(") && textFragment.endsWith(")")) {
            textFragment = textFragment.substring(1, textFragment.length() - 1);
        }
        if ((commaIndex = textFragment.indexOf(44)) != -1 && textFragment.indexOf(123) == -1) {
            textFragment = textFragment.substring(0, commaIndex).trim();
        }
        return textFragment;
    }

    @NotNull
    public static String getLibDocRelativeUrl(@NotNull String baseUrl, @NotNull String elementFQN) {
        String[] rules;
        String baseKey;
        if (baseUrl == null) {
            JSDocumentationUtils.$$$reportNull$$$0(48);
        }
        if (elementFQN == null) {
            JSDocumentationUtils.$$$reportNull$$$0(49);
        }
        if ((baseKey = JSExternalLibraryDocBundle.getBaseURLKey(baseUrl)) == null) {
            return "";
        }
        String directUrl = JSExternalLibraryDocBundle.getElementUrl(baseKey, elementFQN);
        if (directUrl != null) {
            String string = directUrl;
            if (string == null) {
                JSDocumentationUtils.$$$reportNull$$$0(50);
            }
            return string;
        }
        String prefix = JSExternalLibraryDocBundle.getPrefix(baseKey);
        String relativeUrl = elementFQN;
        String rulesStr = JSExternalLibraryDocBundle.getRules(baseKey);
        for (String rule : rules = rulesStr.split(";")) {
            String replacement;
            if (rule.trim().isEmpty()) continue;
            String[] args = rule.split(",");
            String opType = args[0].trim();
            String sample = args.length > 1 ? args[1].trim() : "";
            String string = replacement = args.length > 2 ? args[2].trim() : "";
            if (opType.startsWith("S")) {
                relativeUrl = relativeUrl.replace(sample, replacement);
                continue;
            }
            if (opType.startsWith("R")) {
                relativeUrl = relativeUrl.replaceAll(sample, replacement);
                continue;
            }
            if (opType.startsWith("L")) {
                relativeUrl = StringUtil.toLowerCase((String)relativeUrl);
                continue;
            }
            assert (false) : "Don't know how to handle " + opType + " in rule " + rule + " must be R or S";
        }
        if (JSExternalLibraryDocBundle.isLowerCase(baseKey)) {
            relativeUrl = StringUtil.toLowerCase((String)relativeUrl);
        }
        String string = prefix + relativeUrl;
        if (string == null) {
            JSDocumentationUtils.$$$reportNull$$$0(51);
        }
        return string;
    }

    @Nullable
    public static String getBaseKey(@NotNull String libUrl) {
        if (libUrl == null) {
            JSDocumentationUtils.$$$reportNull$$$0(52);
        }
        for (String baseKey : JSExternalLibraryDocBundle.getBasePatternKeys()) {
            String patterns = JSExternalLibraryDocBundle.getPatterns(baseKey);
            if (patterns == null) continue;
            for (String pattern : patterns.split(";")) {
                String tp = pattern.trim();
                if (tp.isEmpty() || !libUrl.matches(tp)) continue;
                return baseKey;
            }
        }
        return null;
    }

    @Nullable
    public static PsiElement findAssociatedElement(@NotNull PsiComment psiComment) {
        JSVariable[] variables;
        if (psiComment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(53);
        }
        PsiElement parent = psiComment.getParent();
        JSElement next = null;
        if (parent instanceof JSExpressionStatement) {
            JSExpression expression = ((JSExpressionStatement)parent).getExpression();
            if (expression instanceof JSAssignmentExpression) {
                JSExpression lOperand = ((JSAssignmentExpression)expression).getLOperand();
                if (lOperand instanceof JSDefinitionExpression || lOperand instanceof JSReferenceExpression) {
                    next = lOperand;
                }
            } else if (expression instanceof JSReferenceExpression) {
                next = expression;
            }
        } else if (parent instanceof ES6ExportDefaultAssignment) {
            next = ((ES6ExportDefaultAssignment)parent).getExpression();
        } else if (parent instanceof JSProperty || parent instanceof JSFunction || parent instanceof JSVariable || parent instanceof JSClass) {
            next = parent;
        } else if (parent instanceof JSVarStatement && (variables = ((JSVarStatement)parent).getVariables()).length > 0) {
            next = variables[0];
        }
        return next;
    }

    @Nullable
    public static PsiElement findAttachedElementFromComment(PsiComment psiComment) {
        PsiElement next;
        PsiElement strictElement = JSDocumentationUtils.findAssociatedElement(psiComment);
        if (strictElement != null) {
            return strictElement;
        }
        for (next = psiComment.getNextSibling(); next instanceof PsiWhiteSpace || next instanceof PsiComment || next != null && !(next instanceof JSElement); next = next.getNextSibling()) {
        }
        PsiComment associatedComment = JSDocumentationUtils.findDocCommentWider(next);
        if (associatedComment != null && associatedComment != psiComment) {
            return null;
        }
        return next;
    }

    @Nullable
    public static String getQualifiedNameFromPsi(@Nullable PsiElement namedElement) {
        JSQualifiedName name;
        if (namedElement instanceof JSDefinitionExpression) {
            namedElement = ((JSDefinitionExpression)namedElement).getExpression();
        }
        if (namedElement instanceof JSNamedElement && !(namedElement instanceof JSProperty)) {
            return ((JSNamedElement)namedElement).getName();
        }
        if (namedElement instanceof JSReferenceExpression && (name = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)namedElement)) != null) {
            return name.getQualifiedName();
        }
        return null;
    }

    @NotNull
    public static JSElementBase.ClassOrInterface isClassOrInterface(JSQualifiedNamedElement element) {
        if (element instanceof JSParameter) {
            JSElementBase.ClassOrInterface classOrInterface = JSElementBase.ClassOrInterface.NONE;
            if (classOrInterface == null) {
                JSDocumentationUtils.$$$reportNull$$$0(54);
            }
            return classOrInterface;
        }
        JSDocComment comment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)element);
        JSElementBase.ClassOrInterface classOrInterface = comment != null && comment.hasInterfaceTag() ? JSElementBase.ClassOrInterface.INTERFACE : (comment != null && comment.isClassExplicitly() ? JSElementBase.ClassOrInterface.CLASS : JSElementBase.ClassOrInterface.NONE);
        if (classOrInterface == null) {
            JSDocumentationUtils.$$$reportNull$$$0(55);
        }
        return classOrInterface;
    }

    public static int findNextNamepathSeparator(@NotNull String namepath, int startOffset) {
        if (namepath == null) {
            JSDocumentationUtils.$$$reportNull$$$0(56);
        }
        Pattern pattern = startOffset == 0 ? NAMEPATH_START_PATTERN : NAMEPATH_PART_PATTERN;
        Matcher partMatcher = pattern.matcher(namepath.subSequence(startOffset, namepath.length()));
        return !partMatcher.lookingAt() ? -1 : startOffset + partMatcher.end();
    }

    @NotNull
    public static String appendPrefixToName(@NotNull String name, @NotNull String prefix) {
        int lastPartOffset;
        if (name == null) {
            JSDocumentationUtils.$$$reportNull$$$0(57);
        }
        if (prefix == null) {
            JSDocumentationUtils.$$$reportNull$$$0(58);
        }
        if (!name.startsWith(prefix, lastPartOffset = JSDocumentationUtils.findLastNamepathPartOffset(name))) {
            name = new StringBuilder(name).insert(lastPartOffset, prefix).toString();
        }
        String string = name;
        if (string == null) {
            JSDocumentationUtils.$$$reportNull$$$0(59);
        }
        return string;
    }

    private static int findLastNamepathPartOffset(@NotNull String namepath) {
        if (namepath == null) {
            JSDocumentationUtils.$$$reportNull$$$0(60);
        }
        int startOffset = 0;
        int prevDot = -1;
        while (true) {
            int nextDot;
            if ((nextDot = JSDocumentationUtils.findNextNamepathSeparator(namepath, prevDot + 1)) - prevDot > 1) {
                startOffset = prevDot + 1;
            }
            if (nextDot >= namepath.length() || nextDot <= prevDot) break;
            prevDot = nextDot;
        }
        return startOffset;
    }

    public static boolean mayRelateTo(@NotNull JSDocComment docComment, @NotNull PsiElement element) {
        Collection<Pair<String, String>> typedefs;
        JSElementIndexingData indexingData;
        if (docComment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(61);
        }
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(62);
        }
        if ((indexingData = docComment.getIndexingData()) != null && element instanceof JSPsiNamedElementBase && (typedefs = indexingData.getTypedefs()) != null && typedefs.size() == 1) {
            Pair pair = (Pair)ContainerUtil.getFirstItem(typedefs);
            assert (pair != null) : "typedef element must not be null";
            if (pair.first != null && !((String)pair.first).equals(((JSPsiNamedElementBase)element).getName())) {
                return false;
            }
        }
        return true;
    }

    public static void moveJSDoc(@Nullable PsiComment docComment, @NotNull PsiElement newElement) {
        if (newElement == null) {
            JSDocumentationUtils.$$$reportNull$$$0(63);
        }
        JSDocComment existingComment = (JSDocComment)PsiTreeUtil.getChildOfType((PsiElement)newElement, JSDocComment.class);
        if (!(docComment == null || existingComment != null && docComment.getText().equals(existingComment.getText()))) {
            JSDocumentationUtils.copyJSDocComment(docComment, newElement);
            docComment.getParent().deleteChildRange((PsiElement)docComment, (PsiElement)docComment);
        }
    }

    public static void copyJSDocComment(@Nullable PsiComment docComment, @NotNull PsiElement newElement) {
        if (newElement == null) {
            JSDocumentationUtils.$$$reportNull$$$0(64);
        }
        if (docComment == null || newElement.getFirstChild() == null) {
            return;
        }
        JSDocComment existingComment = (JSDocComment)PsiTreeUtil.getChildOfType((PsiElement)newElement, JSDocComment.class);
        if (docComment instanceof JSDocComment && existingComment == null) {
            PsiElement firstChild = newElement.getFirstChild();
            newElement.addBefore(docComment.copy(), firstChild);
            JSDocumentationUtils.addNewLineBeforeIfNoNewlineNow(firstChild);
            JSDocumentationUtils.addNewLineBeforeIfNoNewlineNow(newElement);
        } else {
            PsiElement added = newElement.getParent().addBefore(docComment.copy(), newElement);
            JSDocumentationUtils.addNewLineBeforeIfNoNewlineNow(added);
            JSDocumentationUtils.addNewLineBeforeIfNoNewlineNow(newElement);
        }
    }

    private static void addNewLineBeforeIfNoNewlineNow(@NotNull PsiElement newElement) {
        if (newElement == null) {
            JSDocumentationUtils.$$$reportNull$$$0(65);
        }
        if (newElement.getPrevSibling() instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)newElement.getPrevSibling().getText()) > 0) {
            return;
        }
        JSChangeUtil.addWs(newElement.getParent().getNode(), newElement.getNode(), "\n");
    }

    @Nullable
    public static PsiElement findCommentForImplicitElement(@Nullable PsiElement implicitElementParent) {
        boolean hasStub = implicitElementParent instanceof StubBasedPsiElement && ((StubBasedPsiElement)implicitElementParent).getStub() != null;
        PsiElement expression = PsiTreeUtil.getNonStrictParentOfType((PsiElement)implicitElementParent, (Class[])new Class[]{hasStub ? JSExpression.class : JSStatement.class, JSProperty.class, JSFunction.class, JSDocComment.class});
        return expression != null ? JSDocumentationUtils.findDocComment(expression) : null;
    }

    @Nullable
    public static JSDocComment findOwnDocCommentForImplicitElement(@NotNull PsiElement implicitElementParent) {
        if (implicitElementParent == null) {
            JSDocumentationUtils.$$$reportNull$$$0(66);
        }
        if (implicitElementParent instanceof PsiFile) {
            return null;
        }
        JSDocComment comment = JSDocumentationUtils.findOwnDocComment(implicitElementParent);
        if (comment != null) {
            return comment;
        }
        PsiElement elementToCheck = implicitElementParent.getParent();
        if (elementToCheck instanceof PsiFile) {
            return null;
        }
        if (elementToCheck instanceof JSArgumentList) {
            elementToCheck = elementToCheck.getParent();
        }
        if (elementToCheck instanceof JSCallExpression) {
            elementToCheck = elementToCheck.getParent();
        }
        if (elementToCheck instanceof JSExpressionStatement) {
            return JSDocumentationUtils.getStartingChildDocComment(elementToCheck.getNode());
        }
        return null;
    }

    @Nullable
    public static MdnSymbolDocumentation getJsMdnDocumentation(@Nullable PsiElement element, @Nullable PsiElement context2) {
        if (element == null || !JSDocumentationUtils.isFromCoreLibFile(element)) {
            return null;
        }
        SmartList candidates = new SmartList();
        if (element instanceof TypeScriptCompileTimeType) {
            PsiElement parent = JSResolveUtil.findParent(element);
            String name = ((TypeScriptCompileTimeType)element).getName();
            if (name != null && parent != null) {
                List<PsiElement> all = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(name, parent);
                all.stream().filter(el -> !(el instanceof TypeScriptCompileTimeType)).findAny().ifPresent(((List)candidates)::add);
                if (candidates.isEmpty()) {
                    candidates.add(element);
                }
            }
        } else if (element instanceof TypeScriptCallSignature) {
            candidates.add((PsiElement)ObjectUtils.doIfNotNull((Object)element.getContext(), PsiElement::getContext));
        } else if (!(element instanceof JSReferenceExpression)) {
            candidates.add(element);
        }
        for (PsiElement candidate : candidates) {
            MdnSymbolDocumentation result2;
            MdnApiNamespace namespace;
            VirtualFile libFile;
            String qName;
            if (!(candidate instanceof JSQualifiedNamedElement) || DumbService.isDumb((Project)candidate.getProject()) || StringUtil.isEmpty((String)(qName = ((JSQualifiedNamedElement)candidate).getQualifiedName())) || (libFile = candidate.getContainingFile().getVirtualFile()) == null) continue;
            if (JSCorePredefinedLibrariesProvider.isWebLibraryFileName(libFile.getName())) {
                namespace = MdnApiNamespace.WebApi;
                if (!qName.contains(".")) {
                    Collection<JSPsiElementBase> targets = JSClassResolver.getInstance().findElementsByNameIncludingImplicit(qName, GlobalSearchScope.fileScope((Project)element.getProject(), (VirtualFile)libFile));
                    String exactName = null;
                    for (JSPsiElementBase target : targets) {
                        String elementQName = target.getQualifiedName();
                        if (elementQName == null || elementQName.equals(qName)) continue;
                        if (exactName != null && !exactName.equals(elementQName)) {
                            exactName = null;
                            break;
                        }
                        exactName = elementQName;
                    }
                    if (exactName != null) {
                        qName = exactName;
                    }
                }
            } else {
                List<VirtualFile> domLibFiles = JSDocumentationUtils.getDomLibraries(element.getProject());
                Collection<JSPsiElementBase> elements = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(qName, GlobalSearchScope.filesScope((Project)element.getProject(), domLibFiles));
                namespace = !elements.isEmpty() ? MdnApiNamespace.WebApi : MdnApiNamespace.GlobalObjects;
            }
            if (!qName.contains(".") && context2 != null) {
                MdnSymbolDocumentation constructorDocumentation = MdnDocumentationKt.getJsMdnDocumentation((MdnApiNamespace)namespace, (String)(qName + "." + qName));
                if (constructorDocumentation == null && namespace == MdnApiNamespace.WebApi) {
                    constructorDocumentation = MdnDocumentationKt.getJsMdnDocumentation((MdnApiNamespace)MdnApiNamespace.GlobalObjects, (String)(qName + "." + qName));
                }
                if (constructorDocumentation != null) {
                    PsiFile containingFile = context2.getContainingFile();
                    if (containingFile != null && context2 instanceof PsiWhiteSpace) {
                        context2 = containingFile.findElementAt(context2.getTextRange().getStartOffset() - 1);
                    }
                    if (PsiTreeUtil.getContextOfType((PsiElement)context2, (boolean)false, (Class[])new Class[]{JSNewExpression.class, JSStatement.class, JSParameterList.class}) instanceof JSNewExpression) {
                        return constructorDocumentation;
                    }
                }
            }
            if ((result2 = MdnDocumentationKt.getJsMdnDocumentation((MdnApiNamespace)namespace, (String)qName)) == null && namespace == MdnApiNamespace.WebApi) {
                result2 = MdnDocumentationKt.getJsMdnDocumentation((MdnApiNamespace)MdnApiNamespace.GlobalObjects, (String)qName);
            }
            return result2;
        }
        return null;
    }

    @NotNull
    private static List<VirtualFile> getDomLibraries(@NotNull Project project) {
        if (project == null) {
            JSDocumentationUtils.$$$reportNull$$$0(67);
        }
        TypeScriptLibraryProvider service = TypeScriptLibraryProvider.getService(project);
        Set<VirtualFile> libraries = service.getAllBundledLibraries();
        List list = ContainerUtil.filter(libraries, el -> JSCorePredefinedLibrariesProvider.isWebLibraryFileName(el.getName()));
        if (list == null) {
            JSDocumentationUtils.$$$reportNull$$$0(68);
        }
        return list;
    }

    public static boolean isFromCoreLibFile(@NotNull PsiElement original) {
        if (original == null) {
            JSDocumentationUtils.$$$reportNull$$$0(69);
        }
        VirtualFile originalFile = (VirtualFile)ObjectUtils.doIfNotNull((Object)original.getContainingFile(), PsiFile::getVirtualFile);
        return TypeScriptLibraryProvider.isLibraryOrBundledLibraryFile(original.getProject(), originalFile) || JSCorePredefinedLibrariesProvider.isCoreLibraryFile(originalFile);
    }

    @Nullable
    public static JSDocParametersMappingToFunctionInfo checkDocCommentMatchesFunctionSignature(@NotNull JSDocComment docComment, @NotNull JSFunction function) {
        if (docComment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(70);
        }
        if (function == null) {
            JSDocumentationUtils.$$$reportNull$$$0(71);
        }
        JSParameter[] parameters = function.getParameterVariables();
        HashMap<String, Integer> actualParameters = new HashMap<String, Integer>(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            actualParameters.put(parameters[i].getName(), i);
        }
        HashMap<String, Integer> matchingTagIndexes = new HashMap<String, Integer>();
        HashMap<Integer, String> tagNames = new HashMap<Integer, String>();
        JSTagToParameterMap tagsToParameters = JSDocumentationUtils.getTagToParameterMap(docComment, function, tagNames);
        for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(tagsToParameters.getMatchedTags())) {
            JSParameterListElement paramElement = (JSParameterListElement)entry.getValue();
            if (!(paramElement instanceof JSParameter)) continue;
            matchingTagIndexes.put(paramElement.getName(), entry.getIntKey());
        }
        HashMap<Integer, String> paramsToRemove = new HashMap<Integer, String>();
        for (Integer nonMatchedTag : tagsToParameters.getNonMatchedTags().keySet()) {
            paramsToRemove.put(nonMatchedTag, (String)tagNames.get(nonMatchedTag));
        }
        if (!paramsToRemove.isEmpty()) {
            Iterator iterator = paramsToRemove.values().iterator();
            while (iterator.hasNext()) {
                JSParameter[] type = (JSParameter[])iterator.next();
                if (!"arguments".equals(type)) continue;
                iterator.remove();
                break;
            }
        }
        List<Pair<Integer, String>> parametersToAdd = Collections.emptyList();
        if (matchingTagIndexes.size() < actualParameters.size()) {
            parametersToAdd = new ArrayList();
            for (JSParameter parameter : parameters) {
                String parameterName = parameter.getName();
                Integer tagIndex = (Integer)matchingTagIndexes.get(parameterName);
                if (tagIndex != null) continue;
                if (JSDestructuringUtil.isDestructuring(parameter.getParent())) {
                    JSDestructuringContext context2 = JSDestructuringContext.findDestructuringParents((PsiElement)parameter, JSDestructuringParameter.class::isInstance);
                    if (context2.getOuterElement() != null && tagsToParameters.getMatchedTags().containsValue((Object)context2.getOuterElement())) continue;
                }
                int insertionPlace = -1;
                int insertedParameterIndex = (Integer)actualParameters.get(parameterName);
                for (Map.Entry entry : matchingTagIndexes.entrySet()) {
                    if (insertedParameterIndex < (Integer)actualParameters.get(entry.getKey())) {
                        insertionPlace = insertionPlace == -1 ? (Integer)entry.getValue() : Math.min(insertionPlace, (Integer)entry.getValue());
                        continue;
                    }
                    if (insertedParameterIndex <= (Integer)actualParameters.get(entry.getKey())) continue;
                    insertionPlace = Math.max(insertionPlace, (Integer)entry.getValue() + 1);
                }
                parametersToAdd.add((Pair<Integer, String>)Pair.create((Object)(insertionPlace == -1 ? Integer.MAX_VALUE : insertionPlace), (Object)parameterName));
            }
        }
        if (parametersToAdd.isEmpty() && paramsToRemove.isEmpty()) {
            return null;
        }
        boolean hasParamTag = !tagsToParameters.isEmpty();
        return new JSDocParametersMappingToFunctionInfo(parametersToAdd, paramsToRemove, hasParamTag);
    }

    @NotNull
    public static JSTagToParameterMap getTagToParameterMap(@NotNull JSDocComment docComment, @NotNull JSFunction function, @Nullable Map<Integer, String> outTagNames) {
        if (docComment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(72);
        }
        if (function == null) {
            JSDocumentationUtils.$$$reportNull$$$0(73);
        }
        JSParameter[] parameters = function.getParameterVariables();
        HashMap<String, JSParameter> actualParameters = new HashMap<String, JSParameter>(parameters.length);
        for (JSParameter parameter : parameters) {
            actualParameters.put(parameter.getName(), parameter);
        }
        JSDocTag[] tags = docComment.getTags();
        Int2ObjectOpenHashMap matchedTags = new Int2ObjectOpenHashMap();
        Int2ObjectOpenHashMap unmatchedTags = new Int2ObjectOpenHashMap();
        int restIndex = -1;
        HashMap<String, JSDestructuringParameter> dummyNameToDestructuringParameter = new HashMap<String, JSDestructuringParameter>();
        JSParameterListElement[] parameterElements = function.getParameters();
        int destructuringParameterElement = 0;
        for (int i = 0; i < tags.length; ++i) {
            JSDocTag tag = tags[i];
            if (!tag.is(JSDocBlockTags.PARAM)) continue;
            String namepath = tag.getNamepathText();
            if (namepath == null || namepath.indexOf(46) < 0) {
                if (outTagNames != null) {
                    outTagNames.put(i, namepath);
                }
                if (actualParameters.containsKey(namepath)) {
                    JSParameter jsParameter = (JSParameter)actualParameters.get(namepath);
                    matchedTags.put(i, (Object)jsParameter);
                    JSDestructuringParameter destructuringParameter = JSDocumentationUtils.getOuterParameterForRestPropertyParameter(jsParameter);
                    if (destructuringParameter == null) continue;
                    dummyNameToDestructuringParameter.put(namepath, destructuringParameter);
                    continue;
                }
                boolean rest = false;
                String type = tag.getTypeText();
                if (type != null) {
                    JSParameterTypeDecorator parameterType = new JSTypeParser(docComment.getProject(), type, JSTypeSource.EMPTY).parseParameterType();
                    boolean bl = rest = parameterType != null && parameterType.isRest();
                }
                if (rest) {
                    restIndex = i;
                    continue;
                }
                boolean isDestructuring = false;
                while (destructuringParameterElement < parameterElements.length) {
                    if (parameterElements[destructuringParameterElement] instanceof JSDestructuringParameter) {
                        if (dummyNameToDestructuringParameter.containsKey(namepath)) {
                            ++destructuringParameterElement;
                            continue;
                        }
                        dummyNameToDestructuringParameter.put(namepath, (JSDestructuringParameter)parameterElements[destructuringParameterElement]);
                        matchedTags.put(i, (Object)parameterElements[destructuringParameterElement]);
                        isDestructuring = true;
                        ++destructuringParameterElement;
                        break;
                    }
                    ++destructuringParameterElement;
                }
                if (isDestructuring) continue;
                unmatchedTags.put(i, (Object)tags[i]);
                continue;
            }
            List<String> qName = JSQualifiedNameImpl.fromQualifiedName(namepath).toComponents();
            String outerName = (String)ContainerUtil.getFirstItem(qName);
            JSDestructuringParameter destructuringParameter = dummyNameToDestructuringParameter.getOrDefault(outerName, null);
            if (destructuringParameter == null) continue;
            JSElement target = destructuringParameter.getTarget();
            for (int componentIndex = 1; componentIndex < qName.size(); ++componentIndex) {
                JSDestructuringProperty property;
                if (!(target instanceof JSDestructuringObject) || (property = ((JSDestructuringObject)target).findProperty(qName.get(componentIndex))) == null) {
                    target = null;
                    break;
                }
                target = property.getDestructuringElement();
            }
            if (!(target instanceof JSParameter)) continue;
            matchedTags.put(i, (Object)((JSParameter)target));
        }
        return new JSTagToParameterMap((Int2ObjectMap<JSParameterListElement>)matchedTags, (Int2ObjectMap<JSDocTag>)unmatchedTags, restIndex);
    }

    @Nullable
    private static JSDestructuringParameter getOuterParameterForRestPropertyParameter(@NotNull JSParameter parameter) {
        PsiElement destructuringParameter;
        PsiElement grandParent;
        PsiElement parent;
        if (parameter == null) {
            JSDocumentationUtils.$$$reportNull$$$0(74);
        }
        if ((parent = parameter.getParent()) instanceof JSDestructuringProperty && ((JSDestructuringProperty)parent).isRest() && (grandParent = parent.getParent()) instanceof JSDestructuringObject && (destructuringParameter = grandParent.getParent()) instanceof JSDestructuringParameter) {
            return (JSDestructuringParameter)destructuringParameter;
        }
        return null;
    }

    public static JSContext findJSContext(@NotNull PsiElement element) {
        PsiComment comment;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(75);
        }
        if ((comment = JSDocumentationUtils.findDocComment(element)) instanceof JSDocComment) {
            return ((JSDocComment)comment).getJSContext();
        }
        return JSContext.UNKNOWN;
    }

    public static boolean isExtendedTypeName(CharSequence type) {
        return ourJSDocExtendedTypeNamePattern.matcher(type).matches();
    }

    @NotNull
    public static List<TextRange> getParameterNameRanges(int offset, @NotNull String text) {
        int tailStart;
        Matcher matcher;
        if (text == null) {
            JSDocumentationUtils.$$$reportNull$$$0(76);
        }
        if (!(matcher = ourJSDocParametersRestPattern.matcher(text)).matches() || matcher.groupCount() < 2) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                JSDocumentationUtils.$$$reportNull$$$0(77);
            }
            return list;
        }
        int start = matcher.start(2);
        int end = matcher.end(2);
        SmartList result2 = new SmartList();
        if (start >= 0 && end >= 0 && end > start) {
            result2.add(TextRange.create((int)start, (int)end).shiftRight(offset));
        }
        if ((tailStart = matcher.start(3)) != -1) {
            String tail = matcher.group(3);
            int currentStart = 0;
            while (currentStart < tail.length()) {
                int indexOfDot = tail.indexOf(46, currentStart);
                if (indexOfDot == -1) {
                    indexOfDot = tail.length();
                }
                if (currentStart < indexOfDot) {
                    result2.add(TextRange.create((int)currentStart, (int)indexOfDot).shiftRight(offset + tailStart));
                }
                currentStart = indexOfDot + 1;
            }
        }
        SmartList smartList = result2;
        if (smartList == null) {
            JSDocumentationUtils.$$$reportNull$$$0(78);
        }
        return smartList;
    }

    @Nullable
    public static JSNamespace getNamespaceFromJSDoc(@NotNull JSNamedElement element) {
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(79);
        }
        if (DialectDetector.isJavaScript((PsiElement)element)) {
            return JSDocumentationUtils.getNamespaceFromJSDoc(JSDocumentationUtils.findDocComment((PsiElement)element));
        }
        return null;
    }

    @Nullable
    public static JSNamespace getNamespaceFromJSDoc(@Nullable PsiComment docComment) {
        JSDocComment jsDocComment;
        if (docComment instanceof JSDocComment && ((jsDocComment = (JSDocComment)docComment).getExplicitName() != null || jsDocComment.isNamespaceExplicitlyDeclared())) {
            return JSNamedTypeFactory.createNamespace(jsDocComment.getNamespace(), JSTypeSourceFactory.createTypeSource((PsiElement)jsDocComment, true), JSTypeContext.fromJSContext(jsDocComment.getJSContext()), false);
        }
        return null;
    }

    @Contract(value="!null->!null")
    public static PsiElement getOriginalElementOrParentIfLeaf(@Nullable PsiElement originalElement) {
        if (originalElement instanceof LeafPsiElement) {
            PsiFile file = originalElement.getContainingFile();
            int offset = ((LeafPsiElement)originalElement).getStartOffset();
            PsiElement candidate = originalElement;
            ASTNode node = originalElement.getNode();
            if (offset > 0 && !JSDocumentationUtils.isIdentifier(node) && (candidate = file.findElementAt(offset - 1)) != null) {
                node = candidate.getNode();
            }
            if (candidate != null && JSDocumentationUtils.isIdentifier(node)) {
                return candidate.getParent();
            }
        }
        return originalElement;
    }

    private static boolean isIdentifier(@NotNull ASTNode node) {
        if (node == null) {
            JSDocumentationUtils.$$$reportNull$$$0(80);
        }
        return JSKeywordSets.IDENTIFIER_NAMES.contains(node.getElementType());
    }

    @NotNull
    private static String getIndentation(@NotNull StringBuilder builder2) {
        if (builder2 == null) {
            JSDocumentationUtils.$$$reportNull$$$0(81);
        }
        int lastNewLineStart = StringsKt.lastIndexOf((CharSequence)builder2, (char)'\n', (int)(builder2.length() - 1), (boolean)false) + 1;
        String string = StringsKt.takeWhile((CharSequence)new CharSequenceSubSequence((CharSequence)builder2, lastNewLineStart, builder2.length()), ch -> Character.isWhitespace(ch.charValue())).toString();
        if (string == null) {
            JSDocumentationUtils.$$$reportNull$$$0(82);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8, 20, 21, 22, 23, 30, 33, 50, 51, 54, 55, 59, 68, 77, 78, 82 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_initialComment";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 62: 
            case 75: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 30: 
            case 33: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 59: 
            case 68: 
            case 77: 
            case 78: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSDocumentationUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eolComment";
                break;
            }
            case 12: 
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 26: 
            case 41: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 28: 
            case 29: 
            case 61: 
            case 70: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 37: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 38: 
            case 39: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrl";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFQN";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libUrl";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiComment";
                break;
            }
            case 56: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namepath";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitElementParent";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocumentationUtils";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDescription";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "transformInlineTag";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findAttributeListAnchor";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "skipOuterElements";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementOverAssignmentParent";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibDocRelativeUrl";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "isClassOrInterface";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "appendPrefixToName";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomLibraries";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterNameRanges";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processDocumentationTextFromComment";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildDescription";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 30: 
            case 33: 
            case 50: 
            case 51: 
            case 54: 
            case 55: 
            case 59: 
            case 68: 
            case 77: 
            case 78: 
            case 82: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "transformInlineTag";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNextJSDocTag";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousJSDocTag";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildDocCommentFromEolComment";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findTrailingCommentInFunctionBody";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findLeadingCommentInFunctionBody";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findTypeFromInlineComment";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findOwnDocComment";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasSingleVariable";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findScopeComment";
                break;
            }
            case 18: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findDocComment";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findAttributeListAnchor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findDocCommentNoCache";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isSelfSufficientComment";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "searchPreviousNonDocComment";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findPreviousJSDocComment";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "skipOuterElements";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getParentToSearchDocComment";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getElementOverAssignmentParent";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedElement";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createOrUpdateTagsInDocComment";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createOrUpdateTagsWithInsertionIndexes";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNameFromExprStatement";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypeFromPrecedingComment";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findPossiblyRelatedCommentForArrowFunctionParam";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getReasonablePrevElement";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromComment";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "calculateDeprecated";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getDeprecationMessage";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getSinceMessage";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "calculateConst";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findFunctionAppliedTo";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "tryCreateTypeFromComment";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getLibDocRelativeUrl";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getBaseKey";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findAssociatedElement";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "findNextNamepathSeparator";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "appendPrefixToName";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "findLastNamepathPartOffset";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "mayRelateTo";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "moveJSDoc";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "copyJSDocComment";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "addNewLineBeforeIfNoNewlineNow";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "findOwnDocCommentForImplicitElement";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getDomLibraries";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isFromCoreLibFile";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "checkDocCommentMatchesFunctionSignature";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getTagToParameterMap";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getOuterParameterForRestPropertyParameter";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "findJSContext";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getParameterNameRanges";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceFromJSDoc";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifier";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getIndentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8, 20, 21, 22, 23, 30, 33, 50, 51, 54, 55, 59, 68, 77, 78, 82 -> new IllegalStateException(string);
        };
    }

    private static final class JSDocReplacingDescriptionProcessor
    implements JSDocDescriptionProcessor {
        private final JSDocDescriptionProcessor myOriginal;
        private final String myPattern;
        private final String myReplacement;

        JSDocReplacingDescriptionProcessor(@NotNull JSDocDescriptionProcessor original, @NotNull String pattern, @NotNull String replacement) {
            if (original == null) {
                JSDocReplacingDescriptionProcessor.$$$reportNull$$$0(0);
            }
            if (pattern == null) {
                JSDocReplacingDescriptionProcessor.$$$reportNull$$$0(1);
            }
            if (replacement == null) {
                JSDocReplacingDescriptionProcessor.$$$reportNull$$$0(2);
            }
            this.myOriginal = original;
            this.myPattern = pattern;
            this.myReplacement = replacement;
        }

        @Override
        @NotNull
        public String transformInlineTag(@NotNull JSDocInlineTag tag) {
            if (tag == null) {
                JSDocReplacingDescriptionProcessor.$$$reportNull$$$0(3);
            }
            String string = this.myOriginal.transformInlineTag(tag);
            if (string == null) {
                JSDocReplacingDescriptionProcessor.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public String transformPreContent(@NotNull String pre, @NotNull String content, @NotNull String indentation) {
            if (pre == null) {
                JSDocReplacingDescriptionProcessor.$$$reportNull$$$0(5);
            }
            if (content == null) {
                JSDocReplacingDescriptionProcessor.$$$reportNull$$$0(6);
            }
            if (indentation == null) {
                JSDocReplacingDescriptionProcessor.$$$reportNull$$$0(7);
            }
            String string = this.myOriginal.transformPreContent(pre, content.replace(this.myPattern, this.myReplacement), indentation);
            if (string == null) {
                JSDocReplacingDescriptionProcessor.$$$reportNull$$$0(8);
            }
            return string;
        }

        @Override
        @NotNull
        public String transformText(@NotNull String text) {
            if (text == null) {
                JSDocReplacingDescriptionProcessor.$$$reportNull$$$0(9);
            }
            String string = this.myOriginal.transformText(text.replace(this.myPattern, this.myReplacement));
            if (string == null) {
                JSDocReplacingDescriptionProcessor.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 8, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 4: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/documentation/JSDocumentationUtils$JSDocReplacingDescriptionProcessor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pre";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indentation";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocumentationUtils$JSDocReplacingDescriptionProcessor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "transformInlineTag";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "transformPreContent";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "transformText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "transformInlineTag";
                    break;
                }
                case 4: 
                case 8: 
                case 10: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "transformPreContent";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "transformText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 8, 10 -> new IllegalStateException(string);
            };
        }
    }

    public static final class JSTagToParameterMap {
        private final Int2ObjectMap<JSParameterListElement> myMatchedTags;
        private final Int2ObjectMap<JSDocTag> myNonMatchedTags;
        private final int myRestDocTagIndex;

        public JSTagToParameterMap(@NotNull Int2ObjectMap<JSParameterListElement> matchedTags, @NotNull Int2ObjectMap<JSDocTag> nonMatchedTags, int restDocTagIndex) {
            if (matchedTags == null) {
                JSTagToParameterMap.$$$reportNull$$$0(0);
            }
            if (nonMatchedTags == null) {
                JSTagToParameterMap.$$$reportNull$$$0(1);
            }
            this.myMatchedTags = matchedTags;
            this.myNonMatchedTags = nonMatchedTags;
            this.myRestDocTagIndex = restDocTagIndex;
        }

        public Int2ObjectMap<JSParameterListElement> getMatchedTags() {
            return this.myMatchedTags;
        }

        public Int2ObjectMap<JSDocTag> getNonMatchedTags() {
            return this.myNonMatchedTags;
        }

        public int getRestDocTagIndex() {
            return this.myRestDocTagIndex;
        }

        public int getTagForParameter(@NotNull JSParameterListElement parameter) {
            if (parameter == null) {
                JSTagToParameterMap.$$$reportNull$$$0(2);
            }
            for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(this.myMatchedTags)) {
                JSParameterListElement element = (JSParameterListElement)entry.getValue();
                if (!parameter.equals(element) && (!(element instanceof JSParameter) || !parameter.equals(JSDocumentationUtils.getOuterParameterForRestPropertyParameter((JSParameter)element)))) continue;
                return entry.getIntKey();
            }
            return -1;
        }

        public boolean isEmpty() {
            return this.myMatchedTags.isEmpty() && this.myNonMatchedTags.isEmpty() && this.myRestDocTagIndex == -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchedTags";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nonMatchedTags";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocumentationUtils$JSTagToParameterMap";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTagForParameter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class JSDocParametersMappingToFunctionInfo {
        private final List<Pair<Integer, String>> myParamsToAdd;
        private final Map<Integer, String> myParamsToRemove;
        private final boolean myHasParamTag;

        public JSDocParametersMappingToFunctionInfo(List<Pair<Integer, String>> paramsToAdd, Map<Integer, String> paramsToRemove, boolean hasParamTag) {
            this.myParamsToAdd = paramsToAdd;
            this.myParamsToRemove = paramsToRemove;
            this.myHasParamTag = hasParamTag;
        }

        public List<Pair<Integer, String>> getParamsToAdd() {
            return this.myParamsToAdd;
        }

        public Map<Integer, String> getParamsToRemove() {
            return this.myParamsToRemove;
        }

        public boolean hasParamTag() {
            return this.myHasParamTag;
        }
    }
}

