/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules.resolver;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.reference.NodePathManager;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.config.JSImportResolveContext;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSParsedPathElement;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSSimpleFileReferenceRootsProvider;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsRegistry;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsService;
import com.intellij.lang.javascript.library.typings.TypeScriptPackageName;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.typescript.library.download.TypeScriptDefinitionFilesDirectory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\bH\u0002J6\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J&\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSDefaultFileReferenceRootsProvider;", "Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSSimpleFileReferenceRootsProvider;", "resolveContext", "Lcom/intellij/lang/javascript/config/JSImportResolveContext;", "<init>", "(Lcom/intellij/lang/javascript/config/JSImportResolveContext;)V", "getDefaultRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "moduleName", "", "contextFile", "fillExternalDefinitionsContexts", "", "path", "result", "", "getContextDirectory", "fillGlobalTypesContexts", "containingDirectory", "isUrlEncoded", "", "addDefaultRoots", "intellij.javascript.impl"})
public final class JSDefaultFileReferenceRootsProvider
extends JSSimpleFileReferenceRootsProvider {
    public JSDefaultFileReferenceRootsProvider(@NotNull JSImportResolveContext resolveContext) {
        Intrinsics.checkNotNullParameter((Object)resolveContext, (String)"resolveContext");
        super(resolveContext);
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getDefaultRoots(@NotNull Project project, @NotNull String moduleName, @NotNull VirtualFile contextFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        VirtualFile virtualFile = this.getContextDirectory(project, contextFile);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile containingDirectory = virtualFile;
        if (JSFileReferencesUtil.isRelative(moduleName)) {
            return CollectionsKt.listOf((Object)containingDirectory);
        }
        LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
        Collection<VirtualFile> nodeModules = this.getNodeModulesContexts(project, containingDirectory);
        result2.addAll(this.getNodeModulesTypesDirectories(nodeModules));
        this.fillExternalDefinitionsContexts(project, moduleName, (Collection<VirtualFile>)result2);
        this.fillGlobalTypesContexts(project, containingDirectory, moduleName, (Collection<VirtualFile>)result2, this.getResolveContext().isUrlEncoded());
        result2.addAll(this.collectNodeResolverRoots(project, moduleName, containingDirectory));
        this.addDefaultRoots(project, containingDirectory, (Collection<VirtualFile>)result2);
        result2.addAll(JSAmdUtil.getBaseDirectories(moduleName, project, ProjectScope.getProjectScope((Project)project), containingDirectory));
        return result2;
    }

    private final void fillExternalDefinitionsContexts(Project project, String path2, Collection<VirtualFile> result2) {
        String string = NodeModuleSearchUtil.extractDependencyName(path2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extractDependencyName(...)");
        String refText = string;
        TypeScriptPackageName typeScriptPackageName = TypeScriptExternalDefinitionsService.Companion.getInstance(project).resolveCachedExternalDefinitionForPackage(refText);
        if (typeScriptPackageName == null) {
            return;
        }
        TypeScriptPackageName packageName = typeScriptPackageName;
        String string2 = TypeScriptExternalDefinitionsRegistry.Companion.getExactModuleTypingsPath$default(TypeScriptExternalDefinitionsRegistry.Companion, packageName, null, 2, null);
        if (string2 == null) {
            return;
        }
        String typingsModulePath = string2;
        VirtualFile typingsModule = LocalFileSystem.getInstance().findFileByPath(typingsModulePath);
        if (typingsModule == null || !typingsModule.isValid()) {
            return;
        }
        if (ProjectFileIndex.getInstance((Project)project).isInLibrary(typingsModule)) {
            VirtualFile typesDir = typingsModule.getParent();
            if (typesDir == null || !typesDir.isValid() || !NodeModuleUtil.isTypesDir(typesDir)) {
                return;
            }
            result2.add(typesDir);
        }
    }

    private final VirtualFile getContextDirectory(Project project, VirtualFile contextFile) {
        VirtualFile virtualFile = contextFile instanceof VirtualFileWindow ? ((VirtualFileWindow)contextFile).getDelegate() : contextFile;
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile realContextFile = virtualFile;
        return ScratchUtil.isScratch((VirtualFile)realContextFile) ? ProjectUtil.guessProjectDir((Project)project) : realContextFile.getParent();
    }

    private final void fillGlobalTypesContexts(Project project, VirtualFile containingDirectory, String path2, Collection<VirtualFile> result2, boolean isUrlEncoded) {
        JSParsedPathElement[] elements = JSParsedPathElement.Parser.parseReferenceText(path2, isUrlEncoded);
        if (elements.length == 0) {
            return;
        }
        String firstRefText = elements[0].getText();
        if (StringUtil.isEmpty((String)firstRefText)) {
            return;
        }
        VirtualFile directory = TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectory();
        if (directory == null || !directory.isValid()) {
            return;
        }
        VirtualFile virtualFile = directory.findChild(firstRefText);
        if (virtualFile == null) {
            return;
        }
        VirtualFile child = virtualFile;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex index = projectFileIndex;
        if (VfsUtilCore.isAncestor((VirtualFile)directory, (VirtualFile)containingDirectory, (boolean)false) || index.isInLibrary(child)) {
            result2.add(directory);
        }
    }

    private final void addDefaultRoots(Project project, VirtualFile containingDirectory, Collection<VirtualFile> result2) {
        ModuleRootManager rootManager;
        WebResourcesPathsConfiguration configuration = WebResourcesPathsConfiguration.getInstance((Project)project);
        if (configuration != null) {
            List list = configuration.getResourceDirectories();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResourceDirectories(...)");
            result2.addAll(list);
        }
        List<VirtualFile> list = new NodePathManager(project).getNodePaths(containingDirectory);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getNodePaths(...)");
        result2.addAll((Collection<VirtualFile>)list);
        if (!this.getResolveContext().hasSourceRootsContext()) {
            return;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        Module module = projectFileIndex2.getModuleForFile(containingDirectory);
        if (module != null && (rootManager = ModuleRootManager.getInstance((Module)module)) != null) {
            VirtualFile[] virtualFileArray = rootManager.getSourceRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSourceRoots(...)");
            VirtualFile[] roots = virtualFileArray;
            if (!(roots.length == 0)) {
                for (VirtualFile root : roots) {
                    if (!root.isDirectory()) continue;
                    ContainerUtil.addIfNotNull(result2, (Object)root);
                }
                return;
            }
        }
        ProjectFileIndex projectFileIndex3 = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex3, (String)"getFileIndex(...)");
        ProjectFileIndex index = projectFileIndex3;
        VirtualFile contentRoot = index.getContentRootForFile(containingDirectory);
        ContainerUtil.addIfNotNull(result2, (Object)contentRoot);
    }
}

