/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSHighlightDescriptor;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlighter;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.text.Strings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public enum TypeScriptHighlightDescriptor implements JSHighlightDescriptor
{
    MODULE_NAME("typescript.module.name"),
    ENUM("typescript.enum.name"),
    ENUM_MEMBER("typescript.enum.member.name"),
    TYPE_PARAMETER("typescript.type.parameter");

    @NotNull
    @PropertyKey(resourceBundle="messages.JavaScriptBundle")
    private final @NotNull @PropertyKey(resourceBundle="messages.JavaScriptBundle") String myMessageKey;

    private TypeScriptHighlightDescriptor(String messageKey) {
        if (messageKey == null) {
            TypeScriptHighlightDescriptor.$$$reportNull$$$0(0);
        }
        this.myMessageKey = messageKey;
    }

    @NotNull
    public TextAttributesKey getOrCreateTextAttributesKey() {
        String externalName = "TS." + this;
        TextAttributesKey baseKey = this.getBaseKey();
        TextAttributesKey textAttributesKey = baseKey != null ? TextAttributesKey.createTextAttributesKey((String)externalName, (TextAttributesKey)baseKey) : TextAttributesKey.createTextAttributesKey((String)externalName);
        if (textAttributesKey == null) {
            TypeScriptHighlightDescriptor.$$$reportNull$$$0(1);
        }
        return textAttributesKey;
    }

    @Nullable
    private TextAttributesKey getBaseKey() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case MODULE_NAME -> DefaultLanguageHighlighterColors.IDENTIFIER;
            case ENUM -> TypeScriptHighlighter.TS_CLASS;
            case ENUM_MEMBER -> TypeScriptHighlighter.TS_STATIC_MEMBER_VARIABLE;
            case TYPE_PARAMETER -> null;
        };
    }

    @Override
    @NotNull
    public String getDebugName() {
        String string = Strings.toLowerCase((String)JavaScriptBundle.message(this.myMessageKey, new Object[0]));
        if (string == null) {
            TypeScriptHighlightDescriptor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public TextAttributesKey getAttributesKey(@NotNull JSHighlighter highlighter) {
        if (highlighter == null) {
            TypeScriptHighlightDescriptor.$$$reportNull$$$0(3);
        }
        TextAttributesKey textAttributesKey = highlighter.getMappedKey(this.getOrCreateTextAttributesKey());
        if (textAttributesKey == null) {
            TypeScriptHighlightDescriptor.$$$reportNull$$$0(4);
        }
        return textAttributesKey;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageKey";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/TypeScriptHighlightDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/TypeScriptHighlightDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateTextAttributesKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributesKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4 -> new IllegalStateException(string);
        };
    }
}

