/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.inspections.JSDeclarationsAtScopeStartInspection;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSMoveToScopeStartIntentionAction
implements LocalQuickFix {
    private final boolean myMakeSingleVarStatement;
    @NonNls
    private static final String VAR_STATEMENT_START = "var ";

    public JSMoveToScopeStartIntentionAction(boolean makeSingleVarStatement) {
        this.myMakeSingleVarStatement = makeSingleVarStatement;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.move.to.scope.start", new Object[0]);
        if (string == null) {
            JSMoveToScopeStartIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            JSMoveToScopeStartIntentionAction.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            JSMoveToScopeStartIntentionAction.$$$reportNull$$$0(2);
        }
        JSVarStatement varStatement = (JSVarStatement)descriptor.getPsiElement();
        PsiFile file = varStatement.getContainingFile();
        StringBuilder assignments = new StringBuilder();
        Document document = file.getViewProvider().getDocument();
        if (document == null) {
            return;
        }
        JSVariable previousVar = null;
        for (JSVariable jsVariable : varStatement.getVariables()) {
            if (jsVariable.hasInitializer()) {
                if (previousVar != null) {
                    assignments.append(document.getText(new TextRange(previousVar.getTextRange().getEndOffset(), jsVariable.getTextRange().getStartOffset())));
                }
                assignments.append(jsVariable.getText());
            }
            previousVar = jsVariable;
        }
        if (varStatement.getNode().findChildByType(JSTokenTypes.SEMICOLON) != null && assignments.length() > 0) {
            assignments.append(";");
        }
        JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)varStatement, JSFunction.class);
        JSStatement anchor = JSDeclarationsAtScopeStartInspection.findContainingFunctionFirstStatement((PsiElement)varStatement);
        if (anchor == null) {
            return;
        }
        StringBuilder declarations = this.myMakeSingleVarStatement && anchor instanceof JSVarStatement ? JSMoveToScopeStartIntentionAction.buildDeclarations(", ", varStatement) : JSMoveToScopeStartIntentionAction.buildDeclarations(VAR_STATEMENT_START, varStatement);
        if (assignments.length() > 0) {
            document.replaceString(varStatement.getTextRange().getStartOffset(), varStatement.getTextRange().getEndOffset(), (CharSequence)assignments);
        } else {
            FormatFixer ff = FormatFixer.create((PsiElement)varStatement, FormatFixer.Mode.FirstLinebreak);
            varStatement.delete();
            ff.fixFormat();
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        anchor = JSDeclarationsAtScopeStartInspection.findContainingFunctionFirstStatement(function);
        if (this.myMakeSingleVarStatement && anchor instanceof JSVarStatement) {
            JSVarStatement firstVarStatement = (JSVarStatement)anchor;
            JSVariable[] variables = firstVarStatement.getVariables();
            JSVariable lastVar = variables[variables.length - 1];
            int endOffset = lastVar.getTextRange().getEndOffset();
            document.insertString(endOffset, (CharSequence)declarations);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        } else if (anchor != null) {
            declarations.append(";\n");
            JSStatement varStatementNode = JSPsiElementFactory.createJSStatement(declarations.toString(), (PsiElement)anchor);
            anchor.getParent().addBefore((PsiElement)varStatementNode, (PsiElement)anchor);
        }
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
    }

    private static StringBuilder buildDeclarations(String prefix, JSVarStatement varStatement) {
        StringBuilder declarations = new StringBuilder(prefix);
        boolean firstVar = true;
        for (JSVariable jsVariable : varStatement.getVariables()) {
            String typeString;
            if (!firstVar) {
                declarations.append(", ");
            } else {
                firstVar = false;
            }
            declarations.append(jsVariable.getName());
            if (!DialectDetector.hasFeature((PsiElement)jsVariable, JSLanguageFeature.TYPES)) continue;
            JSType type = jsVariable.getJSType();
            String string = typeString = type == null ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
            if (typeString == null) continue;
            declarations.append(":").append(typeString);
        }
        return declarations;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSMoveToScopeStartIntentionAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMoveToScopeStartIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

