/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class JSPotentiallyInvalidUsageOfThisInspection
extends JSInspection {
    @Override
    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSPotentiallyInvalidUsageOfThisInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSPotentiallyInvalidUsageOfThisInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){
            private final Set<JSThisExpression> processedExpressions = new HashSet<JSThisExpression>();

            @Override
            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.process(node);
            }

            @Override
            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                PsiElement parent;
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((parent = JSResolveUtil.findParent(node)) instanceof JSClass) {
                    return;
                }
                this.process(node);
            }

            private void process(final @NotNull JSFunction function) {
                if (function == null) {
                    1.$$$reportNull$$$0(2);
                }
                final Set<String> referencedFields = JSPotentiallyInvalidUsageOfThisInspection.getReferencedFields(function);
                function.acceptChildren(new JSRecursiveElementVisitor(){
                    JSFunction fun;
                    boolean sameThis;
                    boolean myThisTypeExplicitlyDeclared;
                    {
                        this.fun = function;
                    }

                    @Override
                    public void visitJSThisExpression(@NotNull JSThisExpression node) {
                        if (node == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (this.fun != function && !this.sameThis && !this.myThisTypeExplicitlyDeclared && JSPotentiallyInvalidUsageOfThisInspection.shouldReportThis(node, referencedFields, function) && processedExpressions.add(node)) {
                            holder.registerProblem((PsiElement)node, JavaScriptBundle.message("javascript.potentially.invalid.usage.of.this", new Object[0]), new LocalQuickFix[0]);
                        }
                    }

                    @Override
                    public boolean visitAsFunction(@NotNull JSFunction function2) {
                        if (function2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        this.proceedFun(function2);
                        return true;
                    }

                    private void proceedFun(JSFunction node) {
                        JSFunction prev = this.fun;
                        boolean sameThisSave = this.sameThis;
                        boolean _thisTypeExplicitlyDeclared = this.myThisTypeExplicitlyDeclared;
                        this.fun = node;
                        this.sameThis = JSPotentiallyInvalidUsageOfThisInspection.isSameThisAsBefore(node);
                        this.myThisTypeExplicitlyDeclared = JSPotentiallyInvalidUsageOfThisInspection.isThisTypeExplicitlyDeclared(node);
                        super.visitJSElement(node);
                        this.fun = prev;
                        this.sameThis = sameThisSave;
                        this.myThisTypeExplicitlyDeclared = _thisTypeExplicitlyDeclared;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "node";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "function";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfThisInspection$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitJSThisExpression";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitAsFunction";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "function";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfThisInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isThisTypeExplicitlyDeclared(@NotNull JSFunction node) {
        if (node == null) {
            JSPotentiallyInvalidUsageOfThisInspection.$$$reportNull$$$0(2);
        }
        return JSDocumentationUtils.findContextType(node) != null || TypeScriptPsiUtil.getThisParameter(node) != null;
    }

    private static boolean shouldReportThis(@NotNull JSThisExpression node, @NotNull Set<String> referencedFields, @NotNull JSFunction outerFunction) {
        PsiElement parent;
        if (node == null) {
            JSPotentiallyInvalidUsageOfThisInspection.$$$reportNull$$$0(3);
        }
        if (referencedFields == null) {
            JSPotentiallyInvalidUsageOfThisInspection.$$$reportNull$$$0(4);
        }
        if (outerFunction == null) {
            JSPotentiallyInvalidUsageOfThisInspection.$$$reportNull$$$0(5);
        }
        if (!((parent = node.getParent()) instanceof JSReferenceExpression)) {
            return false;
        }
        String referencedName = ((JSReferenceExpression)parent).getReferenceName();
        boolean referenceInClass = referencedName != null && referencedFields.contains(referencedName);
        JSQualifiedNameImpl outerFunctionQName = JSQualifiedNameImpl.fromQualifiedNamedElement(outerFunction);
        if (!referenceInClass) {
            PsiElement resolve2 = ((JSReferenceExpression)parent).resolve();
            boolean bl = referenceInClass = resolve2 instanceof JSPsiElementBase && outerFunctionQName != null && outerFunctionQName.equals(((JSPsiElementBase)resolve2).getNamespace());
        }
        if (!referenceInClass) {
            return false;
        }
        JSNamespace result2 = JSContextResolver.resolveContext((PsiElement)node);
        boolean sameThisReportedByContextResolver = result2 != null && outerFunctionQName != null && outerFunctionQName.equals(result2.getQualifiedName());
        return !sameThisReportedByContextResolver;
    }

    @NotNull
    private static Set<String> getReferencedFields(@NotNull JSFunction function) {
        if (function == null) {
            JSPotentiallyInvalidUsageOfThisInspection.$$$reportNull$$$0(6);
        }
        HashSet<String> referencedFields = new HashSet<String>();
        ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)function).forceIgnore(e -> e instanceof JSFunction && !((JSFunction)e).isArrowFunction())).filter(JSThisExpression.class).forEach(node -> {
            String referencedName;
            PsiElement parent = node.getParent();
            if (parent instanceof JSReferenceExpression && (referencedName = ((JSReferenceExpression)parent).getReferenceName()) != null) {
                referencedFields.add(referencedName);
            }
        });
        HashSet<String> hashSet = referencedFields;
        if (hashSet == null) {
            JSPotentiallyInvalidUsageOfThisInspection.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    static boolean isSameThisAsBefore(@NotNull JSFunction node) {
        PsiElement containingFile2;
        if (node == null) {
            JSPotentiallyInvalidUsageOfThisInspection.$$$reportNull$$$0(8);
        }
        PsiElement parent = JSPsiImplUtils.getNonParenthesizeParent(node);
        if (node.isArrowFunction()) {
            return true;
        }
        if (parent instanceof JSAssignmentExpression) {
            JSExpression lOperand = ((JSAssignmentExpression)parent).getLOperand();
            if (lOperand instanceof JSDefinitionExpression) {
                lOperand = ((JSDefinitionExpression)lOperand).getExpression();
            }
            return lOperand instanceof JSReferenceExpression && ((JSReferenceExpression)lOperand).getQualifier() instanceof JSThisExpression;
        }
        if (parent instanceof JSArgumentList) {
            JSExpression methodExpression;
            PsiElement grandParent;
            JSExpression[] arguments = ((JSArgumentList)parent).getArguments();
            PsiFile containingFile2 = node.getContainingFile();
            for (int i = 0; i < arguments.length; ++i) {
                JSExpression initializer;
                PsiElement resolve2;
                if (arguments[i] != node) continue;
                if (i + 1 >= arguments.length) break;
                JSExpression argument = arguments[i + 1];
                if (argument instanceof JSReferenceExpression && (resolve2 = ((JSReferenceExpression)argument).resolve()) instanceof JSVariable && resolve2.getContainingFile() == containingFile2 && (initializer = ((JSVariable)resolve2).getInitializer()) != null) {
                    argument = initializer;
                }
                if (!(argument instanceof JSThisExpression)) break;
                return true;
            }
            return (grandParent = parent.getParent()) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)grandParent).getMethodExpression()) instanceof JSReferenceExpression && ((JSReferenceExpression)methodExpression).getQualifier() instanceof JSThisExpression;
        }
        if (parent instanceof JSReferenceExpression && (containingFile2 = parent.getParent()) instanceof JSCallExpression) {
            JSExpression[] arguments;
            JSCallExpression callExpression = (JSCallExpression)containingFile2;
            String name = ((JSReferenceExpression)parent).getReferenceName();
            if ("bind".equals(name) && (arguments = callExpression.getArguments()).length == 1 && arguments[0] instanceof JSThisExpression) {
                return true;
            }
            JSType exprType = JSResolveUtil.getExpressionJSType(callExpression);
            List<JSType> types = exprType instanceof JSUnionType ? ((JSUnionType)exprType).getTypes() : Collections.singletonList(exprType);
            JSNamespace outerThisType = JSContextResolver.resolveContext(parent);
            for (JSType type : types) {
                JSType thisType;
                if (!(type instanceof JSFunctionTypeImpl) || (thisType = ((JSFunctionTypeImpl)type).getThisType()) == null || outerThisType == null || !StringUtil.equals((CharSequence)thisType.getResolvedTypeText(), (CharSequence)outerThisType.getResolvedTypeText())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedFields";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerFunction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfThisInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfThisInspection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isThisTypeExplicitlyDeclared";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldReportThis";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedFields";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSameThisAsBefore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

