/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.option.OptionEnumType;
import com.intellij.lang.javascript.linter.option.OptionEnumVariant;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSHintUtil {
    public static final OptionEnumType QUOTMARK_TYPE = new OptionEnumType(Arrays.asList(new OptionEnumVariant(false, JavaScriptBundle.messagePointer("jshint.quotmark.false.text", new Object[0])), new OptionEnumVariant(true, JavaScriptBundle.messagePointer("jshint.quotmark.true.text", new Object[0])), new OptionEnumVariant("single", JavaScriptBundle.messagePointer("jshint.quotmark.single.text", new Object[0])), new OptionEnumVariant("double", JavaScriptBundle.messagePointer("jshint.quotmark.double.text", new Object[0]))));
    public static final OptionEnumType UNUSED_TYPE = new OptionEnumType(Arrays.asList(new OptionEnumVariant(false, JavaScriptBundle.messagePointer("jshint.unused.false.text", new Object[0])), new OptionEnumVariant(true, JavaScriptBundle.messagePointer("jshint.unused.true.text", new Object[0])), new OptionEnumVariant("vars", JavaScriptBundle.messagePointer("jshint.unused.vars.text", new Object[0])), new OptionEnumVariant("strict", JavaScriptBundle.messagePointer("jshint.unused.strict.text", new Object[0]))));
    public static final OptionEnumType LATEDEF_TYPE = new OptionEnumType(Arrays.asList(new OptionEnumVariant(false, JavaScriptBundle.messagePointer("jshint.latedef.false.text", new Object[0])), new OptionEnumVariant(true, JavaScriptBundle.messagePointer("jshint.latedef.true.text", new Object[0])), new OptionEnumVariant("nofunc", JavaScriptBundle.messagePointer("jshint.latedef.nofunc.text", new Object[0]))));

    private JSHintUtil() {
    }

    @Nullable
    public static <T> T cast(@Nullable Object obj, @NotNull Class<T> clazz) {
        if (clazz == null) {
            JSHintUtil.$$$reportNull$$$0(0);
        }
        if (obj == null) {
            return null;
        }
        if (clazz.isInstance(obj)) {
            return clazz.cast(obj);
        }
        throw new ClassCastException("Expected type: " + clazz.getName() + ", actual: " + obj.getClass().getName());
    }

    @Nullable
    public static Integer castToInteger(@Nullable Object obj) {
        return JSHintUtil.cast(obj, Integer.class);
    }

    @Nullable
    public static String castToString(@Nullable Object obj) {
        return JSHintUtil.cast(obj, String.class);
    }

    public static JEditorPane createReadonlyBrowser(@NotNull String type, @NotNull @Nls String text) {
        if (type == null) {
            JSHintUtil.$$$reportNull$$$0(1);
        }
        if (text == null) {
            JSHintUtil.$$$reportNull$$$0(2);
        }
        final JEditorPane browser = new JEditorPane(type, text);
        browser.setEditable(false);
        UIUtil.doNotScrollToCaret((JTextComponent)browser);
        browser.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 40) {
                    JSHintUtil.handleArrow(browser, true, true);
                } else if (keyCode == 38) {
                    JSHintUtil.handleArrow(browser, true, false);
                } else if (keyCode == 37) {
                    JSHintUtil.handleArrow(browser, false, false);
                } else if (keyCode == 39) {
                    JSHintUtil.handleArrow(browser, false, true);
                }
            }
        });
        return browser;
    }

    private static void handleArrow(@NotNull JEditorPane browser, boolean vertical, boolean downRight) {
        if (browser == null) {
            JSHintUtil.$$$reportNull$$$0(3);
        }
        Rectangle visibleRect = browser.getVisibleRect();
        int direction = downRight ? 1 : -1;
        int unit = browser.getScrollableUnitIncrement(visibleRect, vertical ? 1 : 0, direction);
        Rectangle newVisibleRect = new Rectangle(visibleRect);
        if (vertical) {
            newVisibleRect.y += unit * direction;
        } else {
            newVisibleRect.x += unit * direction;
        }
        browser.scrollRectToVisible(newVisibleRect);
    }

    @NotNull
    public static JComponent createIOExceptionBalloonComponent(@NotNull String text, final @NotNull Runnable retryCallback, boolean addConfigureHttpProxyLink) {
        if (text == null) {
            JSHintUtil.$$$reportNull$$$0(4);
        }
        if (retryCallback == null) {
            JSHintUtil.$$$reportNull$$$0(5);
        }
        JTextPane messageComponent = new JTextPane();
        messageComponent.setFont(StartupUiUtil.getLabelFont());
        HTMLEditorKit editorKit = new HTMLEditorKit();
        editorKit.getStyleSheet().addRule(UIUtil.displayPropertiesToCSS((Font)StartupUiUtil.getLabelFont(), (Color)UIUtil.getLabelForeground()));
        messageComponent.setEditorKit(editorKit);
        messageComponent.setContentType("text/html");
        String retry = "retry";
        String proxy = "proxy";
        messageComponent.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            public void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ("retry".equals(e.getDescription())) {
                    retryCallback.run();
                } else if ("proxy".equals(e.getDescription())) {
                    HttpConfigurable.editConfigurable(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/linter/jshint/JSHintUtil$2", "hyperlinkActivated"));
            }
        });
        @Nls StringBuilder html = new StringBuilder("<html><body>").append(text).append("<br/>");
        if (addConfigureHttpProxyLink) {
            html.append(JavaScriptBundle.message("jshint.exception.balloon.action.configure.proxy.or.retry", "proxy", "retry"));
        } else {
            html.append(JavaScriptBundle.message("jshint.exception.balloon.action.retry", "retry"));
        }
        html.append("</body></html>");
        messageComponent.setText(html.toString());
        messageComponent.setEditable(false);
        if (messageComponent.getCaret() != null) {
            messageComponent.setCaretPosition(0);
        }
        messageComponent.setOpaque(false);
        messageComponent.setBackground(UIUtil.TRANSPARENT_COLOR);
        messageComponent.setForeground(UIUtil.getLabelForeground());
        JTextPane jTextPane = messageComponent;
        if (jTextPane == null) {
            JSHintUtil.$$$reportNull$$$0(6);
        }
        return jTextPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "retryCallback";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/JSHintUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createIOExceptionBalloonComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cast";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createReadonlyBrowser";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleArrow";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createIOExceptionBalloonComponent";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

