/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.javascript.dialects.JSHandlersFactory;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.modules.imports.JSImportAction;
import com.intellij.lang.javascript.modules.imports.JSImportCandidateWithExecutor;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NodeJSModulesSearcher {
    @NotNull
    private final ModuleReferenceInfo myModuleReferenceInfo;
    @NotNull
    private final PsiElement myNode;
    private final ResolveResult @NotNull [] myResolveResults;
    @NotNull
    private final Set<VirtualFile> myPredefinedFiles;

    public NodeJSModulesSearcher(@NotNull ModuleReferenceInfo info, @NotNull PsiElement node, ResolveResult @NotNull [] results, @NotNull Set<VirtualFile> predefinedFiles) {
        if (info == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(0);
        }
        if (node == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(1);
        }
        if (predefinedFiles == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(2);
        }
        if (results == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(3);
        }
        this.myModuleReferenceInfo = info;
        this.myNode = node;
        this.myResolveResults = results;
        this.myPredefinedFiles = predefinedFiles;
    }

    @NotNull
    public List<JSImportCandidateWithExecutor> find() {
        if (this.hasGlobalResolvedElement()) {
            List<JSImportCandidateWithExecutor> list = Collections.emptyList();
            if (list == null) {
                NodeJSModulesSearcher.$$$reportNull$$$0(4);
            }
            return list;
        }
        String referenceName = this.myModuleReferenceInfo.getContextName();
        if (StringUtil.isEmpty((String)referenceName)) {
            List<JSImportCandidateWithExecutor> list = Collections.emptyList();
            if (list == null) {
                NodeJSModulesSearcher.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<JSImportCandidateWithExecutor> list = this.processForName(referenceName);
        if (list == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(6);
        }
        return list;
    }

    private List<JSImportCandidateWithExecutor> processForName(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(7);
        }
        return this.getFromProviders(referenceName);
    }

    public boolean hasGlobalResolvedElement() {
        for (ResolveResult result2 : this.myResolveResults) {
            PsiFile file;
            PsiElement element = result2.getElement();
            if (element == null || (file = element.getContainingFile()) == null || !file.isValid() || !this.myPredefinedFiles.contains(file.getVirtualFile()) || !(element instanceof JSQualifiedNamedElement) || ((JSQualifiedNamedElement)element).getNamespace() != null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private List<JSImportCandidateWithExecutor> getFromProviders(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(8);
        }
        JSImportPlaceInfo placeInfo = JSHandlersFactory.forElement(this.myNode).createImportPlaceInfo(this.myNode, this.myResolveResults);
        List<JSImportCandidateWithExecutor> list = new JSImportAction(null, referenceName, placeInfo).getFilteredCandidates();
        if (list == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedFiles";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/NodeJSModulesSearcher";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/NodeJSModulesSearcher";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processForName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFromProviders";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 9 -> new IllegalStateException(string);
        };
    }
}

