/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports.providers;

import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCandidatesProcessor {
    private final @NotNull Predicate<@Nullable PsiElement> myPlaceFilter;
    private final List<JSImportCandidate> myCandidates;

    public JSCandidatesProcessor(@NotNull JSImportPlaceInfo placeInfo) {
        if (placeInfo == null) {
            JSCandidatesProcessor.$$$reportNull$$$0(0);
        }
        this.myCandidates = new SmartList();
        this.myPlaceFilter = placeInfo::isAcceptable;
    }

    public void processCandidate(@Nullable JSImportCandidate candidate) {
        if (candidate == null) {
            return;
        }
        this.myCandidates.add(candidate);
    }

    public boolean hasElements() {
        return !this.myCandidates.isEmpty();
    }

    public void clear() {
        this.myCandidates.clear();
    }

    public void remove(@NotNull String name) {
        if (name == null) {
            JSCandidatesProcessor.$$$reportNull$$$0(1);
        }
        this.myCandidates.removeIf(candidate -> candidate.getName().equals(name));
    }

    @NotNull
    public List<JSImportCandidate> getResults() {
        List<JSImportCandidate> list = this.myCandidates.stream().distinct().filter(el -> {
            PsiElement element = el.getElement();
            return this.myPlaceFilter.test(element);
        }).toList();
        if (list == null) {
            JSCandidatesProcessor.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/imports/providers/JSCandidatesProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/imports/providers/JSCandidatesProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

