/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSImportedElementResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImportHandler {
    private static final JSImportHandler INSTANCE = new JSImportHandler();

    protected JSImportHandler() {
    }

    public static JSImportHandler getInstance() {
        return INSTANCE;
    }

    public String getQualifiedNameResolvedType(@NotNull String type, @NotNull PsiElement context2) {
        if (type == null) {
            JSImportHandler.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            JSImportHandler.$$$reportNull$$$0(1);
        }
        return this.resolveMainElementName(type, context2, JSContext.UNKNOWN).getQualifiedName();
    }

    @NotNull
    public Collection<? extends PsiElement> resolveObjectOrTypeName(@NotNull String type, @NotNull PsiElement context2) {
        if (type == null) {
            JSImportHandler.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            JSImportHandler.$$$reportNull$$$0(3);
        }
        Collection<? extends PsiElement> collection = this.resolveName(type, context2).getElements();
        if (collection == null) {
            JSImportHandler.$$$reportNull$$$0(4);
        }
        return collection;
    }

    public JSTypeResolveResult resolveMainElementName(@NotNull String type, @NotNull PsiElement context2, @NotNull JSContext jsContext) {
        if (type == null) {
            JSImportHandler.$$$reportNull$$$0(5);
        }
        if (context2 == null) {
            JSImportHandler.$$$reportNull$$$0(6);
        }
        if (jsContext == null) {
            JSImportHandler.$$$reportNull$$$0(7);
        }
        return this.resolveName(type, context2);
    }

    public JSTypeResolveResult resolveTypeName(@NotNull String type, @NotNull PsiElement context2) {
        if (type == null) {
            JSImportHandler.$$$reportNull$$$0(8);
        }
        if (context2 == null) {
            JSImportHandler.$$$reportNull$$$0(9);
        }
        return this.resolveName(type, context2);
    }

    @NotNull
    public JSTypeResolveResult resolveName(@NotNull String type, @NotNull PsiElement context2) {
        if (type == null) {
            JSImportHandler.$$$reportNull$$$0(10);
        }
        if (context2 == null) {
            JSImportHandler.$$$reportNull$$$0(11);
        }
        JSTypeResolveResult jSTypeResolveResult = this.resolveName(type, context2, null);
        if (jSTypeResolveResult == null) {
            JSImportHandler.$$$reportNull$$$0(12);
        }
        return jSTypeResolveResult;
    }

    @NotNull
    public JSTypeResolveResult resolveName(@NotNull String type, @NotNull PsiElement context2, @Nullable PsiElement limitingScopeElement) {
        String text;
        PsiElement element;
        String qualifiedName;
        if (type == null) {
            JSImportHandler.$$$reportNull$$$0(13);
        }
        if (context2 == null) {
            JSImportHandler.$$$reportNull$$$0(14);
        }
        if (context2.getContainingFile() == null) {
            return new JSTypeResolveResult(type, null);
        }
        List elements = new ES6QualifiedNameResolver(context2, false, limitingScopeElement == null).resolveQualifiedName(type);
        if (elements.isEmpty() || elements.size() > JSReferenceExpressionResolver.MAX_RESULTS_COUNT_TO_KEEP) {
            return new JSTypeResolveResult(type, null);
        }
        if (limitingScopeElement != null) {
            elements = ContainerUtil.filter(elements, e -> PsiTreeUtil.isContextAncestor((PsiElement)limitingScopeElement, (PsiElement)e, (boolean)true));
        }
        if ((qualifiedName = JSImportHandler.getQualifiedName(elements)) != null) {
            type = qualifiedName;
        }
        if ((element = (PsiElement)ContainerUtil.getFirstItem((Collection)elements)) instanceof JSVariable && context2.getContainingFile() == element.getContainingFile() && (text = ((JSVariable)element).getLiteralOrReferenceInitializerText()) != null && !JSStringUtil.isStartedWithQuoteOrBackquote(text)) {
            boolean looksLikeTypeAlias = true;
            int dotIndex = text.indexOf(46);
            if (dotIndex > 0) {
                PsiElement qualifierResolve = JSStubBasedPsiTreeUtil.resolveLocally(text.substring(0, dotIndex), element);
                boolean bl = looksLikeTypeAlias = qualifierResolve == null;
            }
            if (looksLikeTypeAlias) {
                return new JSTypeResolveResult(text, elements);
            }
        }
        return new JSTypeResolveResult(type, elements);
    }

    @Nullable
    public JSImportedElementResolveResult resolveTypeNameUsingImports(@NotNull JSReferenceExpression expr) {
        if (expr == null) {
            JSImportHandler.$$$reportNull$$$0(15);
        }
        return null;
    }

    public boolean importClass(PsiScopeProcessor processor, PsiNamedElement parent) {
        return true;
    }

    @Nullable
    protected static String getQualifiedName(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            JSImportHandler.$$$reportNull$$$0(16);
        }
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSQualifiedNamedElement) || TypeScriptPsiUtil.isFromAugmentationModule(psiElement)) continue;
            return ((JSQualifiedNamedElement)psiElement).getQualifiedName();
        }
        PsiElement element = (PsiElement)ContainerUtil.getFirstItem(elements);
        return element instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)element).getQualifiedName() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSImportHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSImportHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveObjectOrTypeName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameResolvedType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveObjectOrTypeName";
                break;
            }
            case 4: 
            case 12: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveMainElementName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeName";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeNameUsingImports";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 12 -> new IllegalStateException(string);
        };
    }
}

