/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.util.SmartList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class ResultSink {
    protected int myCurrentNestingLevel = 0;
    private final IntList myNestingLevels = new IntArrayList();
    @Nullable
    private final DialectOptionHolder myHolder;
    @Nullable
    public final PsiElement place;
    @Nullable
    protected List<PsiElement> myResults;

    public ResultSink(@Nullable PsiElement _place) {
        this.place = _place;
        this.myHolder = _place != null ? DialectDetector.dialectOfElement(_place) : null;
    }

    public boolean isActionScript() {
        return this.myHolder != null && this.myHolder.isECMA4;
    }

    public boolean isTypeScript() {
        return this.myHolder != null && this.myHolder.isTypeScript;
    }

    @Nullable
    public abstract String getName();

    @Nullable
    public PsiElement getResult() {
        return this.myResults != null ? this.myResults.get(this.myResults.size() - 1) : null;
    }

    @Nullable
    public List<PsiElement> getResults() {
        return this.myResults;
    }

    public int getResultCount() {
        return this.myResults != null ? this.myResults.size() : 0;
    }

    public boolean addResult(@Nullable PsiElement element, @Nullable ResolveState state, @Nullable PsiElement placeTopParent) {
        if (this.myResults == null) {
            this.myResults = new SmartList();
        }
        this.myResults.add(element);
        this.myNestingLevels.add(this.myCurrentNestingLevel);
        return true;
    }

    protected int getNestingLevelForResultElement(PsiElement namedElement, int indexInResults) {
        int nestingLevel = this.myNestingLevels.getInt(indexInResults);
        if (namedElement instanceof ImplicitJSVariableImpl && "arguments".equals(((ImplicitJSVariableImpl)namedElement).getName())) {
            nestingLevel = -1;
        }
        if (namedElement instanceof JSProperty) {
            int max = 0;
            for (int j = 0; j < this.myNestingLevels.size(); ++j) {
                max = Math.max(max, this.myNestingLevels.getInt(indexInResults));
            }
            nestingLevel = max;
        }
        return nestingLevel;
    }

    public boolean accepts(PsiElement element) {
        return true;
    }

    public void startingParent(PsiElement parent, ResolveProcessor resolveProcessor) {
    }

    public void addCandidateResult(PsiElement element, boolean isCompleteMatch, JSResolveResult.ProblemKind problemKind) {
    }

    public boolean skipTopLevelItems() {
        return false;
    }

    public boolean needTopLevelClassName(String name) {
        return true;
    }

    public int getNestingLevel() {
        return this.myCurrentNestingLevel;
    }

    public void setNestingLevel(int nestingLevel) {
        this.myCurrentNestingLevel = nestingLevel;
    }
}

