/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeHashCodeUtil;
import com.intellij.lang.javascript.frameworks.JSFrameworkSpecificHandler;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSDistributedType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSWrapperType;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAliasTypeImpl
extends JSTypeBaseImpl
implements JSWrapperType {
    @NotNull
    private final JSType myAlias;
    @NotNull
    private final JSType myOriginal;

    public JSAliasTypeImpl(@NotNull JSType alias, @NotNull JSType expanded, @NotNull JSTypeSource source) {
        if (alias == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(0);
        }
        if (expanded == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(1);
        }
        if (source == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(2);
        }
        super(source);
        this.myAlias = alias;
        this.myOriginal = expanded;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        JSType alias;
        JSType newAlias;
        if (childTransform == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(3);
        }
        if (newSource == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(4);
        }
        if ((newAlias = JSTypeUtils.transformTypeHierarchySafe(alias = this.getAlias(), childTransform)) == alias) {
            JSAliasTypeImpl jSAliasTypeImpl = this;
            if (jSAliasTypeImpl == null) {
                JSAliasTypeImpl.$$$reportNull$$$0(5);
            }
            return jSAliasTypeImpl;
        }
        JSType newOriginal = JSTypeUtils.transformTypeHierarchySafe(this.getOriginalType(), childTransform);
        if (!JSAliasTypeImpl.shouldPreserveAlias(this, newOriginal)) {
            JSType jSType = newOriginal;
            if (jSType == null) {
                JSAliasTypeImpl.$$$reportNull$$$0(6);
            }
            return jSType;
        }
        return new JSAliasTypeImpl(newAlias, newOriginal, newSource);
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSType lId;
        if (elementType == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(7);
        }
        if (processingContext == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(8);
        }
        if ((lId = this.getIdForGuard()) != null) {
            JSType rId = JSGenericTypeImpl.getGenericOwnerIdOrSelfId(elementType);
            return JSRecursiveTypeUtil.computeGenericRecursiveTypes(lId, rId, elementType, processingContext, this::isDirectlyAssignableTypeWithOriginal);
        }
        return this.isDirectlyAssignableTypeWithOriginal(elementType, processingContext);
    }

    @Nullable
    private JSType getIdForGuard() {
        if (this.myAlias instanceof JSGenericTypeImpl) {
            return ((JSGenericTypeImpl)this.myAlias).getType();
        }
        return null;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(9);
        }
        return new JSAliasTypeImpl(this.myAlias, this.myOriginal, source);
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        if (format == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(10);
        }
        if (builder2 == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(11);
        }
        this.myAlias.buildTypeText(format, builder2);
    }

    @Override
    @NotNull
    public JSType getOriginalType() {
        JSType jSType = this.myOriginal;
        if (jSType == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(12);
        }
        return jSType;
    }

    @NotNull
    public JSType getAlias() {
        JSType jSType = this.myAlias;
        if (jSType == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(13);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordType jSRecordType = this.getOriginalType().asRecordType();
        if (jSRecordType == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(14);
        }
        return jSRecordType;
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(15);
        }
        this.getOriginalType().accept(visitor);
    }

    @Override
    protected int hashCodeImpl() {
        return JSTypeHashCodeUtil.getHashCodeSafe(this.getAlias());
    }

    private boolean isDirectlyAssignableTypeWithOriginal(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(16);
        }
        if (processingContext == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(17);
        }
        return this.getOriginalType().isDirectlyAssignableType(elementType, processingContext);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context2, boolean allowResolve) {
        if (type == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(18);
        }
        return this.getAlias().isEquivalentTo(((JSAliasTypeImpl)type).getAlias(), context2, allowResolve);
    }

    @Override
    @NotNull
    public JSType distributeType() {
        JSType originalType = this.getOriginalType();
        if (originalType instanceof JSDistributedType) {
            JSType afterType = ((JSDistributedType)((Object)originalType)).distributeType();
            JSType jSType = afterType == originalType ? this : afterType;
            if (jSType == null) {
                JSAliasTypeImpl.$$$reportNull$$$0(19);
            }
            return jSType;
        }
        JSAliasTypeImpl jSAliasTypeImpl = this;
        if (jSAliasTypeImpl == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(20);
        }
        return jSAliasTypeImpl;
    }

    @Contract(value="_, null -> false", pure=true)
    public static boolean shouldPreserveAlias(@NotNull JSType original, @Nullable JSType afterProcessing) {
        if (original == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(21);
        }
        if (afterProcessing == null) {
            return false;
        }
        if (afterProcessing instanceof JSRecordType || afterProcessing instanceof TypeScriptMappedJSTypeImpl || afterProcessing instanceof JSAliasTypeImpl && !JSAliasTypeImpl.isAliasDepthExceeded((JSAliasTypeImpl)afterProcessing)) {
            return true;
        }
        return JSAliasTypeImpl.shouldPreserveAliasForArbitraryType(original);
    }

    private static boolean shouldPreserveAliasForArbitraryType(@NotNull JSType type) {
        PsiElement element;
        if (type == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(22);
        }
        if ((element = type.getSourceElement()) != null) {
            for (JSFrameworkSpecificHandler handler : JSFrameworkSpecificHandler.EP_NAME.allForLanguage(DialectDetector.languageOfElement(element))) {
                if (!handler.shouldPreserveAlias(type)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isAliasDepthExceeded(@NotNull JSAliasTypeImpl processing) {
        if (processing == null) {
            JSAliasTypeImpl.$$$reportNull$$$0(23);
        }
        int i = 0;
        JSType currentType = processing;
        while (currentType instanceof JSAliasTypeImpl) {
            currentType = currentType.getOriginalType();
            if (++i <= 10) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 12, 13, 14, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expanded";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSAliasTypeImpl";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSAliasTypeImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlias";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "distributeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeWithOriginal";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "shouldPreserveAlias";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "shouldPreserveAliasForArbitraryType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAliasDepthExceeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 12, 13, 14, 19, 20 -> new IllegalStateException(string);
        };
    }
}

