/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSSymbolType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeFacts {
    public static final JSTypeFacts TYPE_FACTS = new JSTypeFacts();

    @NotNull
    public static SimpleFact getFactsForPrimitiveType(@NotNull String primitiveTypeName, boolean assumeTrue) {
        SimpleFact fact;
        if (primitiveTypeName == null) {
            JSTypeFacts.$$$reportNull$$$0(0);
        }
        if (assumeTrue) {
            fact = SimpleFact.typeofEQFacts.get(primitiveTypeName);
            if (fact == null) {
                SimpleFact simpleFact = SimpleFact.TypeofEQHostObject;
                if (simpleFact == null) {
                    JSTypeFacts.$$$reportNull$$$0(1);
                }
                return simpleFact;
            }
        } else {
            fact = SimpleFact.typeofNEFacts.get(primitiveTypeName);
            if (fact == null) {
                SimpleFact simpleFact = SimpleFact.TypeofNEHostObject;
                if (simpleFact == null) {
                    JSTypeFacts.$$$reportNull$$$0(2);
                }
                return simpleFact;
            }
        }
        SimpleFact simpleFact = fact;
        if (simpleFact == null) {
            JSTypeFacts.$$$reportNull$$$0(3);
        }
        return simpleFact;
    }

    @NotNull
    public Set<SimpleFact> getFacts(@Nullable JSType type, @NotNull PsiElement context2, boolean strictNullChecks) {
        if (context2 == null) {
            JSTypeFacts.$$$reportNull$$$0(4);
        }
        return this.getFacts(type, context2, strictNullChecks, null);
    }

    @NotNull
    private Set<SimpleFact> getFacts(@Nullable JSType type, @NotNull PsiElement context2, boolean strictNullChecks, @Nullable Set<JSResolvedTypeId> visited) {
        JSResolvedTypeInfo resolvedType;
        JSType constraintType;
        if (context2 == null) {
            JSTypeFacts.$$$reportNull$$$0(5);
        }
        if (type == null || visited != null && !visited.add(type.getResolvedTypeId())) {
            Set<SimpleFact> set = Collections.emptySet();
            if (set == null) {
                JSTypeFacts.$$$reportNull$$$0(6);
            }
            return set;
        }
        if ((type = JSTypeUtils.unwrapType(type.substitute())) instanceof JSStringLiteralTypeImpl) {
            JSStringLiteralTypeImpl literal = (JSStringLiteralTypeImpl)type;
            boolean isEmpty = StringUtil.isEmpty((String)literal.getLiteral());
            EnumSet<SimpleFact> enumSet = strictNullChecks ? (isEmpty ? SimpleFact.EmptyStringStrictFacts : SimpleFact.NonEmptyStringStrictFacts) : (isEmpty ? SimpleFact.EmptyStringFacts : SimpleFact.NonEmptyStringFacts);
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(7);
            }
            return enumSet;
        }
        if (type instanceof JSStringType) {
            EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.StringStrictFacts : SimpleFact.StringFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(8);
            }
            return enumSet;
        }
        if (type instanceof JSNumberLiteralTypeImpl) {
            boolean isZero;
            boolean bl = isZero = ((JSNumberLiteralTypeImpl)type).getLiteral() == 0.0;
            EnumSet<SimpleFact> enumSet = strictNullChecks ? (isZero ? SimpleFact.ZeroStrictFacts : SimpleFact.NonZeroStrictFacts) : (isZero ? SimpleFact.ZeroFacts : SimpleFact.NonZeroFacts);
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(9);
            }
            return enumSet;
        }
        if (type instanceof JSBigIntLiteralTypeImpl) {
            boolean isZero = ((JSBigIntLiteralTypeImpl)type).getLiteral().equals(BigInteger.ZERO);
            EnumSet<SimpleFact> enumSet = strictNullChecks ? (isZero ? SimpleFact.BigIntZeroStrictFacts : SimpleFact.BigIntNonZeroStrictFacts) : (isZero ? SimpleFact.BigIntZeroFacts : SimpleFact.BigIntNonZeroFacts);
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(10);
            }
            return enumSet;
        }
        if (type instanceof JSGenericParameterImpl && (constraintType = ((JSGenericParameterImpl)type).getConstraintType()) != null) {
            if (visited == null) {
                visited = new HashSet<JSResolvedTypeId>();
            }
            visited.add(type.getResolvedTypeId());
            return this.getFacts(constraintType, context2, strictNullChecks, visited);
        }
        if (type instanceof JSNumberType) {
            EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.NumberStrictFacts : SimpleFact.NumberFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(11);
            }
            return enumSet;
        }
        if (type instanceof JSBigIntType) {
            EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.BigIntStrictFacts : SimpleFact.BigIntFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(12);
            }
            return enumSet;
        }
        if (type instanceof JSResolvableType && ((resolvedType = ((JSResolvableType)type).resolveType()).isEnum() || resolvedType.isEnumLiteral())) {
            EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.NumberStrictFacts : SimpleFact.NumberFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(13);
            }
            return enumSet;
        }
        if (type instanceof JSBooleanType) {
            JSBooleanLiteralTypeImpl literalType;
            if (type instanceof JSBooleanLiteralTypeImpl && !(literalType = (JSBooleanLiteralTypeImpl)type).allowWidening()) {
                boolean value = literalType.getLiteral();
                EnumSet<SimpleFact> enumSet = strictNullChecks ? (!value ? SimpleFact.FalseStrictFacts : SimpleFact.TrueStrictFacts) : (!value ? SimpleFact.FalseFacts : SimpleFact.TrueFacts);
                if (enumSet == null) {
                    JSTypeFacts.$$$reportNull$$$0(14);
                }
                return enumSet;
            }
            EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.BooleanStrictFacts : SimpleFact.BooleanFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(15);
            }
            return enumSet;
        }
        if (type instanceof JSVoidType || type instanceof JSUndefinedType) {
            EnumSet<SimpleFact> enumSet = SimpleFact.UndefinedFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(16);
            }
            return enumSet;
        }
        if (type instanceof JSNullType) {
            EnumSet<SimpleFact> enumSet = SimpleFact.NullFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(17);
            }
            return enumSet;
        }
        if (type instanceof JSSymbolType) {
            EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.SymbolStrictFacts : SimpleFact.SymbolFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(18);
            }
            return enumSet;
        }
        if (type instanceof JSUnionOrIntersectionType) {
            if (visited == null) {
                visited = new HashSet<JSResolvedTypeId>();
            }
            return this.getTypeFactsOfTypes(((JSUnionOrIntersectionType)type).getTypes(), context2, strictNullChecks, visited);
        }
        if (type instanceof JSFunctionTypeImpl || type instanceof JSPrimitiveFunctionType) {
            EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.FunctionStrictFacts : SimpleFact.FunctionFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(19);
            }
            return enumSet;
        }
        if (!(type instanceof JSPrimitiveType) && !(type instanceof JSAnyType)) {
            if (type instanceof JSRecordType) {
                JSRecordType recordType = (JSRecordType)type;
                if (recordType.getCallSignatures().size() > 0) {
                    EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.CallableObjectStrictFacts : SimpleFact.CallableObjectFacts;
                    if (enumSet == null) {
                        JSTypeFacts.$$$reportNull$$$0(20);
                    }
                    return enumSet;
                }
                if (!recordType.hasMembers()) {
                    EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.EmptyObjectStrictFacts : SimpleFact.EmptyObjectFacts;
                    if (enumSet == null) {
                        JSTypeFacts.$$$reportNull$$$0(21);
                    }
                    return enumSet;
                }
            }
            EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.ObjectStrictFacts : SimpleFact.ObjectFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(22);
            }
            return enumSet;
        }
        EnumSet<SimpleFact> enumSet = EnumSet.of(SimpleFact.All);
        if (enumSet == null) {
            JSTypeFacts.$$$reportNull$$$0(23);
        }
        return enumSet;
    }

    @NotNull
    private Set<SimpleFact> getTypeFactsOfTypes(@NotNull Collection<JSType> types, @NotNull PsiElement context2, boolean strictNullChecks, @Nullable Set<JSResolvedTypeId> visited) {
        if (types == null) {
            JSTypeFacts.$$$reportNull$$$0(24);
        }
        if (context2 == null) {
            JSTypeFacts.$$$reportNull$$$0(25);
        }
        EnumSet<SimpleFact> result2 = EnumSet.noneOf(SimpleFact.class);
        for (JSType type : types) {
            Set<SimpleFact> facts = this.getFacts(type, context2, strictNullChecks, visited);
            if (facts.contains((Object)SimpleFact.All)) {
                Set<SimpleFact> set = facts;
                if (set == null) {
                    JSTypeFacts.$$$reportNull$$$0(26);
                }
                return set;
            }
            result2.addAll(facts);
        }
        EnumSet<SimpleFact> enumSet = result2;
        if (enumSet == null) {
            JSTypeFacts.$$$reportNull$$$0(27);
        }
        return enumSet;
    }

    @NotNull
    public JSType getTypeWithFact(@Nullable JSType type, @NotNull SimpleFact fact, @NotNull PsiElement context2, boolean strictNullChecks) {
        if (fact == null) {
            JSTypeFacts.$$$reportNull$$$0(28);
        }
        if (context2 == null) {
            JSTypeFacts.$$$reportNull$$$0(29);
        }
        JSType jSType = TypeScriptTypeRelations.filterType(type, el -> this.hasFact((JSType)el, fact, context2, strictNullChecks), context2);
        if (jSType == null) {
            JSTypeFacts.$$$reportNull$$$0(30);
        }
        return jSType;
    }

    public JSType getTypeWithFacts(@Nullable JSType type, @NotNull Set<SimpleFact> facts, @NotNull PsiElement context2, boolean strictNullChecks) {
        if (facts == null) {
            JSTypeFacts.$$$reportNull$$$0(31);
        }
        if (context2 == null) {
            JSTypeFacts.$$$reportNull$$$0(32);
        }
        return TypeScriptTypeRelations.filterType(type, el -> {
            Set<SimpleFact> currentFacts = this.getFacts((JSType)el, context2, strictNullChecks);
            if (facts.contains((Object)SimpleFact.All)) return true;
            if (!facts.stream().anyMatch(currentFacts::contains)) return false;
            return true;
        }, context2);
    }

    private boolean hasFact(@Nullable JSType type, @NotNull SimpleFact fact, @NotNull PsiElement context2, boolean strictNullChecks) {
        Set<SimpleFact> facts;
        if (fact == null) {
            JSTypeFacts.$$$reportNull$$$0(33);
        }
        if (context2 == null) {
            JSTypeFacts.$$$reportNull$$$0(34);
        }
        return (facts = this.getFacts(type, context2, strictNullChecks)).contains((Object)SimpleFact.All) || facts.contains((Object)fact);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 26, 27, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitiveTypeName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/JSTypeFacts";
                break;
            }
            case 4: 
            case 5: 
            case 25: 
            case 29: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fact";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/JSTypeFacts";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactsForPrimitiveType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacts";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFactsOfTypes";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeWithFact";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFactsForPrimitiveType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 30: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFacts";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFactsOfTypes";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithFact";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithFacts";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "hasFact";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 26, 27, 30 -> new IllegalStateException(string);
        };
    }

    public static enum SimpleFact {
        TypeofEQString,
        TypeofEQNumber,
        TypeofEQBigInt,
        TypeofEQBoolean,
        TypeofEQSymbol,
        TypeofEQObject,
        TypeofEQFunction,
        TypeofEQHostObject,
        TypeofNEString,
        TypeofNENumber,
        TypeofNEBigInt,
        TypeofNEBoolean,
        TypeofNESymbol,
        TypeofNEObject,
        TypeofNEFunction,
        TypeofNEHostObject,
        EQUndefined,
        EQNull,
        EQUndefinedOrNull,
        NEUndefined,
        NENull,
        NEUndefinedOrNull,
        Truthy,
        Falsy,
        Discriminatable,
        All;

        public static final EnumSet<SimpleFact> BaseStringStrictFacts;
        public static final EnumSet<SimpleFact> BaseStringFacts;
        public static final EnumSet<SimpleFact> StringStrictFacts;
        public static final EnumSet<SimpleFact> StringFacts;
        public static final EnumSet<SimpleFact> EmptyStringStrictFacts;
        public static final EnumSet<SimpleFact> EmptyStringFacts;
        public static final EnumSet<SimpleFact> NonEmptyStringStrictFacts;
        public static final EnumSet<SimpleFact> NonEmptyStringFacts;
        public static final EnumSet<SimpleFact> BaseNumberStrictFacts;
        public static final EnumSet<SimpleFact> BaseNumberFacts;
        public static final EnumSet<SimpleFact> NumberStrictFacts;
        public static final EnumSet<SimpleFact> NumberFacts;
        public static final EnumSet<SimpleFact> BaseBigIntStrictFacts;
        public static final EnumSet<SimpleFact> BaseBigIntFacts;
        public static final EnumSet<SimpleFact> BigIntStrictFacts;
        public static final EnumSet<SimpleFact> BigIntFacts;
        public static final EnumSet<SimpleFact> ZeroStrictFacts;
        public static final EnumSet<SimpleFact> ZeroFacts;
        public static final EnumSet<SimpleFact> BigIntZeroStrictFacts;
        public static final EnumSet<SimpleFact> BigIntZeroFacts;
        public static final EnumSet<SimpleFact> NonZeroStrictFacts;
        public static final EnumSet<SimpleFact> NonZeroFacts;
        public static final EnumSet<SimpleFact> BigIntNonZeroStrictFacts;
        public static final EnumSet<SimpleFact> BigIntNonZeroFacts;
        public static final EnumSet<SimpleFact> BaseBooleanStrictFacts;
        public static final EnumSet<SimpleFact> BaseBooleanFacts;
        public static final EnumSet<SimpleFact> BooleanStrictFacts;
        public static final EnumSet<SimpleFact> BooleanFacts;
        public static final EnumSet<SimpleFact> FalseStrictFacts;
        public static final EnumSet<SimpleFact> FalseFacts;
        public static final EnumSet<SimpleFact> TrueStrictFacts;
        public static final EnumSet<SimpleFact> TrueFacts;
        public static final EnumSet<SimpleFact> SymbolStrictFacts;
        public static final EnumSet<SimpleFact> SymbolFacts;
        private static final EnumSet<SimpleFact> HostObjectFacts;
        public static final EnumSet<SimpleFact> ObjectStrictFacts;
        public static final EnumSet<SimpleFact> ObjectFacts;
        public static final EnumSet<SimpleFact> FunctionStrictFacts;
        public static final EnumSet<SimpleFact> FunctionFacts;
        public static final EnumSet<SimpleFact> CallableObjectStrictFacts;
        public static final EnumSet<SimpleFact> CallableObjectFacts;
        public static final EnumSet<SimpleFact> UndefinedFacts;
        public static final EnumSet<SimpleFact> NullFacts;
        public static final EnumSet<SimpleFact> EmptyObjectFacts;
        public static final EnumSet<SimpleFact> EmptyObjectStrictFacts;
        static final Map<String, SimpleFact> typeofNEFacts;
        public static final Map<String, SimpleFact> typeofEQFacts;

        public static boolean hasTypeOfFact(@NotNull String simpleName) {
            if (simpleName == null) {
                SimpleFact.$$$reportNull$$$0(0);
            }
            return typeofEQFacts.containsKey(simpleName);
        }

        @NotNull
        private static EnumSet<SimpleFact> unionEnumSets(@NotNull EnumSet<SimpleFact> start, @NotNull EnumSet<SimpleFact> end) {
            if (start == null) {
                SimpleFact.$$$reportNull$$$0(1);
            }
            if (end == null) {
                SimpleFact.$$$reportNull$$$0(2);
            }
            EnumSet<SimpleFact> result2 = EnumSet.copyOf(start);
            result2.addAll(end);
            EnumSet<SimpleFact> enumSet = result2;
            if (enumSet == null) {
                SimpleFact.$$$reportNull$$$0(3);
            }
            return enumSet;
        }

        @NotNull
        private static EnumSet<SimpleFact> addValues(@NotNull EnumSet<SimpleFact> start, SimpleFact ... facts) {
            if (start == null) {
                SimpleFact.$$$reportNull$$$0(4);
            }
            if (facts == null) {
                SimpleFact.$$$reportNull$$$0(5);
            }
            EnumSet<SimpleFact> result2 = EnumSet.copyOf(start);
            ContainerUtil.addAll(result2, (Object[])facts);
            EnumSet<SimpleFact> enumSet = result2;
            if (enumSet == null) {
                SimpleFact.$$$reportNull$$$0(6);
            }
            return enumSet;
        }

        static {
            BaseStringStrictFacts = EnumSet.of(TypeofEQString, new SimpleFact[]{TypeofNEBigInt, TypeofNENumber, TypeofNEBoolean, TypeofNESymbol, TypeofNEObject, TypeofNEFunction, TypeofNEHostObject, NEUndefined, NENull, NEUndefinedOrNull});
            BaseStringFacts = SimpleFact.unionEnumSets(BaseStringStrictFacts, EnumSet.of(EQUndefined, EQNull, EQUndefinedOrNull, Falsy));
            StringStrictFacts = SimpleFact.unionEnumSets(BaseStringStrictFacts, EnumSet.of(Truthy, Falsy));
            StringFacts = SimpleFact.addValues(BaseStringFacts, Truthy);
            EmptyStringStrictFacts = SimpleFact.addValues(BaseStringStrictFacts, Falsy);
            EmptyStringFacts = BaseStringFacts;
            NonEmptyStringStrictFacts = SimpleFact.addValues(BaseStringStrictFacts, Truthy);
            NonEmptyStringFacts = SimpleFact.addValues(BaseStringFacts, Truthy);
            BaseNumberStrictFacts = EnumSet.of(TypeofEQNumber, new SimpleFact[]{TypeofNEBigInt, TypeofNEString, TypeofNEBoolean, TypeofNESymbol, TypeofNEObject, TypeofNEFunction, TypeofNEHostObject, NEUndefined, NENull, NEUndefinedOrNull});
            BaseNumberFacts = SimpleFact.addValues(BaseNumberStrictFacts, EQUndefined, EQNull, EQUndefinedOrNull, Falsy);
            NumberStrictFacts = SimpleFact.addValues(BaseNumberStrictFacts, Truthy, Falsy);
            NumberFacts = SimpleFact.addValues(BaseNumberFacts, Truthy);
            BaseBigIntStrictFacts = EnumSet.of(TypeofEQBigInt, new SimpleFact[]{TypeofNENumber, TypeofNEString, TypeofNEBoolean, TypeofNESymbol, TypeofNEObject, TypeofNEFunction, TypeofNEHostObject, NEUndefined, NENull, NEUndefinedOrNull});
            BaseBigIntFacts = SimpleFact.addValues(BaseBigIntStrictFacts, EQUndefined, EQNull, EQUndefinedOrNull, Falsy);
            BigIntStrictFacts = SimpleFact.addValues(BaseBigIntFacts, Truthy, Falsy);
            BigIntFacts = SimpleFact.addValues(BaseBigIntFacts, Truthy);
            ZeroStrictFacts = SimpleFact.addValues(BaseNumberStrictFacts, Falsy);
            ZeroFacts = BaseNumberFacts;
            BigIntZeroStrictFacts = SimpleFact.addValues(BaseBigIntStrictFacts, Falsy);
            BigIntZeroFacts = BaseBigIntFacts;
            NonZeroStrictFacts = SimpleFact.addValues(BaseNumberStrictFacts, Truthy);
            NonZeroFacts = SimpleFact.addValues(BaseNumberFacts, Truthy);
            BigIntNonZeroStrictFacts = SimpleFact.addValues(BaseBigIntStrictFacts, Truthy);
            BigIntNonZeroFacts = SimpleFact.addValues(BaseBigIntFacts, Truthy);
            BaseBooleanStrictFacts = EnumSet.of(TypeofEQBoolean, new SimpleFact[]{TypeofNEString, TypeofNEBigInt, TypeofNENumber, TypeofNESymbol, TypeofNEObject, TypeofNEFunction, TypeofNEHostObject, NEUndefined, NENull, NEUndefinedOrNull});
            BaseBooleanFacts = SimpleFact.addValues(BaseBooleanStrictFacts, EQUndefined, EQNull, EQUndefinedOrNull, Falsy);
            BooleanStrictFacts = SimpleFact.addValues(BaseBooleanStrictFacts, Truthy, Falsy);
            BooleanFacts = SimpleFact.addValues(BaseBooleanFacts, Truthy);
            FalseStrictFacts = SimpleFact.addValues(BaseBooleanStrictFacts, Falsy);
            FalseFacts = BaseBooleanFacts;
            TrueStrictFacts = SimpleFact.addValues(BaseBooleanStrictFacts, Truthy);
            TrueFacts = SimpleFact.addValues(BaseBooleanFacts, Truthy);
            SymbolStrictFacts = EnumSet.of(TypeofEQSymbol, new SimpleFact[]{TypeofNEString, TypeofNEBigInt, TypeofNENumber, TypeofNEBoolean, TypeofNEObject, TypeofNEFunction, TypeofNEHostObject, NEUndefined, NENull, NEUndefinedOrNull, Truthy});
            SymbolFacts = SimpleFact.addValues(SymbolStrictFacts, EQUndefined, EQNull, EQUndefinedOrNull, Falsy);
            HostObjectFacts = EnumSet.of(TypeofEQHostObject, new SimpleFact[]{TypeofNEString, TypeofNEBigInt, TypeofNENumber, TypeofNEBoolean, TypeofNESymbol, NEUndefined, NENull, NEUndefinedOrNull, Truthy, Discriminatable});
            ObjectStrictFacts = SimpleFact.addValues(HostObjectFacts, TypeofEQObject, TypeofNEFunction);
            ObjectFacts = SimpleFact.addValues(ObjectStrictFacts, EQUndefined, EQNull, EQUndefinedOrNull, Falsy);
            FunctionStrictFacts = SimpleFact.addValues(HostObjectFacts, TypeofEQFunction, TypeofNEObject);
            FunctionFacts = SimpleFact.addValues(FunctionStrictFacts, EQUndefined, EQNull, EQUndefinedOrNull, Falsy);
            CallableObjectStrictFacts = SimpleFact.addValues(HostObjectFacts, TypeofEQFunction, TypeofEQObject);
            CallableObjectFacts = SimpleFact.addValues(CallableObjectStrictFacts, EQUndefined, EQNull, EQUndefinedOrNull, Falsy);
            UndefinedFacts = EnumSet.of(TypeofNEString, new SimpleFact[]{TypeofNEBigInt, TypeofNENumber, TypeofNEBoolean, TypeofNESymbol, TypeofNEObject, TypeofNEFunction, TypeofNEHostObject, EQUndefined, EQUndefinedOrNull, NENull, Falsy});
            NullFacts = EnumSet.of(TypeofEQObject, new SimpleFact[]{TypeofNEString, TypeofNEBigInt, TypeofNENumber, TypeofNEBoolean, TypeofNESymbol, TypeofNEFunction, TypeofNEHostObject, EQNull, EQUndefinedOrNull, NEUndefined, Falsy});
            EmptyObjectFacts = EnumSet.of(All);
            EnumSet<SimpleFact> result2 = EnumSet.noneOf(SimpleFact.class);
            for (SimpleFact value : SimpleFact.values()) {
                if (value == All || value == EQUndefined || value == EQNull || value == EQUndefinedOrNull) continue;
                result2.add(value);
            }
            EmptyObjectStrictFacts = result2;
            typeofNEFacts = Map.of("string", TypeofNEString, "number", TypeofNENumber, "bigint", TypeofNEBigInt, "boolean", TypeofNEBoolean, "symbol", TypeofNESymbol, "undefined", NEUndefined, "object", TypeofNEObject, "function", TypeofNEFunction);
            typeofEQFacts = Map.of("string", TypeofEQString, "number", TypeofEQNumber, "bigint", TypeofEQBigInt, "boolean", TypeofEQBoolean, "symbol", TypeofEQSymbol, "undefined", EQUndefined, "object", TypeofEQObject, "function", TypeofEQFunction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "simpleName";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "start";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "end";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/JSTypeFacts$SimpleFact";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/JSTypeFacts$SimpleFact";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unionEnumSets";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "hasTypeOfFact";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "unionEnumSets";
                    break;
                }
                case 3: 
                case 6: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addValues";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 6 -> new IllegalStateException(string);
            };
        }
    }
}

