/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard.operations;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.operations.JSApplyTypeOperationContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSCompositeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSDeclaredTypeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSEmptyOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSInferDecoratorsContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class JSUnionOperation
extends JSCompositeOperation {
    @NotNull
    private final Collection<JSTypeOperation> myOperations;
    private final boolean myProcessEvolvingArrays;

    @NotNull
    public static JSTypeOperation create(@NotNull Collection<JSTypeOperation> operations, JSTypeOperation whenEmpty, boolean processEvolvingArrays) {
        if (operations == null) {
            JSUnionOperation.$$$reportNull$$$0(0);
        }
        if (operations.isEmpty()) {
            JSTypeOperation jSTypeOperation = whenEmpty;
            if (jSTypeOperation == null) {
                JSUnionOperation.$$$reportNull$$$0(1);
            }
            return jSTypeOperation;
        }
        return operations.size() == 1 ? operations.iterator().next() : new JSUnionOperation(operations, processEvolvingArrays);
    }

    @NotNull
    public static JSTypeOperation create(@NotNull JSTypeOperation left, @NotNull JSTypeOperation right, boolean processEvolvingArrays) {
        SequencedCollection<JSTypeOperation> resultTypes;
        if (left == null) {
            JSUnionOperation.$$$reportNull$$$0(2);
        }
        if (right == null) {
            JSUnionOperation.$$$reportNull$$$0(3);
        }
        if (left == right) {
            JSTypeOperation jSTypeOperation = left;
            if (jSTypeOperation == null) {
                JSUnionOperation.$$$reportNull$$$0(4);
            }
            return jSTypeOperation;
        }
        if (left == JSEmptyOperation.NO_OPERATION) {
            JSTypeOperation jSTypeOperation = right;
            if (jSTypeOperation == null) {
                JSUnionOperation.$$$reportNull$$$0(5);
            }
            return jSTypeOperation;
        }
        if (right == JSEmptyOperation.NO_OPERATION) {
            JSTypeOperation jSTypeOperation = left;
            if (jSTypeOperation == null) {
                JSUnionOperation.$$$reportNull$$$0(6);
            }
            return jSTypeOperation;
        }
        if (left instanceof JSUnionOperation || right instanceof JSUnionOperation) {
            resultTypes = new LinkedHashSet<JSTypeOperation>();
            JSUnionOperation.addFlat(resultTypes, left, JSUnionOperation.class);
            JSUnionOperation.addFlat(resultTypes, right, JSUnionOperation.class);
        } else {
            resultTypes = List.of(left, right);
        }
        return JSUnionOperation.create(resultTypes, (JSTypeOperation)JSDeclaredTypeOperation.DECLARED_TYPE, processEvolvingArrays);
    }

    private JSUnionOperation(@NotNull Collection<JSTypeOperation> operations, boolean processEvolvingArrays) {
        if (operations == null) {
            JSUnionOperation.$$$reportNull$$$0(7);
        }
        this.myOperations = operations;
        this.myProcessEvolvingArrays = processEvolvingArrays;
    }

    @Override
    @NotNull
    protected JSType applyWithoutCache(@NotNull JSApplyTypeOperationContext context2, @NotNull JSType type) {
        if (context2 == null) {
            JSUnionOperation.$$$reportNull$$$0(8);
        }
        if (type == null) {
            JSUnionOperation.$$$reportNull$$$0(9);
        }
        List<JSType> types = JSUnionOperation.getTypeFromOperations(context2, this.myOperations, type);
        if (this.myProcessEvolvingArrays && context2.isAutoArrayType()) {
            return JSUnionOperation.processEvolvingArrays(context2, types);
        }
        JSType jSType = types.size() == 1 ? types.get(0) : JSTypeGuardUtil.getUnionType(types, context2.getDefaultTypeSource());
        if (jSType == null) {
            JSUnionOperation.$$$reportNull$$$0(10);
        }
        return jSType;
    }

    @Override
    @NotNull
    public Collection<JSTypeOperation> getOperations() {
        Collection<JSTypeOperation> collection = this.myOperations;
        if (collection == null) {
            JSUnionOperation.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @NotNull
    public static JSType processEvolvingArrays(@NotNull JSApplyTypeOperationContext context2, @NotNull List<JSType> types) {
        if (context2 == null) {
            JSUnionOperation.$$$reportNull$$$0(12);
        }
        if (types == null) {
            JSUnionOperation.$$$reportNull$$$0(13);
        }
        if (context2.isAutoArrayType()) {
            boolean allEvolving = true;
            boolean hasEvolving = false;
            for (JSType type : types) {
                boolean isEvolving = context2.isEvolvingArrayType(type);
                allEvolving &= isEvolving;
                hasEvolving |= isEvolving;
            }
            if (allEvolving) {
                JSType jSType = JSUnionOperation.mergeEvolvingArrays(context2, types, context2.getDefaultTypeSource());
                if (jSType == null) {
                    JSUnionOperation.$$$reportNull$$$0(14);
                }
                return jSType;
            }
            if (hasEvolving) {
                types = ContainerUtil.map(types, el -> context2.finalizeEvolvingArrayType((JSType)el));
            }
        }
        JSType jSType = JSTypeGuardUtil.getUnionType(types, context2.getDefaultTypeSource());
        if (jSType == null) {
            JSUnionOperation.$$$reportNull$$$0(15);
        }
        return jSType;
    }

    private static JSType mergeEvolvingArrays(@NotNull JSApplyTypeOperationContext context2, @NotNull Collection<JSType> types, @NotNull JSTypeSource source) {
        if (context2 == null) {
            JSUnionOperation.$$$reportNull$$$0(16);
        }
        if (types == null) {
            JSUnionOperation.$$$reportNull$$$0(17);
        }
        if (source == null) {
            JSUnionOperation.$$$reportNull$$$0(18);
        }
        List nestedTypes = ContainerUtil.mapNotNull(types, t -> t instanceof JSArrayType ? ((JSArrayType)t).getType() : null);
        JSType unionType = JSTypeGuardUtil.getUnionType(nestedTypes, source);
        return context2.getEvolvingArrayType(unionType);
    }

    @Override
    @NotNull
    protected Set<JSDecoratedType.TypeDecoration> inferTypeDecoratorsImpl(@NotNull JSInferDecoratorsContext context2) {
        if (context2 == null) {
            JSUnionOperation.$$$reportNull$$$0(19);
        }
        EnumSet decorators = null;
        for (JSTypeOperation operation : this.getOperations()) {
            Set<JSDecoratedType.TypeDecoration> next = operation.inferTypeDecorators(context2);
            if (next.isEmpty()) {
                Set<JSDecoratedType.TypeDecoration> set = Collections.emptySet();
                if (set == null) {
                    JSUnionOperation.$$$reportNull$$$0(20);
                }
                return set;
            }
            EnumSet toAdd = next instanceof EnumSet ? (EnumSet)next : EnumSet.copyOf(next);
            if (!(decorators = decorators == null ? toAdd : ContainerUtil.intersection(decorators, toAdd)).isEmpty()) continue;
            Set<JSDecoratedType.TypeDecoration> set = Collections.emptySet();
            if (set == null) {
                JSUnionOperation.$$$reportNull$$$0(21);
            }
            return set;
        }
        Set<JSDecoratedType.TypeDecoration> set = decorators == null ? Collections.emptySet() : decorators;
        if (set == null) {
            JSUnionOperation.$$$reportNull$$$0(22);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 6, 10, 11, 14, 15, 20, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operations";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/operations/JSUnionOperation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/operations/JSUnionOperation";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "applyWithoutCache";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperations";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "processEvolvingArrays";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeDecoratorsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyWithoutCache";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processEvolvingArrays";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "mergeEvolvingArrays";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeDecoratorsImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 6, 10, 11, 14, 15, 20, 21, 22 -> new IllegalStateException(string);
        };
    }
}

