/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.frameworks;

import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.compiler.languageService.frameworks.DownloadableTypeScriptServicePlugin;
import com.intellij.lang.typescript.compiler.languageService.frameworks.PluggableTypeScriptServiceProtocol;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b'\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/frameworks/PluggableTypeScriptService;", "Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl;", "project", "Lcom/intellij/openapi/project/Project;", "servicePlugin", "Lcom/intellij/lang/typescript/compiler/languageService/frameworks/DownloadableTypeScriptServicePlugin;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/typescript/compiler/languageService/frameworks/DownloadableTypeScriptServicePlugin;)V", "isDisabledByContext", "", "context", "Lcom/intellij/openapi/vfs/VirtualFile;", "hasDependenciesReady", "createProtocol", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceProtocol;", "readyConsumer", "Ljava/util/function/Consumer;", "tsServicePath", "", "intellij.javascript.impl"})
@ApiStatus.Experimental
public abstract class PluggableTypeScriptService
extends TypeScriptServerServiceImpl {
    @NotNull
    private final DownloadableTypeScriptServicePlugin servicePlugin;

    public PluggableTypeScriptService(@NotNull Project project, @NotNull DownloadableTypeScriptServicePlugin servicePlugin) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)servicePlugin, (String)"servicePlugin");
        super(project, servicePlugin.getPackageName());
        this.servicePlugin = servicePlugin;
    }

    @Override
    public boolean isDisabledByContext(@NotNull VirtualFile context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (super.isDisabledByContext(context2)) {
            return true;
        }
        return !this.hasDependenciesReady(context2);
    }

    private final boolean hasDependenciesReady(VirtualFile context2) {
        return this.servicePlugin.getActivationRule().isTSPluginEnabledAndAvailable(this.getProject(), context2);
    }

    @Override
    @NotNull
    protected JSLanguageServiceProtocol createProtocol(@NotNull Consumer<?> readyConsumer, @NotNull String tsServicePath) {
        Intrinsics.checkNotNullParameter(readyConsumer, (String)"readyConsumer");
        Intrinsics.checkNotNullParameter((Object)tsServicePath, (String)"tsServicePath");
        return new PluggableTypeScriptServiceProtocol(this.myProject, this.mySettings, readyConsumer, this.createEventConsumer(), tsServicePath, this.servicePlugin);
    }
}

