/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupContext;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSSmartCompletionContributor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptLiteralKeyUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptLiteralType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.TypeScriptLiteralBasedPropertyElement;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTaggedLiteralKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.completion.ItemWithAction;
import com.intellij.lang.typescript.completion.TypeScriptSameSignatureCallParametersContributor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptSmartCompletionContributor
extends JSSmartCompletionContributor {
    @Override
    @Nullable
    public List<LookupElement> getSmartCompletionVariants(@NotNull JSReferenceExpression location) {
        List<LookupElement> variants;
        if (location == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(0);
        }
        if (location.getQualifier() == null && !JSResolveUtil.isExprInStrictTypeContext(location) && !(variants = this.addVariantsForUnqualifiedReference(location)).isEmpty()) {
            return variants;
        }
        return TypeScriptSmartCompletionContributor.mergeVariants(TypeScriptSmartCompletionContributor.getVariantForDynamicallyNamedProperties(location), TypeScriptSmartCompletionContributor.mergeVariants(super.getSmartCompletionVariants(location), TypeScriptSameSignatureCallParametersContributor.getSameSignatureCallItems(location)));
    }

    @Nullable
    private static List<LookupElement> getVariantForDynamicallyNamedProperties(@NotNull JSReferenceExpression location) {
        JSExpression qualifier;
        if (location == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((qualifier = JSCompletionUtil.getOriginalQualifierOrSelf(location)) == null) {
            return null;
        }
        JSType type = JSResolveUtil.getExpressionJSType(qualifier);
        if (type == null) {
            return null;
        }
        ArrayList<LookupElement> results = new ArrayList<LookupElement>();
        TypeScriptLiteralKeyUtil.evalForAllProperties(type, (PsiElement)location, (o, element, nestingDepth) -> {
            TypeScriptSmartCompletionContributor.addVariantIfComputedProp(o, results, nestingDepth, (PsiElement)location);
            return false;
        }, true);
        return results.isEmpty() ? null : results;
    }

    @Nullable
    private static JSFieldVariable getConstByInitializerType(@NotNull JSLiteralType type, @Nullable PsiElement location) {
        PsiElement sourceElement;
        if (type == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(2);
        }
        if ((sourceElement = type.getSource().getSourceElement()) instanceof JSFieldVariable && ((JSFieldVariable)sourceElement).isConst() && TypeScriptSmartCompletionContributor.canCompletePropertyName(location)) {
            return (JSFieldVariable)sourceElement;
        }
        if (!(sourceElement instanceof JSLiteralExpression)) {
            return null;
        }
        JSFieldVariable variable = (JSFieldVariable)ObjectUtils.tryCast((Object)sourceElement.getParent(), JSFieldVariable.class);
        if (variable == null || variable.getInitializerOrStub() != sourceElement) {
            return null;
        }
        return variable;
    }

    private static boolean canCompletePropertyName(@Nullable PsiElement location) {
        return location instanceof JSReferenceExpression && ((JSReferenceExpression)location).getQualifier() != null || location instanceof JSProperty;
    }

    @Nullable
    public static ItemWithAction getSpecialItemForCompletion(@NotNull JSComputedPropertyNameOwner member, @NotNull PsiElement location) {
        ES6ComputedName computedPropertyName;
        if (member == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(3);
        }
        if (location == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(4);
        }
        if ((computedPropertyName = member.getComputedPropertyName()) == null) {
            return null;
        }
        JSType computedPropertyNameType = TypeScriptLiteralKeyUtil.getTypeForComputedPropExpression(computedPropertyName);
        List<ItemWithAction> items = TypeScriptSmartCompletionContributor.getSpecialItemsForCompletion(computedPropertyNameType, location, member, true);
        return (ItemWithAction)ContainerUtil.getFirstItem(items);
    }

    @NotNull
    public static List<ItemWithAction> getSpecialItemsForCompletion(@Nullable JSType computedPropertyNameType, @NotNull PsiElement location, @Nullable JSComputedPropertyNameOwner sourceMember, boolean isPropertyName) {
        ResolveResult[] results;
        PsiElement element2;
        if (location == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(5);
        }
        LinkedList<ItemWithAction> items = new LinkedList<ItemWithAction>();
        JSType expressionJSType = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(computedPropertyNameType, location);
        if (expressionJSType instanceof JSTypeKeyTypeImpl) {
            for (PsiElement element2 : ((JSTypeKeyTypeImpl)computedPropertyNameType).getKeySourceElements()) {
                ItemWithAction indexedItem;
                PsiElement psiElement;
                ES6ComputedName name;
                String referenceName;
                if (!(element2 instanceof JSComputedPropertyNameOwner) || (referenceName = (name = ((JSComputedPropertyNameOwner)element2).getComputedPropertyName()) == null ? null : name.getExpressionAsReferenceName()) == null || !((psiElement = TypeScriptLiteralKeyUtil.resolveElementInScopeByQualifiedName(referenceName, location)) instanceof JSFieldVariable) || (indexedItem = TypeScriptSmartCompletionContributor.getIndexerItemForVariableIfAvailable(location, (JSFieldVariable)psiElement, sourceMember, isPropertyName)) == null) continue;
                items.add(indexedItem);
            }
        } else if (expressionJSType instanceof JSTaggedLiteralKeyTypeImpl && (results = ((JSTaggedLiteralKeyTypeImpl)expressionJSType).resolveKey()) != null && results.length == 1 && (element2 = results[0].getElement()) instanceof TypeScriptLiteralBasedPropertyElement) {
            ItemWithAction indexedItem;
            PsiElement parent = element2.getParent();
            if (parent instanceof TypeScriptLiteralType) {
                parent = parent.getParent();
            }
            if (parent instanceof JSFieldVariable && ((JSFieldVariable)parent).isConst() && (indexedItem = TypeScriptSmartCompletionContributor.getIndexerItemForVariableIfAvailable(location, (JSFieldVariable)parent, sourceMember, isPropertyName)) != null) {
                items.add(indexedItem);
            }
        }
        if (items.isEmpty() && expressionJSType instanceof JSStringLiteralTypeImpl) {
            indexedItem = TypeScriptSmartCompletionContributor.getIndexerItemForVariableIfAvailable(location, TypeScriptSmartCompletionContributor.getConstByInitializerType((JSLiteralType)expressionJSType, location), sourceMember, isPropertyName);
            if (indexedItem != null) {
                items.add(indexedItem);
            } else {
                String literal = ((JSStringLiteralTypeImpl)expressionJSType).getLiteral();
                char quoteChar = JSCodeStyleSettings.getQuoteChar(location);
                items.add(new ItemWithAction((String)(!isPropertyName ? quoteChar + literal + quoteChar : JSSymbolUtil.quoteIfSpecialPropertyName(literal, false, quoteChar)), null, null));
            }
        } else if (expressionJSType instanceof JSNumberLiteralTypeImpl) {
            indexedItem = TypeScriptSmartCompletionContributor.getIndexerItemForVariableIfAvailable(location, TypeScriptSmartCompletionContributor.getConstByInitializerType((JSLiteralType)expressionJSType, location), sourceMember, isPropertyName);
            if (indexedItem != null) {
                items.add(indexedItem);
            } else {
                expressionJSType = ((JSNumberLiteralTypeImpl)expressionJSType).copyWithAllowWidening(false);
                items.add(new ItemWithAction(expressionJSType.getTypeText(JSType.TypeTextFormat.CODE), null, null));
            }
        } else if (expressionJSType instanceof JSUniqueSymbolTypeImpl) {
            JSFieldVariable element3 = ((JSUniqueSymbolTypeImpl)expressionJSType).getElement();
            indexedItem = TypeScriptSmartCompletionContributor.getIndexerItemForVariableIfAvailable(location, element3, sourceMember, isPropertyName);
            if (indexedItem != null) {
                items.add(indexedItem);
            }
        } else if (expressionJSType instanceof JSResolvableType) {
            JSResolvedTypeInfo info = ((JSResolvableType)expressionJSType).resolveType();
            if (info.isEnumLiteral()) {
                indexedItem = TypeScriptSmartCompletionContributor.getIndexerItemForVariableIfAvailable(location, info.getDeclarationOfType(TypeScriptEnumField.class), sourceMember, isPropertyName);
                if (indexedItem != null) {
                    items.add(indexedItem);
                }
            } else if (!isPropertyName && info.isEnum()) {
                for (TypeScriptEnum ownEnum : info.getDeclarationsOfType(TypeScriptEnum.class)) {
                    if (ownEnum == null) continue;
                    for (JSField field : ownEnum.getFields()) {
                        ItemWithAction indexedItem = TypeScriptSmartCompletionContributor.getIndexerItemForVariableIfAvailable(location, field, sourceMember, false);
                        if (indexedItem == null) continue;
                        items.add(indexedItem);
                    }
                }
            }
        }
        LinkedList<ItemWithAction> linkedList = items;
        if (linkedList == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(6);
        }
        return linkedList;
    }

    private static ActionState getActionState(JSQualifiedNamedElement elementToImport, PsiElement location) {
        PsiFile originalFile = (PsiFile)CompletionUtil.getOriginalOrSelf((PsiElement)location.getContainingFile());
        if (elementToImport.getContainingFile() == originalFile) {
            return ActionState.Available;
        }
        JSExecutionScope scope2 = (JSExecutionScope)PsiTreeUtil.getContextOfType((PsiElement)elementToImport, (Class[])new Class[]{JSExecutionScope.class});
        if (scope2 instanceof JSModuleStatusOwner && ((JSModuleStatusOwner)((Object)scope2)).getModuleStatus() == JSModuleStatusOwner.ModuleStatus.NONE) {
            return ActionState.Available;
        }
        return elementToImport.isExported() || elementToImport.isExportedWithDefault() ? ActionState.ShouldImport : ActionState.NotAvailable;
    }

    @Nullable
    private static ItemWithAction getIndexerItemForVariableIfAvailable(@NotNull PsiElement location, @Nullable JSFieldVariable element, @Nullable JSComputedPropertyNameOwner sourceMember, boolean isPropertyName) {
        PsiElement locallyResolved;
        String referenceName;
        ActionState state;
        if (location == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(7);
        }
        if (element == null) {
            return null;
        }
        Object name = element.getName();
        if (name == null) {
            return null;
        }
        JSQualifiedNamedElement elementToImport = element;
        if (element instanceof JSField) {
            JSClass context2 = JSResolveUtil.getClassOfContext((PsiElement)element);
            if (context2 == null) {
                return null;
            }
            elementToImport = context2;
            name = context2.getName() + "." + (String)name;
        }
        if (!(state = TypeScriptSmartCompletionContributor.getActionState(elementToImport, location)).isAvailable()) {
            return null;
        }
        String lBracket = isPropertyName ? "[" : "";
        String rBracket = isPropertyName ? "]" : "";
        ES6ComputedName propertyName = sourceMember == null ? null : sourceMember.getComputedPropertyName();
        String string = referenceName = propertyName == null ? null : propertyName.getExpressionAsReferenceName();
        if (referenceName != null && (locallyResolved = JSStubBasedPsiTreeUtil.resolveLocally(referenceName, location)) != null && !((String)name).equals(referenceName)) {
            return new ItemWithAction(lBracket + referenceName + rBracket, null, (PsiElement)element);
        }
        JSQualifiedNamedElement finalElementToImport = elementToImport;
        return new ItemWithAction(lBracket + (String)name + rBracket, state.getAction(location, finalElementToImport), (PsiElement)element);
    }

    private static void importIfNeeded(PsiElement scope2, JSQualifiedNamedElement finalElementToImport) {
        ES6CreateImportUtil.insertImport(scope2, finalElementToImport, finalElementToImport.getName());
        ES6CreateImportUtil.optimizeImports(scope2);
    }

    private static void addVariantIfComputedProp(@Nullable Object member, @NotNull List<LookupElement> results, int nestingDepth, PsiElement location) {
        if (results == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(8);
        }
        if (!(member instanceof ES6Property) && !(member instanceof JSField)) {
            return;
        }
        ItemWithAction nameForCompletion = TypeScriptSmartCompletionContributor.getSpecialItemForCompletion((JSComputedPropertyNameOwner)member, location);
        if (nameForCompletion != null) {
            TypeScriptSmartCompletionContributor.addItemWithAction((PsiElement)member, results, JSLookupPriority.getNestingLevelPriority(nestingDepth), nameForCompletion, location, true);
        }
    }

    private static void addItemWithAction(@Nullable PsiElement member, @NotNull List<LookupElement> results, JSLookupPriority priority, ItemWithAction nameForCompletion, PsiElement location, boolean canHaveBrackets) {
        if (results == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(9);
        }
        results.add(JSLookupUtilImpl.createPrioritizedLookupItem(member, nameForCompletion.item, priority, false, new JSLookupContext(location), canHaveBrackets && JSInsertHandler.isIndexer(nameForCompletion.item), null, nameForCompletion.importAction));
    }

    @Override
    protected void processSingleLiteralVariant(@NotNull JSExpression location, boolean insideStringLiteral, @NotNull List<LookupElement> literalVariants, JSType type) {
        List<ItemWithAction> items;
        if (location == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(10);
        }
        if (literalVariants == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(11);
        }
        if (!insideStringLiteral && !(items = TypeScriptSmartCompletionContributor.getSpecialItemsForCompletion(type, (PsiElement)location, null, false)).isEmpty()) {
            for (ItemWithAction item : items) {
                TypeScriptSmartCompletionContributor.addItemWithAction(item.element, literalVariants, JSLookupPriority.SMART_PRIORITY, item, (PsiElement)location, false);
            }
            return;
        }
        super.processSingleLiteralVariant(location, insideStringLiteral, literalVariants, type);
    }

    @Override
    protected void addVariantsForUnqualifiedExpectedType(@NotNull JSType expectedType, @NotNull JSReferenceExpression location, @NotNull List<LookupElement> variants) {
        List<LookupElement> result2;
        if (expectedType == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(12);
        }
        if (location == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(13);
        }
        if (variants == null) {
            TypeScriptSmartCompletionContributor.$$$reportNull$$$0(14);
        }
        if ((result2 = this.getLiteralVariantsForExpectedType(location, false, expectedType)) != null) {
            variants.addAll(result2);
        }
        super.addVariantsForUnqualifiedExpectedType(expectedType, location, variants);
    }

    @Override
    protected boolean needToQualify(int qualifiedStaticVariantsStart, int i) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/completion/TypeScriptSmartCompletionContributor";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalVariants";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/completion/TypeScriptSmartCompletionContributor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecialItemsForCompletion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSmartCompletionVariants";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVariantForDynamicallyNamedProperties";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConstByInitializerType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSpecialItemForCompletion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSpecialItemsForCompletion";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIndexerItemForVariableIfAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addVariantIfComputedProp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addItemWithAction";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processSingleLiteralVariant";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addVariantsForUnqualifiedExpectedType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private static enum ActionState {
        Available,
        NotAvailable,
        ShouldImport;


        public boolean isAvailable() {
            return this == Available || this == ShouldImport;
        }

        @Nullable
        public Runnable getAction(PsiElement location, JSQualifiedNamedElement finalElementToImport) {
            if (this == Available) {
                return null;
            }
            PsiElement module = ES6PsiUtil.findExternalModule(location);
            if (module == null) {
                return null;
            }
            PsiElement originalElement = CompletionUtil.getOriginalOrSelf((PsiElement)module);
            return () -> TypeScriptSmartCompletionContributor.importIfNeeded(originalElement, finalElementToImport);
        }
    }
}

