/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TypeScriptFunctionSignatureChecker
extends JSFunctionSignatureChecker {
    public TypeScriptFunctionSignatureChecker(JSTypeChecker typeChecker) {
        super(typeChecker);
    }

    @Override
    protected void registerProblem(JSCallExpression callExpression, @NotNull @InspectionMessage String message, LocalQuickFix ... fixes) {
        if (message == null) {
            TypeScriptFunctionSignatureChecker.$$$reportNull$$$0(0);
        }
        if (fixes == null) {
            TypeScriptFunctionSignatureChecker.$$$reportNull$$$0(1);
        }
        PsiElement place = ValidateTypesUtil.getPlaceForSignatureProblem(callExpression, callExpression.getArgumentList());
        ProblemHighlightType highlightType = ProblemHighlightType.GENERIC_ERROR;
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression && !TypeScriptUtil.resolveIsStrict((JSReferenceExpression)methodExpression)) {
            highlightType = ProblemHighlightType.WEAK_WARNING;
        }
        this.myTypeChecker.registerProblem(place, message, highlightType, fixes);
    }

    @Override
    protected boolean isCallableType(boolean inNewExpression, @NotNull JSType type, PsiElement context2) {
        if (type == null) {
            TypeScriptFunctionSignatureChecker.$$$reportNull$$$0(2);
        }
        if (type instanceof JSUnionType) {
            for (JSType part : ((JSUnionType)type).getTypes()) {
                if (this.isCallableType(inNewExpression, part, context2)) continue;
                return false;
            }
        }
        return super.isCallableType(inNewExpression, type, context2);
    }

    @Override
    protected boolean obtainNextMatchedParams(int[] matchedParams, JSParameterItem[] parameters) {
        return false;
    }

    private boolean processMethodExpressionResolveResult(JSCallExpression callExpression, JSReferenceExpression methodExpression, PsiElement resolveResult, JSType type, @NotNull Set<PsiElement> visited) {
        if (visited == null) {
            TypeScriptFunctionSignatureChecker.$$$reportNull$$$0(3);
        }
        if (callExpression instanceof JSNewExpression) {
            if (resolveResult instanceof TypeScriptImportStatement) {
                for (PsiElement psiElement : ((TypeScriptImportStatement)resolveResult).findReferencedElements()) {
                    if (!visited.add(psiElement) || !this.processMethodExpressionResolveResult(callExpression, methodExpression, psiElement, type, visited)) continue;
                    return false;
                }
            } else if (resolveResult instanceof TypeScriptClass) {
                if (this.checkClassInstantiate(callExpression, resolveResult)) {
                    return false;
                }
            } else {
                JSResolvedTypeInfo jSResolvedTypeInfo;
                JSType valuableType = JSTypeUtils.getValuableType(type, (PsiElement)callExpression);
                if (valuableType instanceof JSResolvableType && (jSResolvedTypeInfo = ((JSResolvableType)valuableType).resolveType()).isAbstract()) {
                    this.myTypeChecker.registerProblem((PsiElement)callExpression, JavaScriptBundle.message("typescript.validation.message.abstract.class.be.created", valuableType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)), null, new LocalQuickFix[0]);
                }
            }
        }
        return super.processMethodExpressionResolveResult(callExpression, methodExpression, resolveResult, type);
    }

    @Override
    protected boolean processMethodExpressionResolveResult(JSCallExpression callExpression, JSReferenceExpression methodExpression, PsiElement resolveResult, JSType type) {
        return this.processMethodExpressionResolveResult(callExpression, methodExpression, resolveResult, type, new HashSet<PsiElement>());
    }

    private boolean checkClassInstantiate(JSCallExpression callExpression, PsiElement resolveResult) {
        if (resolveResult instanceof JSClass) {
            JSClass classElement = (JSClass)resolveResult;
            if (TypeScriptPsiUtil.isAbstractElement(classElement)) {
                this.myTypeChecker.registerProblem((PsiElement)callExpression, JavaScriptBundle.message("typescript.validation.message.abstract.class.be.created", classElement.getName()), null, new LocalQuickFix[0]);
                return true;
            }
            if (classElement.isInterface()) {
                this.myTypeChecker.registerProblem((PsiElement)callExpression, JavaScriptBundle.message("javascript.interface.can.not.be.instantiated.message", new Object[0]), null, new LocalQuickFix[0]);
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/validation/TypeScriptFunctionSignatureChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallableType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processMethodExpressionResolveResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

