/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.json.JsonLexer;
import org.jetbrains.letsPlot.commons.intern.json.JsonSupportKt;
import org.jetbrains.letsPlot.commons.intern.json.Token;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u0004\u0018\u00010\u0001J\u001e\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/json/JsonParser;", "", "json", "", "(Ljava/lang/String;)V", "parseArray", "", "lexer", "Lorg/jetbrains/letsPlot/commons/intern/json/JsonLexer;", "parseJson", "parseObject", "", "parseValue", "require", "", "current", "Lorg/jetbrains/letsPlot/commons/intern/json/Token;", "expected", "messagePrefix", "JsonException", "commons"})
@SourceDebugExtension(value={"SMAP\nJsonParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonParser.kt\norg/jetbrains/letsPlot/commons/intern/json/JsonParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class JsonParser {
    @NotNull
    private final String json;

    public JsonParser(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.json = json;
    }

    @Nullable
    public final Object parseJson() {
        JsonLexer lexer = new JsonLexer(this.json);
        return this.parseValue(lexer);
    }

    private final Object parseValue(JsonLexer lexer) {
        Object object;
        Token token = lexer.getCurrentToken();
        switch (token == null ? -1 : WhenMappings.$EnumSwitchMapping$0[token.ordinal()]) {
            case 1: {
                String string;
                String it = string = JsonSupportKt.unescape(lexer.tokenValue());
                boolean bl = false;
                lexer.nextToken();
                object = string;
                break;
            }
            case 2: {
                Double d = Double.parseDouble(lexer.tokenValue());
                double it = ((Number)d).doubleValue();
                boolean bl = false;
                lexer.nextToken();
                object = d;
                break;
            }
            case 3: {
                Boolean bl = false;
                boolean it = bl;
                boolean bl2 = false;
                lexer.nextToken();
                object = bl;
                break;
            }
            case 4: {
                Boolean bl = true;
                boolean it = bl;
                boolean bl3 = false;
                lexer.nextToken();
                object = bl;
                break;
            }
            case 5: {
                Object var2_6;
                Object it = var2_6 = null;
                boolean bl = false;
                lexer.nextToken();
                object = var2_6;
                break;
            }
            case 6: {
                object = this.parseObject(lexer);
                break;
            }
            case 7: {
                object = this.parseArray(lexer);
                break;
            }
            default: {
                throw new IllegalStateException(("Invalid token: " + (Object)((Object)lexer.getCurrentToken())).toString());
            }
        }
        return object;
    }

    private final List<Object> parseArray(JsonLexer lexer) {
        List list2 = new ArrayList();
        JsonParser.parseArray$checkCurrentToken(this, lexer, Token.LEFT_BRACKET);
        lexer.nextToken();
        while (lexer.getCurrentToken() != Token.RIGHT_BRACKET) {
            if (!((Collection)list2).isEmpty()) {
                JsonParser.parseArray$checkCurrentToken(this, lexer, Token.COMMA);
                lexer.nextToken();
            }
            list2.add(this.parseValue(lexer));
        }
        JsonParser.parseArray$checkCurrentToken(this, lexer, Token.RIGHT_BRACKET);
        lexer.nextToken();
        return list2;
    }

    private final Map<String, Object> parseObject(JsonLexer lexer) {
        Map map2 = new LinkedHashMap();
        JsonParser.parseObject$checkCurrentToken$5(this, lexer, Token.LEFT_BRACE);
        lexer.nextToken();
        while (lexer.getCurrentToken() != Token.RIGHT_BRACE) {
            if (!map2.isEmpty()) {
                JsonParser.parseObject$checkCurrentToken$5(this, lexer, Token.COMMA);
                lexer.nextToken();
            }
            JsonParser.parseObject$checkCurrentToken$5(this, lexer, Token.STRING);
            String key = JsonSupportKt.unescape(lexer.tokenValue());
            lexer.nextToken();
            JsonParser.parseObject$checkCurrentToken$5(this, lexer, Token.COLON);
            lexer.nextToken();
            Object value = this.parseValue(lexer);
            map2.put(key, value);
        }
        JsonParser.parseObject$checkCurrentToken$5(this, lexer, Token.RIGHT_BRACE);
        lexer.nextToken();
        return map2;
    }

    private final void require(Token current, Token expected, String messagePrefix) {
        if (current != expected) {
            throw new JsonException(messagePrefix + "Expected token: " + (Object)((Object)expected) + ", actual: " + (Object)((Object)current));
        }
    }

    static /* synthetic */ void require$default(JsonParser jsonParser, Token token, Token token2, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        jsonParser.require(token, token2, string);
    }

    private static final void parseArray$checkCurrentToken(JsonParser this$0, JsonLexer $lexer, Token token) {
        this$0.require($lexer.getCurrentToken(), token, "[Arr] ");
    }

    private static final void parseObject$checkCurrentToken$5(JsonParser this$0, JsonLexer $lexer, Token token) {
        this$0.require($lexer.getCurrentToken(), token, "[Obj] ");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/json/JsonParser$JsonException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "commons"})
    public static final class JsonException
    extends Exception {
        public JsonException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Token.values().length];
            try {
                nArray[Token.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.NUMBER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.FALSE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.TRUE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.NULL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.LEFT_BRACE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.LEFT_BRACKET.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

